/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.problem.IProblemCategory;
import org.eclipse.dltk.internal.javascript.ti.AbstractReference;
import org.eclipse.dltk.internal.javascript.ti.AnonymousValue;
import org.eclipse.dltk.internal.javascript.ti.ConstantValue;
import org.eclipse.dltk.internal.javascript.ti.FunctionValueCollection;
import org.eclipse.dltk.internal.javascript.ti.ITypeInferenceContext;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.JSMethod;
import org.eclipse.dltk.internal.javascript.ti.JSVariable;
import org.eclipse.dltk.internal.javascript.ti.LazyTypeReference;
import org.eclipse.dltk.internal.javascript.ti.NestedValueCollection;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencerVisitorBase;
import org.eclipse.dltk.internal.javascript.ti.WithValueCollection;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.javascript.ast.ArrayInitializer;
import org.eclipse.dltk.javascript.ast.AsteriskExpression;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.BooleanLiteral;
import org.eclipse.dltk.javascript.ast.BreakStatement;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.CaseClause;
import org.eclipse.dltk.javascript.ast.CatchClause;
import org.eclipse.dltk.javascript.ast.CommaExpression;
import org.eclipse.dltk.javascript.ast.ConditionalOperator;
import org.eclipse.dltk.javascript.ast.ConstStatement;
import org.eclipse.dltk.javascript.ast.ContinueStatement;
import org.eclipse.dltk.javascript.ast.DecimalLiteral;
import org.eclipse.dltk.javascript.ast.DefaultXmlNamespaceStatement;
import org.eclipse.dltk.javascript.ast.DeleteStatement;
import org.eclipse.dltk.javascript.ast.DoWhileStatement;
import org.eclipse.dltk.javascript.ast.EmptyExpression;
import org.eclipse.dltk.javascript.ast.EmptyStatement;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ForEachInStatement;
import org.eclipse.dltk.javascript.ast.ForInStatement;
import org.eclipse.dltk.javascript.ast.ForStatement;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetAllChildrenExpression;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.GetLocalNameExpression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.IfStatement;
import org.eclipse.dltk.javascript.ast.LabelledStatement;
import org.eclipse.dltk.javascript.ast.NewExpression;
import org.eclipse.dltk.javascript.ast.NullExpression;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.ObjectInitializerPart;
import org.eclipse.dltk.javascript.ast.ParenthesizedExpression;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.RegExpLiteral;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.ast.SwitchComponent;
import org.eclipse.dltk.javascript.ast.SwitchStatement;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.ThrowStatement;
import org.eclipse.dltk.javascript.ast.TryStatement;
import org.eclipse.dltk.javascript.ast.TypeOfExpression;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VariableStatement;
import org.eclipse.dltk.javascript.ast.VoidExpression;
import org.eclipse.dltk.javascript.ast.VoidOperator;
import org.eclipse.dltk.javascript.ast.WhileStatement;
import org.eclipse.dltk.javascript.ast.WithStatement;
import org.eclipse.dltk.javascript.ast.XmlAttributeIdentifier;
import org.eclipse.dltk.javascript.ast.XmlExpressionFragment;
import org.eclipse.dltk.javascript.ast.XmlFragment;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.ast.XmlTextFragment;
import org.eclipse.dltk.javascript.ast.YieldOperator;
import org.eclipse.dltk.javascript.parser.PropertyExpressionUtils;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IMemberEvaluator;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.ReferenceSource;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.TypeMode;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.ClassType;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelFactory;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.typeinfo.model.TypeRef;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TypeInferencerVisitor
extends TypeInferencerVisitorBase {
    private final Stack<Branching> branchings = new Stack();
    private static final int K_NUMBER = 1;
    private static final int K_STRING = 2;
    private static final int K_OTHER = 4;
    private static final DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder docBuilder;

    public TypeInferencerVisitor(ITypeInferenceContext context) {
        super(context);
    }

    protected Branching branching() {
        Branching branching = new Branching();
        this.branchings.add(branching);
        return branching;
    }

    public ReferenceSource getSource() {
        ReferenceSource source = this.context.getSource();
        return source != null ? source : ReferenceSource.UNKNOWN;
    }

    protected void assign(IValueReference dest, IValueReference src) {
        JSType srcType;
        JSType destType = JavaScriptValidations.typeOf(dest);
        if (destType != null && TypeInferencerVisitor.isXML(destType) && (srcType = JavaScriptValidations.typeOf(src)) != null && !TypeInferencerVisitor.isXML(srcType)) {
            return;
        }
        if (this.branchings.isEmpty()) {
            dest.setValue(src);
        } else {
            dest.addValue(src, false);
        }
    }

    private static boolean isXML(JSType srcType) {
        return "XML".equals(srcType.getName()) || "XMLList".equals(srcType.getName());
    }

    public IValueReference visitArrayInitializer(ArrayInitializer node) {
        int kind = 0;
        for (ASTNode astNode : node.getItems()) {
            if (astNode instanceof StringLiteral) {
                kind |= 2;
                continue;
            }
            if (astNode instanceof DecimalLiteral) {
                kind |= 1;
                continue;
            }
            if (astNode instanceof NullExpression) continue;
            kind |= 4;
            this.visit(astNode);
        }
        if (kind == 2) {
            return this.context.getFactory().create(this.peekContext(), TypeUtil.arrayOf(this.context.getTypeRef("String")));
        }
        if (kind == 1) {
            return this.context.getFactory().create(this.peekContext(), TypeUtil.arrayOf(this.context.getTypeRef("Number")));
        }
        return this.context.getFactory().createArray(this.peekContext());
    }

    public IValueReference visitAsteriskExpression(AsteriskExpression node) {
        return this.context.getFactory().createXMLList(this.peekContext());
    }

    public IValueReference visitBinaryOperation(BinaryOperation node) {
        IValueReference left = this.visit((ASTNode)node.getLeftExpression());
        int op = node.getOperation();
        if (104 == op) {
            if (left != null && left.exists()) {
                IValueReference r;
                left.setAttribute("RESOLVING", Boolean.TRUE);
                try {
                    r = this.visit((ASTNode)node.getRightExpression());
                }
                finally {
                    left.setAttribute("RESOLVING", null);
                }
                return this.visitAssign(left, r, node);
            }
            return this.visitAssign(left, this.visit((ASTNode)node.getRightExpression()), node);
        }
        IValueReference right = this.visit((ASTNode)node.getRightExpression());
        if (left == null && right instanceof ConstantValue) {
            return right;
        }
        if (op == 100) {
            return TypeInferencerVisitor.coalesce(right, left);
        }
        if (op == 79 || op == 81 || op == 78 || op == 80 || op == 85 || op == 84 || op == 83 || op == 82) {
            return this.context.getFactory().createBoolean(this.peekContext());
        }
        if (this.isNumber(left) && this.isNumber(right)) {
            return this.context.getFactory().createNumber(this.peekContext());
        }
        if (op == 86) {
            if (this.isString(left) || this.isString(right)) {
                return this.context.getFactory().createString(this.peekContext());
            }
            return left;
        }
        if (21 == op) {
            return this.context.getFactory().createBoolean(this.peekContext());
        }
        if (101 == op) {
            JSTypeSet typeSet = JSTypeSet.create();
            if (left != null) {
                typeSet.addAll(left.getDeclaredTypes());
                typeSet.addAll(left.getTypes());
            }
            if (right != null) {
                typeSet.addAll(right.getDeclaredTypes());
                typeSet.addAll(right.getTypes());
            }
            return new ConstantValue(typeSet);
        }
        return null;
    }

    private static IValueReference coalesce(IValueReference v1, IValueReference v2) {
        return v1 != null ? v1 : v2;
    }

    private boolean isNumber(IValueReference ref) {
        if (ref != null) {
            Type numType = this.context.getType("Number");
            if (ref.getTypes().contains(numType)) {
                return true;
            }
            if (numType.equals(ref.getDeclaredType())) {
                return true;
            }
        }
        return false;
    }

    private boolean isString(IValueReference ref) {
        if (ref != null) {
            Type strType = this.context.getType("String");
            if (ref.getTypes().contains(strType)) {
                return true;
            }
            if (strType.equals(ref.getDeclaredType())) {
                return true;
            }
        }
        return false;
    }

    protected IValueReference visitAssign(IValueReference left, IValueReference right, BinaryOperation node) {
        if (left != null) {
            PropertyExpression property;
            if (node.getLeftExpression() instanceof PropertyExpression && (property = (PropertyExpression)node.getLeftExpression()).getObject() instanceof ThisExpression && property.getProperty() instanceof Identifier && !left.exists()) {
                if (TypeInferencerVisitor.isFunctionDeclaration((Expression)property)) {
                    left.setKind(ReferenceKind.FUNCTION);
                } else {
                    left.setKind(ReferenceKind.FIELD);
                }
                left.setLocation(ReferenceLocation.create(this.getSource(), property.sourceStart(), property.sourceEnd(), property.getProperty().sourceStart(), property.getProperty().sourceEnd()));
            }
            if ("[]".equals(left.getName()) && node.getLeftExpression() instanceof GetArrayItemExpression) {
                GetArrayItemExpression arrayItemExpression = (GetArrayItemExpression)node.getLeftExpression();
                IValueReference namedChild = this.extractNamedChild(left.getParent(), arrayItemExpression.getIndex());
                if (namedChild != null) {
                    this.assign(namedChild, right);
                } else {
                    this.assign(left, right);
                }
            } else if (!this.hasUnknowParentFunctionCall(left)) {
                this.assign(left, right);
            }
        }
        return right;
    }

    private boolean hasUnknowParentFunctionCall(IValueReference reference) {
        IValueReference parent = reference.getParent();
        while (parent != null) {
            if (parent.getName().equals("()") && !parent.exists()) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public IValueReference visitBooleanLiteral(BooleanLiteral node) {
        return this.context.getFactory().createBoolean(this.peekContext());
    }

    public IValueReference visitBreakStatement(BreakStatement node) {
        return null;
    }

    public IValueReference visitCallExpression(CallExpression node) {
        IValueReference reference = this.visit((ASTNode)node.getExpression());
        for (ASTNode argument : node.getArguments()) {
            this.visit(argument);
        }
        if (reference != null) {
            return reference.getChild("()");
        }
        return null;
    }

    public IValueReference visitCommaExpression(CommaExpression node) {
        return (IValueReference)this.visit(node.getItems());
    }

    public IValueReference visitConditionalOperator(ConditionalOperator node) {
        this.visit((ASTNode)node.getCondition());
        return this.merge(this.visit((ASTNode)node.getTrueValue()), this.visit((ASTNode)node.getFalseValue()));
    }

    public IValueReference visitConstDeclaration(ConstStatement node) {
        IValueCollection context = this.peekContext();
        for (VariableDeclaration declaration : node.getVariables()) {
            IValueReference constant = this.createVariable(context, declaration);
            if (constant == null) continue;
            constant.setAttribute("CONSTANT", Boolean.TRUE);
        }
        return null;
    }

    protected IValueReference createVariable(IValueCollection context, VariableDeclaration declaration) {
        Identifier identifier = declaration.getIdentifier();
        String varName = identifier.getName();
        IValueReference reference = context.createChild(varName);
        JSVariable variable = new JSVariable();
        variable.setName(declaration.getVariableName());
        if (declaration.getParent() instanceof VariableStatement) {
            VariableStatement cfr_ignored_0 = (VariableStatement)declaration.getParent();
            IModelBuilder[] iModelBuilderArray = this.context.getModelBuilders();
            int n = iModelBuilderArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModelBuilder extension = iModelBuilderArray[n2];
                extension.processVariable(declaration, variable, this.reporter, this.getJSDocTypeChecker());
                ++n2;
            }
        }
        reference.setAttribute("VARIABLE", variable);
        reference.setKind(this.inFunction() ? ReferenceKind.LOCAL : ReferenceKind.GLOBAL);
        reference.setLocation(ReferenceLocation.create(this.getSource(), declaration.sourceStart(), declaration.sourceEnd(), identifier.sourceStart(), identifier.sourceEnd()));
        this.initializeVariable(reference, declaration, variable);
        this.setTypeImpl(reference, variable.getType());
        return reference;
    }

    protected void initializeVariable(IValueReference reference, VariableDeclaration declaration, IModelBuilder.IVariable variable) {
        if (declaration.getInitializer() != null) {
            IValueReference assignment;
            reference.setAttribute("RESOLVING", Boolean.TRUE);
            try {
                assignment = this.visit((ASTNode)declaration.getInitializer());
            }
            finally {
                reference.setAttribute("RESOLVING", null);
            }
            if (assignment != null) {
                this.assign(reference, assignment);
                if (assignment.getKind() == ReferenceKind.FUNCTION && reference.getAttribute("PARAMETERS") != null) {
                    reference.setKind(ReferenceKind.FUNCTION);
                }
            }
        }
    }

    public IValueReference visitContinueStatement(ContinueStatement node) {
        return null;
    }

    public IValueReference visitDecimalLiteral(DecimalLiteral node) {
        return this.context.getFactory().createNumber(this.peekContext());
    }

    public IValueReference visitDefaultXmlNamespace(DefaultXmlNamespaceStatement node) {
        this.visit((ASTNode)node.getValue());
        return null;
    }

    public IValueReference visitDeleteStatement(DeleteStatement node) {
        IValueReference value = this.visit((ASTNode)node.getExpression());
        if (value != null) {
            value.delete();
        }
        return this.context.getFactory().createBoolean(this.peekContext());
    }

    public IValueReference visitDoWhileStatement(DoWhileStatement node) {
        this.visit((ASTNode)node.getCondition());
        this.visit((ASTNode)node.getBody());
        return null;
    }

    public IValueReference visitEmptyExpression(EmptyExpression node) {
        return null;
    }

    public IValueReference visitEmptyStatement(EmptyStatement node) {
        return null;
    }

    public IValueReference visitForEachInStatement(ForEachInStatement node) {
        IValueReference itemReference = this.visit((ASTNode)node.getItem());
        IValueReference iteratorReference = this.visit((ASTNode)node.getIterator());
        JSType type = JavaScriptValidations.typeOf(iteratorReference);
        if (type != null) {
            if (type instanceof ArrayType && JavaScriptValidations.typeOf(itemReference) == null) {
                JSType itemType = ((ArrayType)type).getItemType();
                this.setTypeImpl(itemReference, itemType);
            } else if (type instanceof MapType && JavaScriptValidations.typeOf(itemReference) == null) {
                JSType itemType = ((MapType)type).getValueType();
                this.setTypeImpl(itemReference, itemType);
            } else if ("XMLList".equals(type.getName())) {
                itemReference.setDeclaredType(this.context.getTypeRef("XML"));
            }
        }
        this.visit((ASTNode)node.getBody());
        return null;
    }

    public IValueReference visitForInStatement(ForInStatement node) {
        IValueReference item = this.visit((ASTNode)node.getItem());
        if (item != null) {
            this.assign(item, this.context.getFactory().createString(this.peekContext()));
        }
        this.visit((ASTNode)node.getIterator());
        this.visit((ASTNode)node.getBody());
        return null;
    }

    public IValueReference visitForStatement(ForStatement node) {
        if (node.getInitial() != null) {
            this.visit((ASTNode)node.getInitial());
        }
        if (node.getCondition() != null) {
            this.visit((ASTNode)node.getCondition());
        }
        if (node.getStep() != null) {
            this.visit((ASTNode)node.getStep());
        }
        if (node.getBody() != null) {
            this.visit((ASTNode)node.getBody());
        }
        return null;
    }

    public IValueReference visitFunctionStatement(FunctionStatement node) {
        JSMethod method = this.generateJSMethod(node);
        FunctionValueCollection function = new FunctionValueCollection(this.peekContext(), method.getName());
        for (IModelBuilder.IParameter parameter : method.getParameters()) {
            IValueReference refArg = function.createChild(parameter.getName());
            refArg.setKind(ReferenceKind.ARGUMENT);
            this.setTypeImpl(refArg, parameter.getType());
            refArg.setLocation(parameter.getLocation());
        }
        node.getName();
        IValueReference result = TypeInferencerVisitor.isChildFunction(node) ? this.peekContext().createChild(method.getName()) : new AnonymousValue();
        result.setLocation(method.getLocation());
        result.setKind(ReferenceKind.FUNCTION);
        result.setDeclaredType(this.context.getTypeRef("Function"));
        result.setAttribute("PARAMETERS", method);
        result.setAttribute("FUNCTION_SCOPE", function);
        result.setAttribute("RESOLVING", Boolean.TRUE);
        this.enterContext(function);
        HashSet suppressed = null;
        try {
            if (this.reporter != null && !method.getSuppressedWarnings().isEmpty()) {
                suppressed = new HashSet();
                for (IProblemCategory category : method.getSuppressedWarnings()) {
                    suppressed.addAll(category.contents());
                }
                this.reporter.pushSuppressWarnings(suppressed);
            }
            this.visitFunctionBody(node);
        }
        finally {
            if (this.reporter != null && suppressed != null) {
                this.reporter.popSuppressWarnings();
            }
            this.leaveContext();
            result.setAttribute("RESOLVING", null);
        }
        IValueReference returnValue = result.getChild("()");
        returnValue.addValue(function.getReturnValue(), true);
        this.setTypeImpl(returnValue, method.getType());
        return result;
    }

    protected static boolean isChildFunction(FunctionStatement node) {
        return node.getName() != null && !(node.getParent() instanceof BinaryOperation) && !(node.getParent() instanceof VariableDeclaration) && !(node.getParent() instanceof PropertyInitializer) && !(node.getParent() instanceof NewExpression);
    }

    protected JSMethod generateJSMethod(FunctionStatement node) {
        JSMethod method = new JSMethod(node, this.getSource());
        IModelBuilder[] iModelBuilderArray = this.context.getModelBuilders();
        int n = iModelBuilderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModelBuilder extension = iModelBuilderArray[n2];
            extension.processMethod(node, method, this.reporter, this.getJSDocTypeChecker());
            ++n2;
        }
        return method;
    }

    public void visitFunctionBody(FunctionStatement node) {
        this.visit((ASTNode)node.getBody());
    }

    public void setType(ASTNode node, IValueReference value, JSType type, boolean lazy) {
        this.setTypeImpl(value, type);
    }

    private void setTypeImpl(IValueReference value, JSType type) {
        if (type != null) {
            Assert.isTrue(((type = this.context.resolveTypeRef(type)).getKind() != TypeKind.UNRESOLVED ? 1 : 0) != 0);
            if (type.getKind() != TypeKind.UNKNOWN) {
                value.setDeclaredType(type);
                if (type instanceof TypeRef && value instanceof IValueProvider) {
                    IMemberEvaluator[] iMemberEvaluatorArray = TypeInfoManager.getMemberEvaluators();
                    int n = iMemberEvaluatorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemberEvaluator evaluator = iMemberEvaluatorArray[n2];
                        IValueCollection collection = evaluator.valueOf(this.context, ((TypeRef)type).getTarget());
                        if (collection != null && collection instanceof IValueProvider) {
                            ((IValueProvider)((Object)value)).getValue().addValue(((IValueProvider)((Object)collection)).getValue());
                        }
                        ++n2;
                    }
                }
            } else if (type instanceof TypeRef) {
                value.addValue(new LazyTypeReference(this.context, type.getName(), this.peekContext()), false);
            }
        }
    }

    public IValueReference visitGetAllChildrenExpression(GetAllChildrenExpression node) {
        return this.context.getFactory().createXMLList(this.peekContext());
    }

    public IValueReference visitGetArrayItemExpression(GetArrayItemExpression node) {
        IValueReference array = this.visit((ASTNode)node.getArray());
        this.visit((ASTNode)node.getIndex());
        if (array != null) {
            IValueReference namedChild;
            IValueReference child = array.getChild("[]");
            JSType arrayType = null;
            if (array.getDeclaredType() != null) {
                arrayType = TypeUtil.extractArrayItemType(array.getDeclaredType(), this.context);
            } else {
                JSTypeSet types = array.getTypes();
                if (types.size() > 0) {
                    arrayType = TypeUtil.extractArrayItemType(types.getFirst(), this.context);
                }
            }
            if (arrayType != null && child.getDeclaredType() == null) {
                this.setTypeImpl(child, arrayType);
            }
            if (node.getIndex() instanceof StringLiteral && (namedChild = this.extractNamedChild(array, node.getIndex())).exists()) {
                child = namedChild;
                if (arrayType != null && child.getDeclaredType() == null) {
                    this.setTypeImpl(child, arrayType);
                }
            }
            return child;
        }
        return null;
    }

    public IValueReference visitGetLocalNameExpression(GetLocalNameExpression node) {
        return null;
    }

    public IValueReference visitIdentifier(Identifier node) {
        return this.peekContext().getChild(node.getName());
    }

    private Boolean evaluateCondition(Expression condition) {
        if (condition instanceof BooleanLiteral) {
            return Boolean.valueOf(((BooleanLiteral)condition).getText());
        }
        return null;
    }

    public IValueReference visitIfStatement(IfStatement node) {
        this.visit((ASTNode)node.getCondition());
        ArrayList<Statement> statements = new ArrayList<Statement>(2);
        Statement onlyBranch = null;
        Boolean condition = this.evaluateCondition(node.getCondition());
        if ((condition == null || condition.booleanValue()) && node.getThenStatement() != null) {
            statements.add(node.getThenStatement());
            if (condition != null && condition.booleanValue()) {
                onlyBranch = node.getThenStatement();
            }
        }
        if (!(condition != null && condition.booleanValue() || node.getElseStatement() == null)) {
            statements.add(node.getElseStatement());
            if (condition != null && !condition.booleanValue()) {
                onlyBranch = node.getElseStatement();
            }
        }
        if (!statements.isEmpty()) {
            if (statements.size() == 1) {
                if (statements.get(0) == onlyBranch) {
                    this.visit((ASTNode)statements.get(0));
                } else {
                    Branching branching = this.branching();
                    this.visit((ASTNode)statements.get(0));
                    branching.end();
                }
            } else {
                Branching branching = this.branching();
                ArrayList<NestedValueCollection> collections = new ArrayList<NestedValueCollection>(statements.size());
                for (Statement statement : statements) {
                    NestedValueCollection nestedCollection = new NestedValueCollection(this.peekContext());
                    this.enterContext(nestedCollection);
                    this.visit((ASTNode)statement);
                    this.leaveContext();
                    collections.add(nestedCollection);
                }
                NestedValueCollection.mergeTo(this.peekContext(), collections);
                branching.end();
            }
        }
        return null;
    }

    public IValueReference visitLabelledStatement(LabelledStatement node) {
        if (node.getStatement() != null) {
            this.visit((ASTNode)node.getStatement());
        }
        return null;
    }

    public IValueReference visitNewExpression(NewExpression node) {
        Expression objectClass = node.getObjectClass();
        if (objectClass instanceof CallExpression) {
            CallExpression call = (CallExpression)objectClass;
            for (ASTNode argument : call.getArguments()) {
                this.visit(argument);
            }
            objectClass = call.getExpression();
        }
        IValueReference visit = this.visit((ASTNode)objectClass);
        AbstractReference result = null;
        if (visit != null) {
            if (visit.getKind() == ReferenceKind.FUNCTION) {
                Object fs = visit.getAttribute("FUNCTION_SCOPE");
                if (fs instanceof IValueCollection && ((IValueCollection)fs).getThis() != null) {
                    result = new AnonymousNewValue();
                    result.setValue(((IValueCollection)fs).getThis());
                    result.setKind(ReferenceKind.TYPE);
                    String className = PropertyExpressionUtils.getPath((Expression)objectClass);
                    if (className != null) {
                        Type type = TypeInfoModelFactory.eINSTANCE.createType();
                        type.setSuperType(this.context.getKnownType("Object", null));
                        type.setKind(TypeKind.JAVASCRIPT);
                        type.setName(className);
                        result.setDeclaredType(TypeUtil.ref(type));
                    } else {
                        result.setDeclaredType(this.context.getTypeRef("Object"));
                    }
                }
            } else if (visit.exists()) {
                for (JSType type : visit.getDeclaredTypes()) {
                    if (!(type instanceof ClassType)) continue;
                    result = new AnonymousNewValue();
                    result.setKind(ReferenceKind.TYPE);
                    result.setDeclaredType(TypeUtil.ref(((ClassType)type).getTarget()));
                    return result;
                }
                for (JSType type : visit.getTypes()) {
                    if (!(type instanceof ClassType)) continue;
                    result = new AnonymousNewValue();
                    result.setKind(ReferenceKind.TYPE);
                    result.setDeclaredType(TypeUtil.ref(((ClassType)type).getTarget()));
                    return result;
                }
            }
        }
        if (result == null) {
            String className = PropertyExpressionUtils.getPath((Expression)objectClass);
            IValueCollection contextValueCollection = this.peekContext();
            if (className != null) {
                Type knownType = this.context.getKnownType(className, TypeMode.CODE);
                if (knownType != null) {
                    result = new AnonymousNewValue();
                    result.setValue(this.context.getFactory().create(contextValueCollection, TypeUtil.ref(knownType)));
                    result.setKind(ReferenceKind.TYPE);
                } else {
                    result = new LazyTypeReference(this.context, className, contextValueCollection);
                }
            } else {
                result = new AnonymousNewValue();
                result.setValue(this.context.getFactory().createObject(contextValueCollection));
            }
        }
        return result;
    }

    public IValueReference visitNullExpression(NullExpression node) {
        return null;
    }

    public IValueReference visitObjectInitializer(ObjectInitializer node) {
        AnonymousValue result = new AnonymousValue();
        result.setDeclaredType(TypeUtil.ref(this.context.getKnownType("Object", null)));
        for (ObjectInitializerPart part : node.getInitializers()) {
            if (!(part instanceof PropertyInitializer)) continue;
            PropertyInitializer pi = (PropertyInitializer)part;
            IValueReference child = this.extractNamedChild(result, pi.getName());
            IValueReference value = this.visit((ASTNode)pi.getValue());
            if (child == null) continue;
            child.setValue(value);
            child.setLocation(ReferenceLocation.create(this.getSource(), pi.getName().sourceStart(), pi.getName().sourceEnd()));
            if (child.getKind() != ReferenceKind.UNKNOWN) continue;
            child.setKind(ReferenceKind.FIELD);
        }
        return result;
    }

    public IValueReference visitParenthesizedExpression(ParenthesizedExpression node) {
        return this.visit((ASTNode)node.getExpression());
    }

    public IValueReference visitPropertyExpression(PropertyExpression node) {
        IValueReference object = this.visit((ASTNode)node.getObject());
        return this.extractNamedChild(object, node.getProperty());
    }

    protected IValueReference extractNamedChild(IValueReference parent, Expression name) {
        if (parent != null) {
            String nameStr;
            if (name instanceof Identifier) {
                IValueReference child;
                nameStr = ((Identifier)name).getName();
                JSType parentType = JavaScriptValidations.typeOf(parent);
                if (parentType != null && TypeInferencerVisitor.isXML(parentType) && (child = parent.getChild(nameStr)) != null && child.getDeclaredType() == null) {
                    child.setDeclaredType(this.context.getTypeRef("XML"));
                    return child;
                }
            } else if (name instanceof StringLiteral) {
                nameStr = ((StringLiteral)name).getValue();
            } else if (name instanceof XmlAttributeIdentifier) {
                if (((XmlAttributeIdentifier)name).getExpression() instanceof AsteriskExpression) {
                    return this.visitAsteriskExpression((AsteriskExpression)((XmlAttributeIdentifier)name).getExpression());
                }
                nameStr = ((XmlAttributeIdentifier)name).getAttributeName();
                IValueReference child = parent.getChild(nameStr);
                if (child != null && child.getDeclaredType() == null) {
                    child.setDeclaredType(this.context.getTypeRef("XML"));
                    return child;
                }
            } else {
                if (name instanceof AsteriskExpression) {
                    return this.visitAsteriskExpression((AsteriskExpression)name);
                }
                if (name instanceof ParenthesizedExpression) {
                    this.visitParenthesizedExpression((ParenthesizedExpression)name);
                    return parent;
                }
                return null;
            }
            return parent.getChild(nameStr);
        }
        return null;
    }

    public IValueReference visitRegExpLiteral(RegExpLiteral node) {
        return this.context.getFactory().createRegExp(this.peekContext());
    }

    public IValueReference visitReturnStatement(ReturnStatement node) {
        if (node.getValue() != null) {
            IValueReference returnValue;
            IValueReference value = this.visit((ASTNode)node.getValue());
            if (value != null && (returnValue = this.peekContext().getReturnValue()) != null) {
                returnValue.addValue(value, !(value instanceof LazyTypeReference));
            }
            return value;
        }
        return null;
    }

    public IValueReference visitScript(Script node) {
        return (IValueReference)this.visit(node.getStatements());
    }

    public IValueReference visitStatementBlock(StatementBlock node) {
        for (Statement statement : node.getStatements()) {
            this.visit((ASTNode)statement);
        }
        return null;
    }

    public IValueReference visitStringLiteral(StringLiteral node) {
        return this.context.getFactory().createString(this.peekContext());
    }

    public IValueReference visitSwitchStatement(SwitchStatement node) {
        if (node.getCondition() != null) {
            this.visit((ASTNode)node.getCondition());
        }
        for (SwitchComponent component : node.getCaseClauses()) {
            if (component instanceof CaseClause) {
                this.visit((ASTNode)((CaseClause)component).getCondition());
            }
            this.visit(component.getStatements());
        }
        return null;
    }

    public IValueReference visitThisExpression(ThisExpression node) {
        return this.peekContext().getThis();
    }

    public IValueReference visitThrowStatement(ThrowStatement node) {
        if (node.getException() != null) {
            this.visit((ASTNode)node.getException());
        }
        return null;
    }

    public IValueReference visitTryStatement(TryStatement node) {
        this.visit((ASTNode)node.getBody());
        for (CatchClause catchClause : node.getCatches()) {
            NestedValueCollection collection = new NestedValueCollection(this.peekContext());
            collection.createChild(catchClause.getException().getName());
            this.enterContext(collection);
            if (catchClause.getStatement() != null) {
                this.visit((ASTNode)catchClause.getStatement());
            }
            this.leaveContext();
        }
        if (node.getFinally() != null) {
            this.visit((ASTNode)node.getFinally().getStatement());
        }
        return null;
    }

    public IValueReference visitTypeOfExpression(TypeOfExpression node) {
        this.visit((ASTNode)node.getExpression());
        return this.context.getFactory().createString(this.peekContext());
    }

    public IValueReference visitUnaryOperation(UnaryOperation node) {
        if (node.getOperation() == 98) {
            return this.context.getFactory().createBoolean(this.peekContext());
        }
        return this.visit((ASTNode)node.getExpression());
    }

    public IValueReference visitVariableStatement(VariableStatement node) {
        IValueCollection collection = this.peekContext();
        IValueReference result = null;
        for (VariableDeclaration declaration : node.getVariables()) {
            result = this.createVariable(collection, declaration);
            JSVariable variable = new JSVariable();
            variable.setName(declaration.getVariableName());
            if (result.getDeclaredType() != null) {
                variable.setType(result.getDeclaredType());
            }
            IModelBuilder[] iModelBuilderArray = this.context.getModelBuilders();
            int n = iModelBuilderArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModelBuilder extension = iModelBuilderArray[n2];
                extension.processVariable(declaration, variable, this.reporter, this.getJSDocTypeChecker());
                ++n2;
            }
            if (result.getDeclaredType() == null && variable.getType() != null) {
                result.setDeclaredType(variable.getType());
            }
            result.setAttribute("VARIABLE", variable);
        }
        return result;
    }

    public IValueReference visitVoidExpression(VoidExpression node) {
        this.visit((ASTNode)node.getExpression());
        return null;
    }

    public IValueReference visitVoidOperator(VoidOperator node) {
        this.visit((ASTNode)node.getExpression());
        return null;
    }

    public IValueReference visitWhileStatement(WhileStatement node) {
        if (node.getCondition() != null) {
            this.visit((ASTNode)node.getCondition());
        }
        if (node.getBody() != null) {
            this.visit((ASTNode)node.getBody());
        }
        return null;
    }

    public IValueReference visitWithStatement(WithStatement node) {
        IValueReference with = this.visit((ASTNode)node.getExpression());
        if (with != null) {
            WithValueCollection withCollection = new WithValueCollection(this.peekContext(), with);
            this.enterContext(withCollection);
            this.visit((ASTNode)node.getStatement());
            this.leaveContext();
        } else {
            this.visit((ASTNode)node.getStatement());
        }
        return null;
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.docBuilder == null) {
            this.docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        return this.docBuilder;
    }

    public IValueReference visitXmlLiteral(XmlLiteral node) {
        IValueReference xmlValueReference = this.context.getFactory().createXML(this.peekContext());
        if (xmlValueReference instanceof IValueProvider) {
            TypeRef xmlType = TypeUtil.ref(this.context.getKnownType("XML", null));
            IValue xmlValue = ((IValueProvider)((Object)xmlValueReference)).getValue();
            List fragments = node.getFragments();
            StringBuilder xml = new StringBuilder();
            for (XmlFragment xmlFragment : fragments) {
                if (xmlFragment instanceof XmlTextFragment) {
                    String xmlText = ((XmlTextFragment)xmlFragment).getXml();
                    if (xmlText.equals("<></>")) continue;
                    if (xmlText.startsWith("<>") && xmlText.endsWith("</>")) {
                        xmlText = "<xml>" + xmlText.substring(2, xmlText.length() - 3) + "</xml>";
                    }
                    xml.append(xmlText);
                    continue;
                }
                if (!(xmlFragment instanceof XmlExpressionFragment)) continue;
                Expression expression = ((XmlExpressionFragment)xmlFragment).getExpression();
                this.visit((ASTNode)expression);
                if (xml.charAt(xml.length() - 1) == '<' || xml.subSequence(xml.length() - 2, xml.length()).equals("</")) {
                    if (expression instanceof Identifier) {
                        xml.append(((Identifier)expression).getName());
                        continue;
                    }
                    xml.setLength(0);
                    break;
                }
                xml.append("\"\"");
            }
            if (xml.length() > 0) {
                try {
                    DocumentBuilder docBuilder = this.getDocumentBuilder();
                    Document doc = docBuilder.parse(new InputSource(new StringReader(xml.toString())));
                    NodeList nl = doc.getChildNodes();
                    if (nl.getLength() == 1) {
                        Node item = nl.item(0);
                        NamedNodeMap attributes = item.getAttributes();
                        int a = 0;
                        while (a < attributes.getLength()) {
                            Node attribute = attributes.item(a);
                            xmlValue.createChild("@" + attribute.getNodeName());
                            ++a;
                        }
                        this.createXmlChilds(xmlType, xmlValue, item.getChildNodes());
                    } else {
                        System.err.println("root should be 1 child?? " + xml);
                    }
                }
                catch (Exception exception) {}
            }
        }
        return xmlValueReference;
    }

    private void createXmlChilds(JSType xmlType, IValue xmlValue, NodeList nl) {
        int i = 0;
        while (i < nl.getLength()) {
            String value;
            Node item = nl.item(i);
            if (item.getNodeType() != 3 || (value = item.getNodeValue()) != null && !"".equals(value.trim())) {
                IValue nodeValue = xmlValue.createChild(item.getNodeName());
                nodeValue.setDeclaredType(xmlType);
                NamedNodeMap attributes = item.getAttributes();
                if (attributes != null) {
                    int a = 0;
                    while (a < attributes.getLength()) {
                        Node attribute = attributes.item(a);
                        nodeValue.createChild("@" + attribute.getNodeName());
                        ++a;
                    }
                }
                this.createXmlChilds(xmlType, nodeValue, item.getChildNodes());
            }
            ++i;
        }
    }

    public IValueReference visitXmlPropertyIdentifier(XmlAttributeIdentifier node) {
        return this.context.getFactory().createXML(this.peekContext());
    }

    public IValueReference visitYieldOperator(YieldOperator node) {
        IValueReference reference;
        IValueReference value = this.visit((ASTNode)node.getExpression());
        if (value != null && (reference = this.peekContext().getReturnValue()) != null) {
            reference.addValue(value, true);
        }
        return null;
    }

    public static boolean isFunctionDeclaration(Expression expression) {
        PropertyExpression pe = null;
        if (expression instanceof PropertyExpression) {
            pe = (PropertyExpression)expression;
        } else if (expression.getParent() instanceof PropertyExpression) {
            pe = (PropertyExpression)expression.getParent();
        }
        if (pe != null && pe.getObject() instanceof ThisExpression && pe.getParent() instanceof BinaryOperation) {
            return ((BinaryOperation)pe.getParent()).getRightExpression() instanceof FunctionStatement;
        }
        return false;
    }

    protected static class AnonymousNewValue
    extends AnonymousValue {
        protected AnonymousNewValue() {
        }

        public IValueReference getChild(String name) {
            if (name.equals("()")) {
                return this;
            }
            return super.getChild(name);
        }
    }

    private class Branching {
        private Branching() {
        }

        public void end() {
            TypeInferencerVisitor.this.branchings.remove(this);
        }
    }
}

