/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementMemento;
import org.eclipse.dltk.core.IModelProvider;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IRegion;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IScriptProjectFilenames;
import org.eclipse.dltk.core.ISearchableEnvironment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.internal.core.CreateTypeHierarchyOperation;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelProviderManager;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.NameLookup;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ProjectElementInfo;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.SearchableEnvironment;
import org.eclipse.dltk.internal.core.SetBuildpathOperation;
import org.eclipse.dltk.internal.core.XMLWriter;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.dltk.utils.CorePrinter;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptProject
extends Openable
implements IScriptProject,
IScriptProjectFilenames {
    public static final IBuildpathEntry[] INVALID_BUILDPATH = new IBuildpathEntry[0];
    protected static final boolean IS_CASE_SENSITIVE = !new File("Temp").equals(new File("temp"));
    protected static final String[] NO_PREREQUISITES = new String[0];
    private static final IBuildpathEntry[] RESOLUTION_IN_PROGRESS = new IBuildpathEntry[0];
    protected IProject project;
    private IDLTKLanguageToolkit toolkit = null;

    public ScriptProject(IProject project, ModelElement parent) {
        super(parent);
        this.project = project;
        this.toolkit = DLTKLanguageManager.findToolkit(project);
    }

    @Override
    public IDLTKLanguageToolkit getLanguageToolkit() {
        if (this.toolkit == null) {
            this.toolkit = DLTKLanguageManager.findToolkit(this.project);
        }
        return this.toolkit;
    }

    public IProjectFragment getFolderProjectFragment(IPath path) {
        if (path.segmentCount() == 1) {
            return this.getProjectFragment((IResource)this.project);
        }
        return this.getProjectFragment((IResource)this.project.getWorkspace().getRoot().getFolder(path));
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IProjectFragment getProjectFragment(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                if (org.eclipse.dltk.compiler.util.Util.isArchiveFileName(DLTKLanguageManager.getLanguageToolkit(this), resource.getName())) {
                    return this.createArchiveFragment(resource);
                }
                return null;
            }
            case 2: {
                return new ProjectFragment(resource, this);
            }
            case 4: {
                return new ProjectFragment(resource, this);
            }
        }
        return null;
    }

    private IProjectFragment createArchiveFragment(IResource resource) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this);
        if (toolkit != null && toolkit.languageSupportZIPBuildpath()) {
            return new ArchiveProjectFragment(resource, this);
        }
        return null;
    }

    @Override
    public IProjectFragment getProjectFragment(String path) {
        return this.getProjectFragment(ScriptProject.canonicalizedPath((IPath)new Path(path)));
    }

    public IProjectFragment getProjectFragment0(IPath archivePath) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this);
        if (toolkit != null && toolkit.languageSupportZIPBuildpath()) {
            return new ArchiveProjectFragment(archivePath, this);
        }
        return null;
    }

    @Override
    public IProjectFragment getProjectFragment(IPath path) {
        block14: {
            boolean isSpecial;
            boolean bl = isSpecial = !path.isEmpty() && path.segment(0).startsWith("#special#");
            if (!path.isAbsolute() && !isSpecial) {
                path = this.getPath().append(path);
            }
            int segmentCount = path.segmentCount();
            switch (segmentCount) {
                case 0: {
                    return null;
                }
                case 1: {
                    if (!path.equals((Object)this.getPath())) break;
                    return this.getProjectFragment((IResource)this.project);
                }
            }
            if (isSpecial && path.segment(0).startsWith("#special#builtin#")) {
                return new BuiltinProjectFragment(path, this);
            }
            if (org.eclipse.dltk.compiler.util.Util.isArchiveFileName(DLTKLanguageManager.getLanguageToolkit(this), path.lastSegment())) {
                IResource resource = this.project.getWorkspace().getRoot().findMember(path);
                if (resource != null && resource.getType() == 2) {
                    return this.getProjectFragment(resource);
                }
                return this.getProjectFragment0(path);
            }
            if (segmentCount == 1) {
                return this.getProjectFragment((IResource)this.project.getWorkspace().getRoot().getProject(path.lastSegment()));
            }
            IResource folder = this.project.getWorkspace().getRoot().findMember(path);
            if (folder != null) {
                IProjectFragment projectFragment = this.getProjectFragment(folder);
                return projectFragment;
            }
            try {
                IProjectFragment[] fragments = this.getProjectFragments();
                int i = 0;
                while (i < fragments.length) {
                    if (fragments[i].getPath().equals((Object)path)) {
                        return fragments[i];
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block14;
                e.printStackTrace();
            }
        }
        return null;
    }

    public IBuildpathEntry[] getResolvedBuildpath() throws ModelException {
        return this.getResolvedBuildpath(true, false, false);
    }

    public IBuildpathEntry[] getResolvedBuildpath(boolean ignoreUnresolvedEntry, boolean generateMarkerOnError, boolean returnResolutionInProgress) throws ModelException {
        ModelManager manager = ModelManager.getModelManager();
        ModelManager.PerProjectInfo perProjectInfo = null;
        if (ignoreUnresolvedEntry && !generateMarkerOnError && (perProjectInfo = this.getPerProjectInfo()) != null) {
            IBuildpathEntry[] infoPath = perProjectInfo.resolvedBuildpath;
            if (infoPath != null) {
                return infoPath;
            }
            if (returnResolutionInProgress && manager.isBuildpathBeingResolved(this)) {
                if (ModelManager.BP_RESOLVE_VERBOSE) {
                    Util.verbose("CPResolution: reentering raw buildpath resolution, will use empty buildpath instead\tproject: " + this.getElementName() + '\n' + "\tinvocation stack trace:");
                    new Exception("<Fake exception>").printStackTrace(System.out);
                }
                return RESOLUTION_IN_PROGRESS;
            }
        }
        HashMap rawReverseMap = perProjectInfo == null ? null : new HashMap(5);
        IBuildpathEntry[] resolvedPath = null;
        boolean nullOldResolvedCP = perProjectInfo != null && perProjectInfo.resolvedBuildpath == null;
        try {
            if (nullOldResolvedCP) {
                manager.setBuildpathBeingResolved(this, true);
            }
            resolvedPath = this.getResolvedBuildpath(this.getRawBuildpath(generateMarkerOnError, !generateMarkerOnError), ignoreUnresolvedEntry, generateMarkerOnError, rawReverseMap);
        }
        finally {
            if (nullOldResolvedCP) {
                perProjectInfo.resolvedBuildpath = null;
            }
        }
        if (perProjectInfo != null) {
            if (perProjectInfo.rawBuildpath == null && generateMarkerOnError && DLTKLanguageManager.hasScriptNature(this.project)) {
                this.flushBuildpathProblemMarkers(false, true);
                this.createBuildpathProblemMarker(new ModelStatus(1000, Messages.bind(Messages.buildpath_cannotReadBuildpathFile, this.getElementName())));
            }
            perProjectInfo.resolvedBuildpath = resolvedPath;
            perProjectInfo.resolvedPathToRawEntries = rawReverseMap;
            manager.setBuildpathBeingResolved(this, false);
        }
        return resolvedPath;
    }

    /*
     * Unable to fully structure code
     */
    public IBuildpathEntry[] getResolvedBuildpath(IBuildpathEntry[] buildpathEntries, boolean ignoreUnresolvedEntry, boolean generateMarkerOnError, Map rawReverseMap) throws ModelException {
        if (generateMarkerOnError) {
            this.flushBuildpathProblemMarkers(false, false);
        }
        length = buildpathEntries.length;
        resolvedEntries = new ArrayList<IBuildpathEntry>();
        i = 0;
        while (i < length) {
            block17: {
                block16: {
                    rawEntry = buildpathEntries[i];
                    status = null;
                    if (!generateMarkerOnError && ignoreUnresolvedEntry) break block16;
                    status = BuildpathEntry.validateBuildpathEntry(this, rawEntry, false);
                    if (!generateMarkerOnError || status.isOK()) break block16;
                    if (status.getCode() == 979 && ((BuildpathEntry)rawEntry).isOptional()) break block17;
                    this.createBuildpathProblemMarker(status);
                }
                switch (rawEntry.getEntryKind()) {
                    case 4: {
                        resolvedEntry = null;
                        try {
                            resolvedEntry = DLTKCore.getResolvedBuildpathEntry(rawEntry);
                        }
                        catch (AssertionFailedException v0) {
                            if (ignoreUnresolvedEntry) ** GOTO lbl24
                            throw new ModelException(status);
                        }
lbl24:
                        // 2 sources

                        if (resolvedEntry == null) {
                            if (ignoreUnresolvedEntry) break;
                            throw new ModelException(status);
                        }
                        if (rawReverseMap != null && rawReverseMap.get(resolvedPath = resolvedEntry.getPath()) == null) {
                            rawReverseMap.put(resolvedPath, rawEntry);
                        }
                        resolvedEntries.add(resolvedEntry);
                        break;
                    }
                    case 5: {
                        container = DLTKCore.getBuildpathContainer(rawEntry.getPath(), this);
                        if (container == null) {
                            if (ignoreUnresolvedEntry) break;
                            throw new ModelException(status);
                        }
                        containerEntries = container.getBuildpathEntries();
                        if (containerEntries == null) break;
                        j = 0;
                        containerLength = containerEntries.length;
                        while (j < containerLength) {
                            cEntry = (BuildpathEntry)containerEntries[j];
                            if (generateMarkerOnError && !(containerStatus = BuildpathEntry.validateBuildpathEntry(this, cEntry, true)).isOK()) {
                                this.createBuildpathProblemMarker(containerStatus);
                            }
                            cEntry = cEntry.combineWith((BuildpathEntry)rawEntry);
                            if (rawReverseMap != null && rawReverseMap.get(resolvedPath = cEntry.getPath()) == null) {
                                rawReverseMap.put(resolvedPath, rawEntry);
                            }
                            resolvedEntries.add(cEntry);
                            ++j;
                        }
                        break;
                    }
                    default: {
                        if (rawReverseMap != null && rawReverseMap.get(resolvedPath = rawEntry.getPath()) == null) {
                            rawReverseMap.put(resolvedPath, rawEntry);
                        }
                        resolvedEntries.add(rawEntry);
                    }
                }
            }
            ++i;
        }
        resolvedPath = new IBuildpathEntry[resolvedEntries.size()];
        resolvedEntries.toArray(resolvedPath);
        if (generateMarkerOnError && !(status = BuildpathEntry.validateBuildpath(this, resolvedPath)).isOK()) {
            this.createBuildpathProblemMarker(status);
        }
        return resolvedPath;
    }

    @Override
    public IBuildpathEntry[] getResolvedBuildpath(boolean ignoreUnresolvedEntry) throws ModelException {
        return this.getResolvedBuildpath(ignoreUnresolvedEntry, false, true);
    }

    public IBuildpathEntry[] getResolvedBuildpath(boolean ignoreUnresolvedEntry, boolean generateMarkerOnError) throws ModelException {
        return this.getResolvedBuildpath(ignoreUnresolvedEntry, generateMarkerOnError, true);
    }

    public IBuildpathEntry[] getExpandedBuildpath(boolean ignoreUnresolvedVariable) throws ModelException {
        return this.getExpandedBuildpath(ignoreUnresolvedVariable, false, null);
    }

    public IBuildpathEntry[] getExpandedBuildpath(boolean ignoreUnresolvedVariable, boolean generateMarkerOnError, Map preferredBuildpaths) throws ModelException {
        ArrayList<IBuildpathEntry> accumulatedEntries = new ArrayList<IBuildpathEntry>();
        this.computeExpandedBuildpath(null, ignoreUnresolvedVariable, generateMarkerOnError, new HashSet<String>(5), accumulatedEntries, preferredBuildpaths);
        return accumulatedEntries.toArray(new IBuildpathEntry[accumulatedEntries.size()]);
    }

    private void computeExpandedBuildpath(BuildpathEntry referringEntry, boolean ignoreUnresolvedVariable, boolean generateMarkerOnError, HashSet<String> rootIDs, List<IBuildpathEntry> accumulatedEntries, Map preferredBuildpaths) throws ModelException {
        String projectRootId = this.rootID();
        if (rootIDs.contains(projectRootId)) {
            return;
        }
        rootIDs.add(projectRootId);
        IBuildpathEntry[] preferredBuildpath = preferredBuildpaths != null ? (IBuildpathEntry[])preferredBuildpaths.get(this) : null;
        IBuildpathEntry[] immediateBuildpath = preferredBuildpath != null ? this.getResolvedBuildpath(preferredBuildpath, ignoreUnresolvedVariable, generateMarkerOnError, null) : this.getResolvedBuildpath(ignoreUnresolvedVariable, generateMarkerOnError, false);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        boolean isInitialProject = referringEntry == null;
        int i = 0;
        int length = immediateBuildpath.length;
        while (i < length) {
            String rootID;
            BuildpathEntry entry = (BuildpathEntry)immediateBuildpath[i];
            if ((isInitialProject || entry.isExported()) && !rootIDs.contains(rootID = entry.rootID())) {
                BuildpathEntry combinedEntry = entry.combineWith(referringEntry);
                accumulatedEntries.add(combinedEntry);
                if (entry.getEntryKind() == 2) {
                    IProject projRsc;
                    IResource member = workspaceRoot.findMember(entry.getPath());
                    if (member != null && member.getType() == 4 && ScriptProject.hasScriptNature(projRsc = (IProject)member)) {
                        ScriptProject scriptProject = (ScriptProject)DLTKCore.create(projRsc);
                        scriptProject.computeExpandedBuildpath(combinedEntry, ignoreUnresolvedVariable, false, rootIDs, accumulatedEntries, preferredBuildpaths);
                    }
                } else {
                    rootIDs.add(rootID);
                }
            }
            ++i;
        }
    }

    public IProjectFragment[] computeProjectFragments(IBuildpathEntry resolvedEntry) {
        try {
            return this.computeProjectFragments(new IBuildpathEntry[]{resolvedEntry}, false, null);
        }
        catch (ModelException modelException) {
            return new IProjectFragment[0];
        }
    }

    @Override
    public int getElementType() {
        return 2;
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
        if (!underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        IBuildpathEntry[] resolvedBuildpath = this.getResolvedBuildpath();
        IProjectFragment[] children = this.computeProjectFragments(resolvedBuildpath, false, null);
        this.setProjectInfoChildren(info, children);
        this.getPerProjectInfo().rememberExternalLibTimestamps();
        return true;
    }

    private void setProjectInfoChildren(OpenableElementInfo info, IProjectFragment[] children) {
        IModelProvider[] providers;
        ArrayList<IModelElement> fragments = new ArrayList<IModelElement>();
        Collections.addAll(fragments, children);
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this);
        if (toolkit != null && (providers = ModelProviderManager.getProviders(toolkit.getNatureId())) != null) {
            int i = 0;
            while (i < providers.length) {
                providers[i].provideModelChanges(this, fragments);
                ++i;
            }
        }
        info.setChildren(fragments.toArray(new IModelElement[fragments.size()]));
    }

    public ModelManager.PerProjectInfo getPerProjectInfo() throws ModelException {
        return ModelManager.getModelManager().getPerProjectInfoCheckExistence(this.project);
    }

    public IProjectFragment[] computeProjectFragments(IBuildpathEntry[] resolvedBuildpath, boolean retrieveExportedRoots, Map<IProjectFragment, BuildpathEntry> rootToResolvedEntries) throws ModelException {
        ArrayList<IProjectFragment> accumulatedRoots = new ArrayList<IProjectFragment>();
        this.computeProjectFragments(resolvedBuildpath, accumulatedRoots, new HashSet<String>(5), null, true, retrieveExportedRoots, rootToResolvedEntries);
        return accumulatedRoots.toArray(new IProjectFragment[accumulatedRoots.size()]);
    }

    public void computeProjectFragments(IBuildpathEntry[] resolvedBuildpath, List<IProjectFragment> accumulatedRoots, Set<String> rootIDs, IBuildpathEntry referringEntry, boolean checkExistency, boolean retrieveExportedRoots, Map<IProjectFragment, BuildpathEntry> rootToResolvedEntries) throws ModelException {
        if (referringEntry == null) {
            rootIDs.add(this.rootID());
        }
        int i = 0;
        int length = resolvedBuildpath.length;
        while (i < length) {
            this.computeProjectFragments(resolvedBuildpath[i], accumulatedRoots, rootIDs, referringEntry, checkExistency, retrieveExportedRoots, rootToResolvedEntries);
            ++i;
        }
    }

    public void computeProjectFragments(IBuildpathEntry resolvedEntry, List<IProjectFragment> accumulatedRoots, Set<String> rootIDs, IBuildpathEntry referringEntry, boolean checkExistency, boolean retrieveExportedRoots, Map<IProjectFragment, BuildpathEntry> rootToResolvedEntries) throws ModelException {
        String rootID = ((BuildpathEntry)resolvedEntry).rootID();
        if (rootIDs.contains(rootID)) {
            return;
        }
        IPath projectPath = this.project.getFullPath();
        IPath entryPath = resolvedEntry.getPath();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProjectFragment root = null;
        switch (resolvedEntry.getEntryKind()) {
            case 3: {
                if (!projectPath.isPrefixOf(entryPath)) break;
                if (checkExistency) {
                    Object target = Model.getTarget((IContainer)workspaceRoot, entryPath, checkExistency);
                    if (target == null) {
                        return;
                    }
                    if (!(target instanceof IFolder) && !(target instanceof IProject)) break;
                    root = this.getProjectFragment((IResource)target);
                    break;
                }
                root = this.getFolderProjectFragment(entryPath);
                break;
            }
            case 1: {
                if (referringEntry != null && !resolvedEntry.isExported()) {
                    return;
                }
                if (checkExistency) {
                    if (entryPath.segment(0).startsWith("#special#builtin#") && BuiltinProjectFragment.isSupported(this)) {
                        root = new BuiltinProjectFragment(entryPath, this);
                        break;
                    }
                    Object target = Model.getTarget((IContainer)workspaceRoot, entryPath, checkExistency);
                    if (target == null) {
                        return;
                    }
                    if (!resolvedEntry.isExternal()) {
                        if (!(target instanceof IResource)) break;
                        root = this.getProjectFragment((IResource)target);
                        break;
                    }
                    if (Model.isFile(target) && org.eclipse.dltk.compiler.util.Util.isArchiveFileName(DLTKLanguageManager.getLanguageToolkit(this), entryPath.lastSegment())) {
                        root = this.getProjectFragment0(entryPath);
                        break;
                    }
                    if (resolvedEntry.isContainerEntry()) {
                        root = new ExternalProjectFragment(entryPath, this, true, true);
                        break;
                    }
                    root = new ExternalProjectFragment(entryPath, this, true, true);
                    break;
                }
                root = this.getProjectFragment(entryPath);
                break;
            }
            case 2: {
                IProject requiredProjectRsc;
                if (!retrieveExportedRoots) {
                    return;
                }
                if (referringEntry != null && !resolvedEntry.isExported()) {
                    return;
                }
                IResource member = workspaceRoot.findMember(entryPath);
                if (member == null || member.getType() != 4 || !ScriptProject.hasScriptNature(requiredProjectRsc = (IProject)member)) break;
                rootIDs.add(rootID);
                ScriptProject requiredProject = (ScriptProject)DLTKCore.create(requiredProjectRsc);
                requiredProject.computeProjectFragments(requiredProject.getResolvedBuildpath(), accumulatedRoots, rootIDs, rootToResolvedEntries == null ? resolvedEntry : ((BuildpathEntry)resolvedEntry).combineWith((BuildpathEntry)referringEntry), checkExistency, retrieveExportedRoots, rootToResolvedEntries);
            }
        }
        if (root != null) {
            accumulatedRoots.add(root);
            rootIDs.add(rootID);
            if (rootToResolvedEntries != null) {
                rootToResolvedEntries.put(root, ((BuildpathEntry)resolvedEntry).combineWith((BuildpathEntry)referringEntry));
            }
        }
    }

    public String[] projectPrerequisites(IBuildpathEntry[] entries) throws ModelException {
        ArrayList<String> prerequisites = new ArrayList<String>();
        entries = this.getResolvedBuildpath(entries, true, false, null);
        int i = 0;
        int length = entries.length;
        while (i < length) {
            IBuildpathEntry entry = entries[i];
            if (entry.getEntryKind() == 2) {
                prerequisites.add(entry.getPath().lastSegment());
            }
            ++i;
        }
        int size = prerequisites.size();
        if (size == 0) {
            return NO_PREREQUISITES;
        }
        String[] result = new String[size];
        prerequisites.toArray(result);
        return result;
    }

    protected IBuildpathEntry[] defaultBuildpath() {
        return new IBuildpathEntry[]{DLTKCore.newSourceEntry(this.project.getFullPath())};
    }

    public String rootID() {
        return "[PRJ]" + this.project.getFullPath();
    }

    @Override
    protected Object createElementInfo() {
        return new ProjectElementInfo();
    }

    @Override
    public IResource getResource() {
        return this.project;
    }

    @Override
    public IPath getPath() {
        return this.project.getFullPath();
    }

    public static IPath canonicalizedPath(IPath externalPath) {
        if (externalPath == null) {
            return null;
        }
        if (IS_CASE_SENSITIVE) {
            return externalPath;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return externalPath;
        }
        if (workspace.getRoot().findMember(externalPath) != null) {
            return externalPath;
        }
        return externalPath;
    }

    protected ProjectElementInfo getProjectElementInfo() throws ModelException {
        return (ProjectElementInfo)this.getElementInfo();
    }

    public void resetCaches() {
        ProjectElementInfo info = (ProjectElementInfo)ModelManager.getModelManager().peekAtInfo(this);
        if (info != null) {
            info.resetCaches();
        }
    }

    public void resetResolvedBuildpath() {
        try {
            this.getPerProjectInfo().resetResolvedBuildpath();
        }
        catch (ModelException modelException) {}
    }

    public void updateProjectFragments() {
        if (this.isOpen()) {
            try {
                ProjectElementInfo info = this.getProjectElementInfo();
                this.computeChildren(info);
                info.resetCaches();
            }
            catch (ModelException modelException) {
                try {
                    this.close();
                }
                catch (ModelException modelException2) {}
            }
        }
    }

    public void computeChildren(ProjectElementInfo info) throws ModelException {
        IBuildpathEntry[] buildpath;
        block3: {
            IProjectFragment[] newRoots;
            IProjectFragment[] oldRoots;
            buildpath = this.getResolvedBuildpath();
            ProjectElementInfo.ProjectCache projectCache = info.projectCache;
            if (projectCache != null && (oldRoots = projectCache.allProjectFragmentCache).length == (newRoots = this.computeProjectFragments(buildpath, true, null)).length) {
                int i = 0;
                int length = oldRoots.length;
                while (i < length) {
                    if (oldRoots[i].equals(newRoots[i])) {
                        ++i;
                        continue;
                    }
                    break block3;
                }
                return;
            }
        }
        info.setForeignResources(null);
        IProjectFragment[] fragments = this.computeProjectFragments(buildpath, false, null);
        this.setProjectInfoChildren(info, fragments);
    }

    @Override
    public IBuildpathEntry[] getRawBuildpath() throws ModelException {
        return this.getRawBuildpath(false, true);
    }

    public IBuildpathEntry[] getRawBuildpath(boolean createMarkers, boolean logProblems) throws ModelException {
        IBuildpathEntry[] buildpath;
        ModelManager.PerProjectInfo perProjectInfo = null;
        if (createMarkers) {
            this.flushBuildpathProblemMarkers(false, true);
            buildpath = this.readBuildpathFile(createMarkers, logProblems);
        } else {
            perProjectInfo = this.getPerProjectInfo();
            buildpath = perProjectInfo.rawBuildpath;
            if (buildpath != null) {
                return buildpath;
            }
            buildpath = this.readBuildpathFile(createMarkers, logProblems);
        }
        if (buildpath == null) {
            return this.defaultBuildpath();
        }
        if (!createMarkers) {
            perProjectInfo.rawBuildpath = buildpath;
        }
        return buildpath;
    }

    protected IBuildpathEntry[] readBuildpathFile(boolean createMarker, boolean logProblems) {
        return this.readBuildpathFile(createMarker, logProblems, null);
    }

    protected IBuildpathEntry[] readBuildpathFile(boolean createMarker, boolean logProblems, Map unknownElements) {
        String xmlBuildpath;
        block6: {
            try {
                xmlBuildpath = this.getSharedProperty(".buildpath");
                if (xmlBuildpath != null) break block6;
                if (createMarker && this.project.isAccessible()) {
                    this.createBuildpathProblemMarker(new ModelStatus(1000, Messages.bind(Messages.buildpath_cannotReadBuildpathFile, this.getElementName())));
                }
                return null;
            }
            catch (CoreException e) {
                if (createMarker && this.project.isAccessible()) {
                    this.createBuildpathProblemMarker(new ModelStatus(1000, Messages.bind(Messages.buildpath_cannotReadBuildpathFile, this.getElementName())));
                }
                if (logProblems) {
                    Util.log(e, "Exception while retrieving " + this.getPath() + "/.buildpath, will revert to default buildpath");
                }
                return null;
            }
        }
        return this.decodeBuildpath(xmlBuildpath, createMarker, logProblems, unknownElements);
    }

    void createBuildpathProblemMarker(IModelStatus status) {
        block8: {
            int severity;
            IMarker marker = null;
            String[] arguments = new String[]{};
            boolean isCycleProblem = false;
            boolean isBuildpathFileFormatProblem = false;
            switch (status.getCode()) {
                case 1001: {
                    isCycleProblem = true;
                    if ("error".equals(this.getOption("org.eclipse.dltk.core.circularBuildpath", true))) {
                        severity = 2;
                        break;
                    }
                    severity = 1;
                    break;
                }
                case 1000: {
                    isBuildpathFileFormatProblem = true;
                    severity = 2;
                    break;
                }
                default: {
                    IPath path = status.getPath();
                    if (path != null) {
                        arguments = new String[]{path.toString()};
                    }
                    severity = "error".equals(this.getOption("org.eclipse.dltk.core.incompleteBuildpath", true)) ? 2 : 1;
                }
            }
            try {
                marker = this.project.createMarker("org.eclipse.dltk.core.buildpath_problem");
                marker.setAttributes(new String[]{"message", "severity", "location", "cycleDetected", "buildpathFileFormat", "id", "arguments"}, new Object[]{status.getMessage(), new Integer(severity), Messages.buildpath_buildPath, isCycleProblem ? "true" : "false", isBuildpathFileFormatProblem ? "true" : "false", new Integer(status.getCode()), Util.getProblemArgumentsForMarker(arguments)});
            }
            catch (CoreException e) {
                if (!ModelManager.VERBOSE) break block8;
                e.printStackTrace();
            }
        }
    }

    protected void flushBuildpathProblemMarkers(boolean flushCycleMarkers, boolean flushBuildpathFormatMarkers) {
        block7: {
            try {
                if (this.project.isAccessible()) {
                    IMarker[] markers = this.project.findMarkers("org.eclipse.dltk.core.buildpath_problem", false, 0);
                    int i = 0;
                    int length = markers.length;
                    while (i < length) {
                        IMarker marker = markers[i];
                        if (flushCycleMarkers && flushBuildpathFormatMarkers) {
                            marker.delete();
                        } else {
                            String cycleAttr = (String)marker.getAttribute("cycleDetected");
                            String buildpathFileFormatAttr = (String)marker.getAttribute("buildpathFileFormat");
                            if (flushCycleMarkers == (cycleAttr != null && cycleAttr.equals("true")) && flushBuildpathFormatMarkers == (buildpathFileFormatAttr != null && buildpathFileFormatAttr.equals("true"))) {
                                marker.delete();
                            }
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                if (!ModelManager.VERBOSE) break block7;
                e.printStackTrace();
            }
        }
    }

    protected IBuildpathEntry[] decodeBuildpath(String xmlBuildpath, boolean createMarker, boolean logProblems) {
        return this.decodeBuildpath(xmlBuildpath, createMarker, logProblems, null);
    }

    protected IBuildpathEntry[] decodeBuildpath(String xmlBuildpath, boolean createMarker, boolean logProblems, Map unknownElements) {
        ArrayList<IBuildpathEntry> paths;
        block17: {
            paths = new ArrayList<IBuildpathEntry>();
            if (xmlBuildpath != null) break block17;
            return null;
        }
        try {
            Element cpElement;
            StringReader reader = new StringReader(xmlBuildpath);
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
                }
                catch (SAXException sAXException) {
                    throw new IOException(Messages.file_badFormat);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new IOException(Messages.file_badFormat);
                }
            }
            finally {
                reader.close();
            }
            if (!cpElement.getNodeName().equalsIgnoreCase("buildpath")) {
                throw new IOException(Messages.file_badFormat);
            }
            NodeList list = cpElement.getElementsByTagName("buildpathentry");
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                IBuildpathEntry entry;
                Node node = list.item(i);
                if (node.getNodeType() == 1 && (entry = BuildpathEntry.elementDecode((Element)node, this, unknownElements)) != null) {
                    paths.add(entry);
                }
                ++i;
            }
        }
        catch (IOException e) {
            if (createMarker && this.project.isAccessible()) {
                this.createBuildpathProblemMarker(new ModelStatus(1000, Messages.bind(Messages.buildpath_xmlFormatError, new String[]{this.getElementName(), e.getMessage()})));
            }
            if (logProblems) {
                Util.log(e, "Exception while retrieving " + this.getPath() + "/.buildpath, will mark buildpath as invalid");
            }
            return INVALID_BUILDPATH;
        }
        catch (AssertionFailedException e) {
            if (createMarker && this.project.isAccessible()) {
                this.createBuildpathProblemMarker(new ModelStatus(1000, Messages.bind(Messages.buildpath_illegalEntryInBuildpathFile, new String[]{this.getElementName(), e.getMessage()})));
            }
            if (logProblems) {
                Util.log(e, "Exception while retrieving " + this.getPath() + "/.buildpath, will mark buildpath as invalid");
            }
            return INVALID_BUILDPATH;
        }
        IBuildpathEntry[] entries = new IBuildpathEntry[paths.size()];
        paths.toArray(entries);
        return entries;
    }

    public IBuildpathEntry[] decodeBuildpath(String xmlBuildpath, Map unknownElements) throws IOException, AssertionFailedException {
        Element cpElement;
        ArrayList<IBuildpathEntry> paths = new ArrayList<IBuildpathEntry>();
        StringReader reader = new StringReader(xmlBuildpath);
        try {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
            }
            catch (SAXException sAXException) {
                throw new IOException(Messages.file_badFormat);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new IOException(Messages.file_badFormat);
            }
        }
        finally {
            reader.close();
        }
        if (!cpElement.getNodeName().equalsIgnoreCase("buildpath")) {
            throw new IOException(Messages.file_badFormat);
        }
        NodeList list = cpElement.getElementsByTagName("buildpathentry");
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            IBuildpathEntry entry;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && (entry = BuildpathEntry.elementDecode((Element)node, this, unknownElements)) != null) {
                paths.add(entry);
            }
            ++i;
        }
        int pathSize = paths.size();
        IBuildpathEntry[] entries = new IBuildpathEntry[pathSize];
        paths.toArray(entries);
        return entries;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    @Override
    public IBuildpathEntry decodeBuildpathEntry(String encodedEntry) {
        try {
            if (encodedEntry == null) {
                return null;
            }
            reader = new StringReader(encodedEntry);
            try {
                try {
                    parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    node = parser.parse(new InputSource(reader)).getDocumentElement();
                }
                catch (SAXException v0) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        reader.close();
                        return null;
                    }
                }
                catch (ParserConfigurationException v1) {
                    ** continue;
                }
            }
            finally {
                reader.close();
            }
            if (!node.getNodeName().equalsIgnoreCase("buildpathentry") || node.getNodeType() != 1) {
                return null;
            }
            return BuildpathEntry.elementDecode(node, this, null);
        }
        catch (IOException v2) {
            return null;
        }
    }

    public String getSharedProperty(String key) throws CoreException {
        String property = null;
        IFile rscFile = this.project.getFile(key);
        if (rscFile.exists()) {
            byte[] bytes = Util.getResourceContentsAsByteArray(rscFile);
            try {
                property = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Util.log(e, "Could not read .buildpath with UTF-8 encoding");
                property = new String(bytes);
            }
        } else {
            File file;
            URI location = rscFile.getLocationURI();
            if (location != null && (file = Util.toLocalFile(location, null)) != null && file.exists()) {
                byte[] bytes;
                try {
                    bytes = org.eclipse.dltk.compiler.util.Util.getFileByteContent(file);
                }
                catch (IOException iOException) {
                    return null;
                }
                try {
                    property = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Util.log(e, "Could not read .buildpath with UTF-8 encoding");
                    property = new String(bytes);
                }
            }
        }
        return property;
    }

    @Override
    public IProjectFragment[] getProjectFragments() throws ModelException {
        IModelElement[] children = this.getChildren();
        int length = children.length;
        IProjectFragment[] roots = new IProjectFragment[length];
        System.arraycopy(children, 0, roots, 0, length);
        return roots;
    }

    public boolean saveBuildpath(IBuildpathEntry[] newBuildpath) throws ModelException {
        if (!this.project.isAccessible()) {
            return false;
        }
        HashMap unknownElements = new HashMap();
        IBuildpathEntry[] fileEntries = this.readBuildpathFile(false, false, unknownElements);
        if (fileEntries != null && this.isBuildpathEqualsTo(newBuildpath, fileEntries)) {
            return false;
        }
        try {
            this.setSharedProperty(".buildpath", this.encodeBuildpath(newBuildpath, true, unknownElements));
            return true;
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void setSharedProperty(String key, String value) throws CoreException {
        IFile rscFile = this.project.getFile(key);
        byte[] bytes = null;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Util.log(e, "Could not write .buildpath with UTF-8 encoding ");
            bytes = value.getBytes();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        if (rscFile.exists()) {
            if (rscFile.isReadOnly()) {
                ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{rscFile}, null);
            }
            rscFile.setContents((InputStream)inputStream, 1, null);
        } else {
            rscFile.create((InputStream)inputStream, 1, null);
        }
    }

    public boolean isBuildpathEqualsTo(IBuildpathEntry[] newBuildpath, IBuildpathEntry[] otherBuildpath) {
        if (otherBuildpath == null || otherBuildpath.length == 0) {
            return false;
        }
        int length = otherBuildpath.length;
        if (length != newBuildpath.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!otherBuildpath[i].equals(newBuildpath[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String encodeBuildpath(IBuildpathEntry[] buildpath, boolean indent, Map unknownElements) throws ModelException {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)s, "UTF8");
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, this, true);
            xmlWriter.startTag("buildpath", indent);
            int i = 0;
            while (i < buildpath.length) {
                ((BuildpathEntry)buildpath[i]).elementEncode(xmlWriter, this.project.getFullPath(), indent, true, unknownElements);
                ++i;
            }
            xmlWriter.endTag("buildpath", indent, true);
            writer.flush();
            writer.close();
            return s.toString("UTF8");
        }
        catch (IOException e) {
            throw new ModelException(e, 985);
        }
    }

    @Override
    public String encodeBuildpathEntry(IBuildpathEntry buildpathEntry) {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)s, "UTF8");
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, this, false);
            ((BuildpathEntry)buildpathEntry).elementEncode(xmlWriter, this.project.getFullPath(), true, true, null);
            writer.flush();
            writer.close();
            return s.toString("UTF8");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean hasBuildpathCycle(IBuildpathEntry[] preferredBuildpath) {
        HashSet cycleParticipants = new HashSet();
        HashMap<ScriptProject, IBuildpathEntry[]> preferredBuildpaths = new HashMap<ScriptProject, IBuildpathEntry[]>(1);
        preferredBuildpaths.put(this, preferredBuildpath);
        this.updateCycleParticipants(new ArrayList(2), cycleParticipants, ResourcesPlugin.getWorkspace().getRoot(), new HashSet(2), preferredBuildpaths);
        return !cycleParticipants.isEmpty();
    }

    public boolean hasCycleMarker() {
        return this.getCycleMarker() != null;
    }

    @Override
    public int hashCode() {
        return this.project.hashCode();
    }

    public IMarker getCycleMarker() {
        try {
            if (this.project.isAccessible()) {
                IMarker[] markers = this.project.findMarkers("org.eclipse.dltk.core.buildpath_problem", false, 0);
                int i = 0;
                int length = markers.length;
                while (i < length) {
                    IMarker marker = markers[i];
                    String cycleAttr = (String)marker.getAttribute("cycleDetected");
                    if (cycleAttr != null && cycleAttr.equals("true")) {
                        return marker;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static void updateAllCycleMarkers(Map preferredBuildpaths) throws ModelException {
        workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        rscProjects = workspaceRoot.getProjects();
        length = rscProjects.length;
        projects = new ScriptProject[length];
        cycleParticipants = new HashSet<E>();
        traversed = new HashSet<E>();
        prereqChain = new ArrayList<E>();
        i = 0;
        while (i < length) {
            projects[i] = (ScriptProject)DLTKCore.create(rscProjects[i]);
            project = projects[i];
            if (!traversed.contains(project.getPath())) {
                prereqChain.clear();
                project.updateCycleParticipants(prereqChain, cycleParticipants, workspaceRoot, traversed, preferredBuildpaths);
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            project = projects[i];
            if (project != null) {
                if (cycleParticipants.contains(project.getPath())) {
                    cycleMarker = project.getCycleMarker();
                    circularCPOption = project.getOption("org.eclipse.dltk.core.circularBuildpath", true);
                    v0 = circularCPSeverity = "error".equals(circularCPOption) != false ? 2 : 1;
                    if (cycleMarker != null) {
                        try {
                            existingSeverity = (Integer)cycleMarker.getAttribute("severity");
                            if (existingSeverity == circularCPSeverity) ** GOTO lbl36
                            cycleMarker.setAttribute("severity", circularCPSeverity);
                        }
                        catch (CoreException e) {
                            throw new ModelException(e);
                        }
                    } else {
                        project.createBuildpathProblemMarker(new ModelStatus(1001, project));
                    }
                } else {
                    project.flushBuildpathProblemMarkers(true, false);
                }
            }
lbl36:
            // 6 sources

            ++i;
        }
    }

    @Override
    public String getOption(String optionName, boolean inheritCoreOptions) {
        String propertyName = optionName;
        if (ModelManager.getModelManager().optionNames.contains(propertyName)) {
            String javaCoreDefault;
            IEclipsePreferences projectPreferences = this.getEclipsePreferences();
            String string = javaCoreDefault = inheritCoreOptions ? DLTKCore.getOption(propertyName) : null;
            if (projectPreferences == null) {
                return javaCoreDefault;
            }
            String value = projectPreferences.get(propertyName, javaCoreDefault);
            return value == null ? null : value.trim();
        }
        return null;
    }

    @Override
    public Map<String, String> getOptions(boolean inheritCoreOptions) {
        Hashtable options = inheritCoreOptions ? DLTKCore.getOptions() : new Hashtable(5);
        ModelManager.PerProjectInfo perProjectInfo = null;
        Hashtable<String, String> projectOptions = null;
        HashSet<String> optionNames = ModelManager.getModelManager().optionNames;
        try {
            perProjectInfo = this.getPerProjectInfo();
            projectOptions = perProjectInfo.options;
            if (projectOptions == null) {
                IEclipsePreferences projectPreferences = this.getEclipsePreferences();
                if (projectPreferences == null) {
                    return options;
                }
                String[] propertyNames = projectPreferences.keys();
                projectOptions = new Hashtable(propertyNames.length);
                int i = 0;
                while (i < propertyNames.length) {
                    String propertyName = propertyNames[i];
                    String value = projectPreferences.get(propertyName, null);
                    if (value != null && optionNames.contains(propertyName)) {
                        projectOptions.put(propertyName, value.trim());
                    }
                    ++i;
                }
                perProjectInfo.options = projectOptions;
            }
        }
        catch (ModelException modelException) {
            projectOptions = new Hashtable<String, String>();
        }
        catch (BackingStoreException backingStoreException) {
            projectOptions = new Hashtable();
        }
        if (inheritCoreOptions) {
            for (String propertyName : projectOptions.keySet()) {
                String propertyValue = projectOptions.get(propertyName);
                if (propertyValue == null || !optionNames.contains(propertyName)) continue;
                options.put(propertyName, propertyValue.trim());
            }
            return options;
        }
        return projectOptions;
    }

    @Override
    public void setOption(String optionName, String optionValue) {
        if (!ModelManager.getModelManager().optionNames.contains(optionName)) {
            return;
        }
        if (optionValue == null) {
            return;
        }
        IEclipsePreferences projectPreferences = this.getEclipsePreferences();
        String defaultValue = DLTKCore.getOption(optionName);
        if (optionValue.equals(defaultValue)) {
            projectPreferences.remove(optionName);
        } else {
            projectPreferences.put(optionName, optionValue);
        }
        try {
            projectPreferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    @Override
    public void setOptions(Map newOptions) {
        IEclipsePreferences projectPreferences = this.getEclipsePreferences();
        try {
            if (newOptions == null) {
                projectPreferences.clear();
            } else {
                for (String key : newOptions.keySet()) {
                    if (!ModelManager.getModelManager().optionNames.contains(key)) continue;
                    String value = (String)newOptions.get(key);
                    projectPreferences.put(key, value);
                }
                String[] pNames = projectPreferences.keys();
                int ln = pNames.length;
                int i = 0;
                while (i < ln) {
                    String key = pNames[i];
                    if (!newOptions.containsKey(key)) {
                        projectPreferences.remove(key);
                    }
                    ++i;
                }
            }
            projectPreferences.flush();
            try {
                this.getPerProjectInfo().options = null;
            }
            catch (ModelException modelException) {}
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public void setRawBuildpath(IBuildpathEntry[] entries, boolean canModifyResources, IProgressMonitor monitor) throws ModelException {
        this.setRawBuildpath(entries, monitor, canModifyResources, this.getResolvedBuildpath(true, false, false), true, canModifyResources);
    }

    @Override
    public void setRawBuildpath(IBuildpathEntry[] entries, IProgressMonitor monitor) throws ModelException {
        this.setRawBuildpath(entries, monitor, true, this.getResolvedBuildpath(true, false, false), true, true);
    }

    public void setRawBuildpath(IBuildpathEntry[] newEntries, IProgressMonitor monitor, boolean canChangeResource, IBuildpathEntry[] oldResolvedPath, boolean needValidation, boolean needSave) throws ModelException {
        ModelManager manager = ModelManager.getModelManager();
        try {
            IBuildpathEntry[] newRawPath = newEntries;
            if (newRawPath == null) {
                newRawPath = this.defaultBuildpath();
            }
            SetBuildpathOperation op = new SetBuildpathOperation(this, oldResolvedPath, newRawPath, canChangeResource, needValidation, needSave);
            op.runOperation(monitor);
        }
        catch (ModelException e) {
            manager.getDeltaProcessor().flush();
            throw e;
        }
    }

    public IEclipsePreferences getEclipsePreferences() {
        IEclipsePreferences eclipsePreferences;
        ModelManager.PerProjectInfo perProjectInfo = ModelManager.getModelManager().getPerProjectInfo(this.project, true);
        if (perProjectInfo.preferences != null) {
            return perProjectInfo.preferences;
        }
        ProjectScope context = new ProjectScope(this.getProject());
        perProjectInfo.preferences = eclipsePreferences = context.getNode("org.eclipse.dltk.core");
        IEclipsePreferences.INodeChangeListener nodeListener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if (event.getChild() == eclipsePreferences) {
                    ModelManager.getModelManager().resetProjectPreferences(ScriptProject.this);
                }
            }
        };
        ((IEclipsePreferences)eclipsePreferences.parent()).addNodeChangeListener(nodeListener);
        IEclipsePreferences.IPreferenceChangeListener preferenceListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                ModelManager.getModelManager().resetProjectOptions(ScriptProject.this);
            }
        };
        eclipsePreferences.addPreferenceChangeListener(preferenceListener);
        return eclipsePreferences;
    }

    public void updateBuildpathMarkers(Map preferredBuildpaths) {
        this.flushBuildpathProblemMarkers(false, true);
        this.flushBuildpathProblemMarkers(false, false);
        IBuildpathEntry[] buildpath = this.readBuildpathFile(true, false);
        if (preferredBuildpaths != null) {
            preferredBuildpaths.put(this, buildpath == null ? INVALID_BUILDPATH : buildpath);
        }
        if (buildpath != null) {
            int i = 0;
            while (i < buildpath.length) {
                IModelStatus status = BuildpathEntry.validateBuildpathEntry(this, buildpath[i], true);
                if (!(status.isOK() || status.getCode() == 964 && ((BuildpathEntry)buildpath[i]).isOptional())) {
                    this.createBuildpathProblemMarker(status);
                }
                ++i;
            }
            IModelStatus status = BuildpathEntry.validateBuildpath(this, buildpath);
            if (!status.isOK()) {
                this.createBuildpathProblemMarker(status);
            }
        }
    }

    public void updateCycleParticipants(ArrayList prereqChain, HashSet cycleParticipants, IWorkspaceRoot workspaceRoot, HashSet traversed, Map preferredBuildpaths) {
        IPath path = this.getPath();
        prereqChain.add(path);
        traversed.add(path);
        try {
            IBuildpathEntry[] buildpath = null;
            if (preferredBuildpaths != null) {
                buildpath = (IBuildpathEntry[])preferredBuildpaths.get(this);
            }
            if (buildpath == null) {
                buildpath = this.getResolvedBuildpath();
            }
            int i = 0;
            int length = buildpath.length;
            while (i < length) {
                IBuildpathEntry entry = buildpath[i];
                if (entry.getEntryKind() == 2) {
                    IResource member;
                    int index;
                    IPath prereqProjectPath = entry.getPath();
                    int n = index = cycleParticipants.contains(prereqProjectPath) ? 0 : prereqChain.indexOf(prereqProjectPath);
                    if (index >= 0) {
                        int size = prereqChain.size();
                        while (index < size) {
                            cycleParticipants.add(prereqChain.get(index));
                            ++index;
                        }
                    } else if (!traversed.contains(prereqProjectPath) && (member = workspaceRoot.findMember(prereqProjectPath)) != null && member.getType() == 4) {
                        ScriptProject scriptProject = (ScriptProject)DLTKCore.create((IProject)member);
                        scriptProject.updateCycleParticipants(prereqChain, cycleParticipants, workspaceRoot, traversed, preferredBuildpaths);
                    }
                }
                ++i;
            }
        }
        catch (ModelException modelException) {}
        prereqChain.remove(path);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScriptProject)) {
            return false;
        }
        ScriptProject other = (ScriptProject)o;
        return this.project.equals((Object)other.getProject());
    }

    @Override
    public boolean exists() {
        return this.project.exists() && DLTKLanguageManager.hasScriptNature(this.project);
    }

    @Override
    public String getElementName() {
        return this.project.getName();
    }

    public boolean contains(IResource resource) {
        IBuildpathEntry[] buildpath;
        try {
            buildpath = this.getResolvedBuildpath();
        }
        catch (ModelException modelException) {
            return false;
        }
        IPath fullPath = resource.getFullPath();
        IBuildpathEntry innerMostEntry = null;
        int j = 0;
        int cpLength = buildpath.length;
        while (j < cpLength) {
            IBuildpathEntry entry = buildpath[j];
            IPath entryPath = entry.getPath();
            if ((innerMostEntry == null || innerMostEntry.getPath().isPrefixOf(entryPath)) && entryPath.isPrefixOf(fullPath)) {
                innerMostEntry = entry;
            }
            ++j;
        }
        return innerMostEntry != null;
    }

    @Override
    public boolean isValid() {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this);
        return toolkit != null;
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrint("ScriptProject:" + this.getElementName());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + element);
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    public IBuildpathEntry[] readFileEntriesWithException(Map unknownElements) throws CoreException, IOException, AssertionFailedException {
        String xmlBuildpath;
        IFile rscFile = this.project.getFile(".buildpath");
        if (rscFile.exists()) {
            byte[] bytes = Util.getResourceContentsAsByteArray(rscFile);
            try {
                xmlBuildpath = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Util.log(e, "Could not read .buildpath with UTF-8 encoding");
                xmlBuildpath = new String(bytes);
            }
        } else {
            byte[] bytes;
            URI location = rscFile.getLocationURI();
            if (location == null) {
                throw new IOException("Cannot obtain a location URI for " + rscFile);
            }
            File file = Util.toLocalFile(location, null);
            if (file == null) {
                throw new IOException("Unable to fetch file from " + location);
            }
            try {
                bytes = org.eclipse.dltk.compiler.util.Util.getFileByteContent(file);
            }
            catch (IOException e) {
                if (!file.exists()) {
                    return this.defaultBuildpath();
                }
                throw e;
            }
            try {
                xmlBuildpath = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Util.log(e, "Could not read .buildpath with UTF-8 encoding");
                xmlBuildpath = new String(bytes);
            }
        }
        return this.decodeBuildpath(xmlBuildpath, unknownElements);
    }

    public static boolean areBuildpathsEqual(IBuildpathEntry[] firstBuildpath, IBuildpathEntry[] secondBuildpath) {
        if (secondBuildpath == null || secondBuildpath.length == 0) {
            return false;
        }
        int length = firstBuildpath.length;
        if (length != secondBuildpath.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!firstBuildpath[i].equals(secondBuildpath[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static void validateCycles(Map preferredBuildpaths) throws ModelException {
        workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        rscProjects = workspaceRoot.getProjects();
        length = rscProjects.length;
        projects = new ScriptProject[length];
        cycleParticipants = new HashSet<E>();
        traversed = new HashSet<E>();
        prereqChain = new ArrayList<E>();
        i = 0;
        while (i < length) {
            if (DLTKLanguageManager.hasScriptNature(rscProjects[i]) && !traversed.contains((project = (projects[i] = (ScriptProject)DLTKCore.create(rscProjects[i]))).getPath())) {
                prereqChain.clear();
                project.updateCycleParticipants(prereqChain, cycleParticipants, workspaceRoot, traversed, preferredBuildpaths);
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            project = projects[i];
            if (project != null) {
                if (cycleParticipants.contains(project.getPath())) {
                    cycleMarker = project.getCycleMarker();
                    circularCPOption = project.getOption("org.eclipse.dltk.core.circularBuildpath", true);
                    v0 = circularCPSeverity = "error".equals(circularCPOption) != false ? 2 : 1;
                    if (cycleMarker != null) {
                        try {
                            existingSeverity = (Integer)cycleMarker.getAttribute("severity");
                            if (existingSeverity == circularCPSeverity) ** GOTO lbl34
                            cycleMarker.setAttribute("severity", circularCPSeverity);
                        }
                        catch (CoreException e) {
                            throw new ModelException(e);
                        }
                    } else {
                        project.createBuildpathProblemMarker(new ModelStatus(1001, project));
                    }
                } else {
                    project.flushBuildpathProblemMarkers(true, false);
                }
            }
lbl34:
            // 6 sources

            ++i;
        }
    }

    @Override
    public IModelElement findElement(IPath path) throws ModelException {
        return this.findElement(path, DefaultWorkingCopyOwner.PRIMARY);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public IModelElement findElement(IPath path, WorkingCopyOwner owner) throws ModelException {
        if (path == null) {
            return null;
        }
        try {
            String extension = path.getFileExtension();
            if (extension == null) {
                String packageName = path.toString();
                NameLookup lookup = this.newNameLookup((WorkingCopyOwner)null);
                IScriptFolder[] pkgFragments = lookup.findScriptFolders(packageName, false);
                if (pkgFragments == null) {
                    return null;
                }
                int i = 0;
                int length = pkgFragments.length;
                while (i < length) {
                    IScriptFolder pkgFragment = pkgFragments[i];
                    if (this.equals(pkgFragment.getParent().getParent())) {
                        return pkgFragment;
                    }
                    ++i;
                }
                return pkgFragments[0];
            }
            if (Util.isValidSourceModule((IModelElement)this, path)) {
                IPath packagePath = path.removeLastSegments(1);
                String packageName = packagePath.toString();
                String typeName = path.lastSegment();
                typeName = typeName.substring(0, typeName.length() - extension.length() - 1);
                String qualifiedName = null;
                qualifiedName = packageName.length() > 0 ? String.valueOf(packageName) + "/" + typeName : typeName;
                NameLookup lookup = this.newNameLookup(owner);
                NameLookup.Answer answer = lookup.findType(qualifiedName, false, 0, true, false, false, null);
                if (answer != null) {
                    return answer.type.getParent();
                }
                return null;
            }
            return null;
        }
        catch (ModelException e) {
            if (e.getStatus().getCode() == 969) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public IScriptFolder findScriptFolder(IPath path) throws ModelException {
        return this.findScriptFolder0(ScriptProject.canonicalizedPath(path));
    }

    private IScriptFolder findScriptFolder0(IPath path) throws ModelException {
        NameLookup lookup = this.newNameLookup((WorkingCopyOwner)null);
        return lookup.findScriptFolder(path);
    }

    @Override
    public IProjectFragment findProjectFragment(IPath path) throws ModelException {
        return this.findProjectFragment0(ScriptProject.canonicalizedPath(path));
    }

    public IProjectFragment findProjectFragment0(IPath path) throws ModelException {
        IProjectFragment[] allRoots = this.getAllProjectFragments();
        if (!(path.isAbsolute() || path.segmentCount() != 0 && path.segment(0).startsWith("#special#"))) {
            throw new IllegalArgumentException(Messages.path_mustBeAbsolute);
        }
        int i = 0;
        while (i < allRoots.length) {
            IProjectFragment buildpathRoot = allRoots[i];
            if (buildpathRoot.getPath().equals((Object)path)) {
                return buildpathRoot;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IProjectFragment[] findProjectFragments(IBuildpathEntry entry) {
        try {
            IBuildpathEntry[] buildpath = this.getRawBuildpath();
            int i = 0;
            int length = buildpath.length;
            while (i < length) {
                if (buildpath[i].equals(entry)) {
                    return this.computeProjectFragments(this.getResolvedBuildpath(new IBuildpathEntry[]{entry}, true, false, null), false, null);
                }
                ++i;
            }
        }
        catch (ModelException modelException) {}
        return new IProjectFragment[0];
    }

    @Override
    public IType findType(String fullyQualifiedName) throws ModelException {
        return this.findType(fullyQualifiedName, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public IType findType(String fullyQualifiedName, IProgressMonitor progressMonitor) throws ModelException {
        return this.findType(fullyQualifiedName, DefaultWorkingCopyOwner.PRIMARY, progressMonitor);
    }

    IType findType(String fullyQualifiedName, Object lookup, boolean considerSecondaryTypes, IProgressMonitor progressMonitor) throws ModelException {
        if (DLTKCore.DEBUG) {
            System.err.println("Search Need to be implemented");
        }
        return null;
    }

    @Override
    public IType findType(String packageName, String typeQualifiedName) throws ModelException {
        return this.findType(packageName, typeQualifiedName, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public IType findType(String packageName, String typeQualifiedName, IProgressMonitor progressMonitor) throws ModelException {
        return this.findType(packageName, typeQualifiedName, DefaultWorkingCopyOwner.PRIMARY, progressMonitor);
    }

    IType findType(String packageName, String typeQualifiedName, Object lookup, boolean considerSecondaryTypes, IProgressMonitor progressMonitor) throws ModelException {
        if (DLTKCore.DEBUG) {
            System.err.println("Search Need to be implemented");
        }
        return null;
    }

    @Override
    public IType findType(String packageName, String typeQualifiedName, WorkingCopyOwner owner) throws ModelException {
        if (DLTKCore.DEBUG) {
            System.err.println("Search Need to be implemented");
        }
        return null;
    }

    @Override
    public IType findType(String packageName, String typeQualifiedName, WorkingCopyOwner owner, IProgressMonitor progressMonitor) throws ModelException {
        if (DLTKCore.DEBUG) {
            System.err.println("Search Need to be implemented");
        }
        return null;
    }

    @Override
    public IType findType(String fullyQualifiedName, WorkingCopyOwner owner) throws ModelException {
        if (DLTKCore.DEBUG) {
            System.err.println("Search Need to be implemented");
        }
        return null;
    }

    @Override
    public IType findType(String fullyQualifiedName, WorkingCopyOwner owner, IProgressMonitor progressMonitor) throws ModelException {
        if (DLTKCore.DEBUG) {
            System.err.println("Search Need to be implemented");
        }
        return null;
    }

    @Override
    public IBuildpathEntry[] readRawBuildpath() {
        IBuildpathEntry[] buildpath = this.readFileEntries(null);
        if (buildpath == INVALID_BUILDPATH) {
            return this.defaultBuildpath();
        }
        return buildpath;
    }

    private IBuildpathEntry[] readFileEntries(Map unkwownElements) {
        try {
            return this.readFileEntriesWithException(unkwownElements);
        }
        catch (CoreException e) {
            Util.log(e, "Exception while reading " + this.getPath().append(".buildpath"));
            return INVALID_BUILDPATH;
        }
        catch (IOException e) {
            Util.log(e, "Exception while reading " + this.getPath().append(".buildpath"));
            return INVALID_BUILDPATH;
        }
        catch (AssertionFailedException e) {
            Util.log(e, "Exception while reading " + this.getPath().append(".buildpath"));
            return INVALID_BUILDPATH;
        }
    }

    @Override
    public Object[] getForeignResources() throws ModelException {
        return ((ProjectElementInfo)this.getElementInfo()).getForeignResources(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isOnBuildpath(IModelElement element) {
        IBuildpathEntry[] rawBuildpath;
        try {
            rawBuildpath = this.getRawBuildpath();
        }
        catch (ModelException modelException) {
            return false;
        }
        int elementType = element.getElementType();
        boolean isFolderPath = false;
        boolean isProjectFragment = false;
        switch (elementType) {
            case 1: {
                return false;
            }
            case 2: {
                break;
            }
            case 3: {
                isProjectFragment = true;
                break;
            }
            case 4: {
                isFolderPath = !((IProjectFragment)element.getParent()).isArchive();
                break;
            }
            case 5: {
                break;
            }
        }
        IPath elementPath = element.getPath();
        int length = rawBuildpath.length;
        int i = 0;
        while (i < length) {
            IBuildpathEntry entry = rawBuildpath[i];
            switch (entry.getEntryKind()) {
                case 1: 
                case 2: 
                case 3: {
                    if (!this.isOnBuildpathEntry(elementPath, isFolderPath, isProjectFragment, entry)) break;
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            IBuildpathEntry rawEntry = rawBuildpath[i];
            switch (rawEntry.getEntryKind()) {
                case 5: {
                    IBuildpathEntry[] containerEntries;
                    IBuildpathContainer container;
                    try {
                        container = DLTKCore.getBuildpathContainer(rawEntry.getPath(), this);
                    }
                    catch (ModelException modelException) {
                        break;
                    }
                    if (container == null || (containerEntries = container.getBuildpathEntries()) == null) break;
                    int j = 0;
                    int containerLength = containerEntries.length;
                    while (j < containerLength) {
                        IBuildpathEntry resolvedEntry = containerEntries[j];
                        if (this.isOnBuildpathEntry(elementPath, isFolderPath, isProjectFragment, resolvedEntry)) {
                            return true;
                        }
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        try {
            IProjectFragment[] allProjectFragments;
            IProjectFragment[] iProjectFragmentArray = allProjectFragments = this.getAllProjectFragments();
            int n = allProjectFragments.length;
            int n2 = 0;
            while (true) {
                IPath path;
                if (n2 >= n) {
                    return false;
                }
                IProjectFragment fragment = iProjectFragmentArray[n2];
                if (fragment.isExternal() && (path = fragment.getPath()).isPrefixOf(elementPath)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            if (!DLTKCore.DEBUG) return false;
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean isOnBuildpath(IResource resource) {
        IBuildpathEntry[] buildpath;
        IPath exactPath;
        IPath path = exactPath = resource.getFullPath();
        int resourceType = resource.getType();
        boolean isFolderPath = resourceType == 2 || resourceType == 4;
        try {
            buildpath = this.getResolvedBuildpath();
        }
        catch (ModelException modelException) {
            return false;
        }
        int i = 0;
        while (i < buildpath.length) {
            IBuildpathEntry entry = buildpath[i];
            IPath entryPath = entry.getPath();
            if (entryPath.equals((Object)exactPath)) {
                return true;
            }
            if (entryPath.isPrefixOf(path) && !Util.isExcluded(path, ((BuildpathEntry)entry).fullInclusionPatternChars(), ((BuildpathEntry)entry).fullExclusionPatternChars(), isFolderPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isOnBuildpathEntry(IPath elementPath, boolean isFolderPath, boolean isProjectFragment, IBuildpathEntry entry) {
        IPath entryPath = entry.getPath();
        return isProjectFragment ? entryPath.equals((Object)elementPath) : entryPath.isPrefixOf(elementPath) && !Util.isExcluded(elementPath, ((BuildpathEntry)entry).fullInclusionPatternChars(), ((BuildpathEntry)entry).fullExclusionPatternChars(), isFolderPath);
    }

    @Override
    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '/': {
                String rootPath = "";
                token = null;
                while (memento.hasMoreTokens()) {
                    token = memento.nextToken();
                    char firstChar = token.charAt(0);
                    if (firstChar == '<' || firstChar == '!' || firstChar == '}') break;
                    rootPath = String.valueOf(rootPath) + token;
                }
                ModelElement root = null;
                root = rootPath.indexOf(62) != -1 ? this.getExternalScriptFolderOrContainerFolder(rootPath) : (ModelElement)((Object)this.getProjectFragment((IPath)new Path(rootPath)));
                if (token != null && token.charAt(0) == '<' && root != null) {
                    return root.getHandleFromMemento(token, memento, owner);
                }
                if (token != null && token.charAt(0) == '}' && root != null) {
                    return root.getHandleFromMemento(token, memento, owner);
                }
                if (root != null) {
                    return root.getHandleFromMemento(memento, owner);
                }
                return null;
            }
            case '}': {
                token = null;
                String name = "";
                while (memento.hasMoreTokens()) {
                    token = memento.nextToken();
                    char firstChar = token.charAt(0);
                    if ("=/<^~{[&!@]%}".indexOf(firstChar) != -1 || firstChar == '!') break;
                    name = String.valueOf(name) + token;
                }
                try {
                    IProjectFragment[] children = this.getProjectFragments();
                    int i = 0;
                    while (i < children.length) {
                        if (name.equals(children[i].getElementName()) && children[i] instanceof IModelElementMemento) {
                            IModelElementMemento childMemento = (IModelElementMemento)((Object)children[i]);
                            return childMemento.getHandleFromMemento(token, memento, owner);
                        }
                        ++i;
                    }
                    break;
                }
                catch (ModelException e) {
                    DLTKCore.error("Incorrect handle resolving", (Throwable)((Object)e));
                }
            }
        }
        return null;
    }

    private ModelElement getExternalScriptFolderOrContainerFolder(String rootPath) {
        IProjectFragment[] allRoots;
        try {
            allRoots = this.getProjectFragments();
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
        int i = 0;
        while (i < allRoots.length) {
            IProjectFragment buildpathRoot = allRoots[i];
            if (buildpathRoot.getElementName().equals(rootPath)) {
                return (ModelElement)((Object)buildpathRoot);
            }
            ++i;
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '=';
    }

    @Override
    public IResource getUnderlyingResource() throws ModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.project;
    }

    public ISearchableEnvironment newSearchableNameEnvironment(ISourceModule[] workingCopies) throws ModelException {
        return new SearchableEnvironment(this, workingCopies);
    }

    public SearchableEnvironment newSearchableNameEnvironment(WorkingCopyOwner owner) throws ModelException {
        return new SearchableEnvironment(this, owner);
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IRegion region, IProgressMonitor monitor) throws ModelException {
        return this.newTypeHierarchy(region, DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IRegion region, WorkingCopyOwner owner, IProgressMonitor monitor) throws ModelException {
        if (region == null) {
            throw new IllegalArgumentException(Messages.hierarchy_nullRegion);
        }
        ISourceModule[] workingCopies = ModelManager.getModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation(region, workingCopies, null, true);
        op.runOperation(monitor);
        return op.getResult();
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IType type, IRegion region, IProgressMonitor monitor) throws ModelException {
        return this.newTypeHierarchy(type, region, DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    @Override
    public ITypeHierarchy newTypeHierarchy(IType type, IRegion region, WorkingCopyOwner owner, IProgressMonitor monitor) throws ModelException {
        if (type == null) {
            throw new IllegalArgumentException(Messages.hierarchy_nullFocusType);
        }
        if (region == null) {
            throw new IllegalArgumentException(Messages.hierarchy_nullRegion);
        }
        ISourceModule[] workingCopies = ModelManager.getModelManager().getWorkingCopies(owner, true);
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation(region, workingCopies, type, true);
        op.runOperation(monitor);
        return op.getResult();
    }

    public IBuildpathEntry getBuildpathEntryFor(IPath path) throws ModelException {
        IBuildpathEntry[] entries = this.getExpandedBuildpath(true);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getPath().equals((Object)path)) {
                return entries[i];
            }
            ++i;
        }
        return null;
    }

    public NameLookup newNameLookup(ISourceModule[] workingCopies) throws ModelException {
        return this.getProjectElementInfo().newNameLookup(this, workingCopies);
    }

    public NameLookup newNameLookup(WorkingCopyOwner owner) throws ModelException {
        ModelManager manager = ModelManager.getModelManager();
        ISourceModule[] workingCopies = owner == null ? null : manager.getWorkingCopies(owner, true);
        return this.newNameLookup(workingCopies);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void forceBuildpathReload(IProgressMonitor monitor) throws ModelException {
        IBuildpathEntry[] fileEntries;
        boolean wasSuccessful;
        block16: {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            wasSuccessful = false;
            fileEntries = this.readBuildpathFile(false, false);
            if (fileEntries != null) break block16;
            if (wasSuccessful) return;
            try {
                this.getPerProjectInfo().updateBuildpathInformation(INVALID_BUILDPATH);
                this.updateProjectFragments();
                return;
            }
            catch (ModelException modelException) {}
            return;
        }
        try {
            try {
                ModelManager.PerProjectInfo info = this.getPerProjectInfo();
                if (info.rawBuildpath != null && this.isBuildpathEqualsTo(info.rawBuildpath, fileEntries)) {
                    return;
                }
                IBuildpathEntry[] oldResolvedBuildpath = info.resolvedBuildpath;
                this.setRawBuildpath(fileEntries, monitor, !ResourcesPlugin.getWorkspace().isTreeLocked(), oldResolvedBuildpath != null ? oldResolvedBuildpath : this.getResolvedBuildpath(true, false, false), true, false);
                return;
            }
            catch (RuntimeException e) {
                if (!this.project.isAccessible()) throw e;
                Util.log(e, "Could not set buildpath for " + this.getPath());
                throw e;
            }
            catch (ModelException e) {
                if (ResourcesPlugin.getWorkspace().isTreeLocked()) throw e;
                if (!this.project.isAccessible()) throw e;
                if (e.getModelStatus().getException() instanceof CoreException) {
                    this.createBuildpathProblemMarker(new ModelStatus(1000, Messages.bind(Messages.buildpath_couldNotWriteBuildpathFile, new String[]{this.getElementName(), e.getMessage()})));
                    throw e;
                } else {
                    this.createBuildpathProblemMarker(new ModelStatus(1000, Messages.bind(Messages.buildpath_invalidBuildpathInBuildpathFile, new String[]{this.getElementName(), e.getMessage()})));
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (wasSuccessful) throw throwable;
            try {
                this.getPerProjectInfo().updateBuildpathInformation(INVALID_BUILDPATH);
                this.updateProjectFragments();
                throw throwable;
            }
            catch (ModelException modelException) {}
            throw throwable;
        }
    }

    @Override
    public IProjectFragment[] getAllProjectFragments() throws ModelException {
        return this.getAllProjectFragments(null);
    }

    public IProjectFragment[] getAllProjectFragments(Map<IProjectFragment, BuildpathEntry> rootToResolvedEntries) throws ModelException {
        IModelProvider[] providers;
        IProjectFragment[] computed = this.computeProjectFragments(this.getResolvedBuildpath(true, false, false), true, rootToResolvedEntries);
        ArrayList<IModelElement> fragments = new ArrayList<IModelElement>();
        Collections.addAll(fragments, computed);
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(this);
        if (toolkit != null && (providers = ModelProviderManager.getProviders(toolkit.getNatureId())) != null) {
            int i = 0;
            while (i < providers.length) {
                providers[i].provideModelChanges(this, fragments);
                ++i;
            }
        }
        return fragments.toArray(new IProjectFragment[fragments.size()]);
    }

    public static boolean hasScriptNature(IProject p) {
        return DLTKLanguageManager.hasScriptNature(p);
    }

    @Override
    public IScriptFolder[] getScriptFolders() throws ModelException {
        IProjectFragment[] roots = this.getProjectFragments();
        return this.getScriptFoldersInFragments(roots);
    }

    public IScriptFolder[] getScriptFoldersInFragments(IProjectFragment[] roots) {
        ArrayList<IModelElement> frags = new ArrayList<IModelElement>();
        int i = 0;
        while (i < roots.length) {
            IProjectFragment root = roots[i];
            try {
                IModelElement[] rootFragments = root.getChildren();
                int j = 0;
                while (j < rootFragments.length) {
                    frags.add(rootFragments[j]);
                    ++j;
                }
            }
            catch (ModelException modelException) {}
            ++i;
        }
        IScriptFolder[] fragments = new IScriptFolder[frags.size()];
        frags.toArray(fragments);
        return fragments;
    }

    public IBuildpathEntry[] getResourceOnlyResolvedBuildpath() throws ModelException {
        IBuildpathEntry[] rawBuildpath = this.getRawBuildpath();
        ArrayList<IBuildpathEntry> rawEntries = new ArrayList<IBuildpathEntry>();
        IBuildpathEntry[] iBuildpathEntryArray = rawBuildpath;
        int n = rawBuildpath.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry entry = iBuildpathEntryArray[n2];
            if (entry.getEntryKind() != 5) {
                rawEntries.add(entry);
            }
            ++n2;
        }
        rawBuildpath = rawEntries.toArray(new IBuildpathEntry[rawEntries.size()]);
        return this.getResolvedBuildpath(rawBuildpath, true, false, null);
    }
}

