/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.ast.parser.SourceParserManager;
import org.eclipse.dltk.codeassist.ICompletionEngine;
import org.eclipse.dltk.codeassist.ISelectionEngine;
import org.eclipse.dltk.compiler.problem.DefaultProblemFactory;
import org.eclipse.dltk.compiler.problem.IProblemFactory;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ICallHierarchyFactory;
import org.eclipse.dltk.core.ICallProcessor;
import org.eclipse.dltk.core.ICalleeProcessor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IFileHierarchyResolver;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISearchFactory;
import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.PriorityClassDLTKExtensionManager;
import org.eclipse.dltk.core.PriorityDLTKExtensionManager;
import org.eclipse.dltk.core.model.binary.IBinaryElementParser;
import org.eclipse.dltk.core.search.DLTKSearchParticipant;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.IMatchLocatorParser;
import org.eclipse.dltk.core.search.SearchPatternProcessor;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.dltk.core.search.matching.IMatchLocator;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.core.search.matching.MatchLocatorParser;
import org.eclipse.dltk.internal.core.InternalDLTKLanguageManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLTKLanguageManager {
    private static final String FILENAME_ASSOCIATION_EXT_POINT = "org.eclipse.dltk.core.filenameAssociation";

    public static IDLTKLanguageToolkit getLanguageToolkit(String natureId) {
        return (IDLTKLanguageToolkit)InternalDLTKLanguageManager.getLanguageToolkitsManager().getObject(natureId);
    }

    public static IDLTKLanguageToolkit[] getLanguageToolkits() {
        PriorityClassDLTKExtensionManager tkManager = InternalDLTKLanguageManager.getLanguageToolkitsManager();
        PriorityDLTKExtensionManager.ElementInfo[] elementInfos = tkManager.getElementInfos();
        IDLTKLanguageToolkit[] toolkits = new IDLTKLanguageToolkit[elementInfos.length];
        int j = 0;
        while (j < elementInfos.length) {
            toolkits[j] = (IDLTKLanguageToolkit)tkManager.getInitObject(elementInfos[j]);
            ++j;
        }
        return toolkits;
    }

    private static IDLTKLanguageToolkit findAppropriateToolkitByObject(Object object) {
        PriorityClassDLTKExtensionManager toolkitManager = InternalDLTKLanguageManager.getLanguageToolkitsManager();
        PriorityDLTKExtensionManager.ElementInfo[] elementInfos = toolkitManager.getElementInfos();
        int j = 0;
        while (j < elementInfos.length) {
            IDLTKLanguageToolkit toolkit = (IDLTKLanguageToolkit)toolkitManager.getInitObject(elementInfos[j]);
            if (object instanceof IResource) {
                if (DLTKContentTypeManager.isValidResourceForContentType(toolkit, (IResource)object)) {
                    return toolkit;
                }
            } else if (object instanceof IPath) {
                if (DLTKContentTypeManager.isValidFileNameForContentType(toolkit, (IPath)object)) {
                    return toolkit;
                }
            } else {
                return null;
            }
            ++j;
        }
        return null;
    }

    public static boolean hasScriptNature(IProject project) {
        return InternalDLTKLanguageManager.getLanguageToolkitsManager().findScriptNature(project) != null;
    }

    public static IDLTKLanguageToolkit getLanguageToolkit(IModelElement element) {
        IDLTKLanguageToolkit toolkit = (IDLTKLanguageToolkit)InternalDLTKLanguageManager.getLanguageToolkitsManager().getObject(element);
        if (toolkit == null) {
            while (element != null && element.getElementType() != 5) {
                element = element.getParent();
            }
            if (element != null && element.getElementType() == 5) {
                IDLTKLanguageToolkit tk;
                if (element.getResource() != null && (tk = DLTKLanguageManager.findAppropriateToolkitByObject(element.getResource())) != null) {
                    return tk;
                }
                return DLTKLanguageManager.findAppropriateToolkitByObject(element.getPath());
            }
        }
        return toolkit;
    }

    @Deprecated
    public static IDLTKLanguageToolkit findToolkit(IResource resource) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.findAppropriateToolkitByObject(resource);
        if (toolkit == null) {
            toolkit = DLTKLanguageManager.findToolkit(resource.getProject());
        }
        return toolkit;
    }

    public static IDLTKLanguageToolkit findToolkit(IProject project) {
        return (IDLTKLanguageToolkit)InternalDLTKLanguageManager.getLanguageToolkitsManager().getObject(project);
    }

    public static IDLTKLanguageToolkit findToolkitForResource(IResource resource) {
        if (resource.getType() == 4) {
            return DLTKLanguageManager.findToolkit((IProject)resource);
        }
        IModelElement parent = DLTKCore.create((IResource)resource.getParent());
        if (parent == null) {
            return null;
        }
        return DLTKLanguageManager.findToolkit(parent, resource, false);
    }

    public static IDLTKLanguageToolkit findToolkit(IModelElement parent, IResource resource, boolean useDefault) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(parent);
        if (toolkit != null) {
            if (DLTKContentTypeManager.isValidResourceForContentType(toolkit, resource)) {
                return toolkit;
            }
            return useDefault ? toolkit : null;
        }
        return DLTKLanguageManager.findAppropriateToolkitByObject(resource);
    }

    public static IDLTKLanguageToolkit findToolkit(IPath path) {
        return DLTKLanguageManager.findAppropriateToolkitByObject(path);
    }

    public static ISourceElementParser getSourceElementParser(String nature) {
        return (ISourceElementParser)InternalDLTKLanguageManager.getSourceElementParsersManager().getObject(nature);
    }

    public static ISourceElementParser getSourceElementParser(IModelElement element) {
        return (ISourceElementParser)InternalDLTKLanguageManager.getSourceElementParsersManager().getObject(element);
    }

    public static IBinaryElementParser getBinaryElementParser(String nature) {
        return (IBinaryElementParser)InternalDLTKLanguageManager.getBinaryElementParsersManager().getObject(nature);
    }

    public static IBinaryElementParser getBinaryElementParser(IModelElement element) {
        return (IBinaryElementParser)InternalDLTKLanguageManager.getBinaryElementParsersManager().getObject(element);
    }

    public static IProblemFactory getProblemFactory(String natureID) {
        IProblemFactory factory = (IProblemFactory)InternalDLTKLanguageManager.getProblemFactoryManager().getObject(natureID);
        if (factory != null) {
            return factory;
        }
        return new DefaultProblemFactory();
    }

    public static IProblemFactory getProblemFactory(IModelElement element) {
        IProblemFactory factory = (IProblemFactory)InternalDLTKLanguageManager.getProblemFactoryManager().getObject(element);
        if (factory != null) {
            return factory;
        }
        return new DefaultProblemFactory();
    }

    @Deprecated
    public static ICompletionEngine getCompletionEngine(String natureID) {
        ICompletionEngine[] engines = DLTKLanguageManager.getCompletionEngines(natureID);
        return engines != null ? engines[0] : null;
    }

    public static ICompletionEngine[] getCompletionEngines(String natureID) {
        return (ICompletionEngine[])InternalDLTKLanguageManager.getCompletionEngineManager().getInstances(natureID);
    }

    public static ISelectionEngine getSelectionEngine(String natureID) {
        return (ISelectionEngine)InternalDLTKLanguageManager.getSelectionEngineManager().getObject(natureID);
    }

    public static ISourceParser getSourceParser(String natureID) {
        return DLTKLanguageManager.getSourceParser(null, natureID);
    }

    public static ISourceParser getSourceParser(IProject project, String natureID) {
        return SourceParserManager.getInstance().getSourceParser(project, natureID);
    }

    public static DLTKSearchParticipant createSearchParticipant(String natureID) {
        DLTKSearchParticipant participant;
        ISearchFactory factory = DLTKLanguageManager.getSearchFactory(natureID);
        if (factory != null && (participant = factory.createSearchParticipant()) != null) {
            return participant;
        }
        return new DLTKSearchParticipant();
    }

    public static ISearchFactory getSearchFactory(String natureId) {
        return (ISearchFactory)InternalDLTKLanguageManager.getSearchManager().getObject(natureId);
    }

    public static IMatchLocator createMatchLocator(String natureID) {
        return InternalDLTKLanguageManager.createMatchLocator(natureID);
    }

    public static SourceIndexerRequestor createSourceRequestor(String natureID) {
        SourceIndexerRequestor requestor;
        ISearchFactory factory = DLTKLanguageManager.getSearchFactory(natureID);
        if (factory != null && (requestor = factory.createSourceRequestor()) != null) {
            requestor.setSearchFactory(factory);
            return requestor;
        }
        return new SourceIndexerRequestor();
    }

    public static IMatchLocatorParser createMatchParser(String natureID, MatchLocator matchLocator) {
        ISearchFactory factory = DLTKLanguageManager.getSearchFactory(natureID);
        if (factory != null) {
            return factory.createMatchParser(matchLocator);
        }
        return new MatchLocatorParser(matchLocator){};
    }

    public static ICalleeProcessor createCalleeProcessor(String natureID, IMethod member, IProgressMonitor progressMonitor, IDLTKSearchScope scope) {
        ICallHierarchyFactory factory = DLTKLanguageManager.getCallHierarchyFactory(natureID);
        if (factory != null) {
            ICalleeProcessor processor = factory.createCalleeProcessor(member, progressMonitor, scope);
            return processor;
        }
        return null;
    }

    private static ICallHierarchyFactory getCallHierarchyFactory(String natureId) {
        return (ICallHierarchyFactory)InternalDLTKLanguageManager.getCallHierarchyManager().getObject(natureId);
    }

    public static ICallProcessor createCallProcessor(String natureID) {
        ICallHierarchyFactory factory = DLTKLanguageManager.getCallHierarchyFactory(natureID);
        if (factory != null) {
            return factory.createCallProcessor();
        }
        return null;
    }

    public static IFileHierarchyResolver getFileHierarchyResolver(String natureId) {
        return (IFileHierarchyResolver)InternalDLTKLanguageManager.getFileHierarchyResolversManager().getObject(natureId);
    }

    public static ISearchPatternProcessor getSearchPatternProcessor(String natureId) {
        ISearchFactory factory = DLTKLanguageManager.getSearchFactory(natureId);
        if (factory != null) {
            return factory.createSearchPatternProcessor();
        }
        return null;
    }

    public static ISearchPatternProcessor getSearchPatternProcessor(IDLTKLanguageToolkit toolkit) {
        return DLTKLanguageManager.getSearchPatternProcessor(toolkit, false);
    }

    public static ISearchPatternProcessor getSearchPatternProcessor(IDLTKLanguageToolkit toolkit, boolean allowDefault) {
        ISearchPatternProcessor processor;
        if (toolkit != null && (processor = DLTKLanguageManager.getSearchPatternProcessor(toolkit.getNatureId())) != null) {
            return processor;
        }
        if (allowDefault) {
            return SearchPatternProcessor.getDefault();
        }
        return null;
    }

    public static Set<String> loadFilenameAssociations(String natureId) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(FILENAME_ASSOCIATION_EXT_POINT);
        HashSet<String> patterns = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (natureId.equals(element.getAttribute("nature")) && (pattern = element.getAttribute("pattern")) != null && pattern.length() != 0) {
                patterns.add(pattern);
            }
            ++n2;
        }
        return patterns;
    }
}

