/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text;

import org.eclipse.core.resources.IMarker;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.text.IScriptCorrectionContext;
import org.eclipse.dltk.ui.text.IScriptCorrectionProcessor;
import org.eclipse.dltk.ui.text.ScriptCorrectionAssistant;
import org.eclipse.dltk.ui.text.ScriptCorrectionContext;
import org.eclipse.dltk.ui.text.ScriptCorrectionProcessorManager;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class ScriptCorrectionProcessor
implements IQuickAssistProcessor {
    private final ScriptCorrectionAssistant fAssistant;

    public ScriptCorrectionProcessor(ScriptCorrectionAssistant tclCorrectionAssistant) {
        this.fAssistant = tclCorrectionAssistant;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return true;
    }

    public boolean canFix(Annotation annotation) {
        return ScriptCorrectionProcessorManager.canFix(this.getNatureId(), annotation);
    }

    private String getNatureId() {
        ScriptEditor editor = (ScriptEditor)this.fAssistant.getEditor();
        return editor.getLanguageToolkit().getNatureId();
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ScriptEditor editor = (ScriptEditor)this.fAssistant.getEditor();
        IScriptCorrectionProcessor[] processors = ScriptCorrectionProcessorManager.getProcessors(editor.getLanguageToolkit().getNatureId());
        if (processors == null) {
            return null;
        }
        ISourceModule sourceModule = EditorUtility.getEditorInputModelElement((IEditorPart)editor, false);
        ScriptCorrectionContext context = new ScriptCorrectionContext(invocationContext, (ITextEditor)editor, sourceModule);
        Annotation[] annotations = this.fAssistant.getAnnotationsAtOffset();
        int i = 0;
        while (i < annotations.length) {
            Annotation annotation = annotations[i];
            if (annotation instanceof IScriptAnnotation) {
                int j = 0;
                while (j < processors.length) {
                    processors[j].computeQuickAssistProposals((IScriptAnnotation)annotation, (IScriptCorrectionContext)context);
                    ++j;
                }
            } else if (annotation instanceof SimpleMarkerAnnotation) {
                IMarker marker = ((SimpleMarkerAnnotation)annotation).getMarker();
                int j = 0;
                while (j < processors.length) {
                    processors[j].computeQuickAssistProposals(marker, (IScriptCorrectionContext)context);
                    ++j;
                }
            }
            ++i;
        }
        return context.getProposals();
    }

    public String getErrorMessage() {
        return null;
    }
}

