/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.wizards.buildpath;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.internal.ui.wizards.BuildpathAttributeConfiguration;
import org.eclipse.dltk.ui.DLTKUIPlugin;

public class BuildpathAttributeConfigurationDescriptors {
    private static final String ATT_EXTENSION = "classpathAttributeConfiguration";
    private HashMap fDescriptors = null;

    private HashMap getDescriptors() {
        if (this.fDescriptors == null) {
            this.fDescriptors = BuildpathAttributeConfigurationDescriptors.readExtensions();
        }
        return this.fDescriptors;
    }

    public boolean containsKey(String attributeKey) {
        return this.getDescriptors().containsKey(attributeKey);
    }

    public BuildpathAttributeConfiguration get(final String attributeKey) {
        final Descriptor desc = (Descriptor)this.getDescriptors().get(attributeKey);
        if (desc == null) {
            return null;
        }
        final BuildpathAttributeConfiguration[] res = new BuildpathAttributeConfiguration[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                DLTKUIPlugin.log(exception);
                BuildpathAttributeConfigurationDescriptors.this.getDescriptors().remove(attributeKey);
            }

            public void run() throws Exception {
                res[0] = desc.getInstance();
            }
        });
        return res[0];
    }

    private static HashMap readExtensions() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dltk.ui", ATT_EXTENSION);
        HashMap<String, Descriptor> descriptors = new HashMap<String, Descriptor>(elements.length * 2);
        int i = 0;
        while (i < elements.length) {
            try {
                Descriptor curr = new Descriptor(elements[i]);
                descriptors.put(curr.getKey(), curr);
            }
            catch (CoreException e) {
                DLTKUIPlugin.log(e);
            }
            ++i;
        }
        return descriptors;
    }

    private static class Descriptor {
        private IConfigurationElement fConfigElement;
        private BuildpathAttributeConfiguration fInstance;
        private static final String ATT_NAME = "attributeName";
        private static final String ATT_CLASS = "class";

        public Descriptor(IConfigurationElement configElement) throws CoreException {
            this.fConfigElement = configElement;
            this.fInstance = null;
            String name = configElement.getAttribute(ATT_NAME);
            String pageClassName = configElement.getAttribute(ATT_CLASS);
            if (name == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ui", 0, "Invalid extension (missing attributeName)", null));
            }
            if (pageClassName == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ui", 0, "Invalid extension (missing class name): " + name, null));
            }
        }

        public synchronized BuildpathAttributeConfiguration getInstance() throws CoreException {
            if (this.fInstance == null) {
                Object elem = CoreUtility.createExtension(this.fConfigElement, ATT_CLASS);
                if (elem instanceof BuildpathAttributeConfiguration) {
                    this.fInstance = (BuildpathAttributeConfiguration)elem;
                } else {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ui", 0, "Invalid extension (page not of type IClasspathContainerPage): " + this.getKey(), null));
                }
            }
            return this.fInstance;
        }

        public String getKey() {
            return this.fConfigElement.getAttribute(ATT_NAME);
        }
    }
}

