/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.codeassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.ISourceParser;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclASTUtil;

public abstract class TclAssistParser
implements IAssistParser {
    public static final int MODULE = 1;
    public static final int NAMESPACE = 2;
    public static final int FUNCTION = 3;
    public static final int EXEC_EXPRESSION = 4;
    protected ISourceParser parser = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.tcl.core.nature");
    protected ModuleDeclaration module;
    protected ASTNode assistNodeParent = null;

    public ASTNode getAssistNodeParent() {
        return this.assistNodeParent;
    }

    protected void findElementsTo(List statements, ASTNode node, List elements) {
        if (statements == null) {
            return;
        }
        for (ASTNode n : statements) {
            if (n.equals((Object)node)) {
                elements.add(n);
                return;
            }
            if (n.sourceStart() > node.sourceStart() || node.sourceEnd() > n.sourceEnd()) continue;
            elements.add(n);
            this.findElementsTo(TclASTUtil.getStatements(n), node, elements);
            return;
        }
    }

    protected List findLevelsTo(ASTNode astNodeParent) {
        ArrayList<ModuleDeclaration> elements = new ArrayList<ModuleDeclaration>();
        if (this.module != null || astNodeParent instanceof ModuleDeclaration) {
            if (this.module == null) {
                this.module = (ModuleDeclaration)astNodeParent;
            }
            elements.add(this.module);
            this.findElementsTo(TclASTUtil.getStatements((ASTNode)this.module), astNodeParent, elements);
        }
        return elements;
    }

    public void setSource(ModuleDeclaration unit) {
        this.module = unit;
    }

    public ModuleDeclaration parse(IModuleSource sourceUnit) {
        this.module = (ModuleDeclaration)this.parser.parse(sourceUnit, null);
        this.module.rebuild();
        TclASTUtil.extendStatements((ASTNode)this.module, sourceUnit.getSourceContents());
        return this.module;
    }

    public ModuleDeclaration getModule() {
        return this.module;
    }
}

