# Commands covered:  history
#
# This file contains a collection of tests for one or more of the Tcl
# built-in commands.  Sourcing this file into Tcl runs the tests and
# generates output for errors.  No output means no errors were found.
#
# Copyright (c) 1991-1993 The Regents of the University of California.
# Copyright (c) 1994 Sun Microsystems, Inc.
# Copyright (c) 1998-1999 by Scriptics Corporation.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# RCS: @(#) $Id: history.tcl,v 1.1 2006/12/29 09:02:53 fourdman Exp $
  
if {[lsearch [namespace children] ::tcltest] == -1} {
    package require tcltest
    namespace import -force ::tcltest::*
}

if {[catch {history}]} {
    puts stdout "This version of Tcl was built without the history command;\n"
    puts stdout "history tests will be skipped.\n"
    ::tcltest::cleanupTests
    return
}

set num [history nextid]
history keep 3
history add {set a 12345}
history add {set b [format {A test %s} string]}
history add {Another test}

# "history event"

test history-1.1 {event option} {history event -1} \
	{set b [format {A test %s} string]}
test history-1.2 {event option} {history event $num} \
	{set a 12345}
test history-1.3 {event option} {history event [expr $num+2]} \
	{Another test}
test history-1.4 {event option} {history event set} \
	{set b [format {A test %s} string]}
test history-1.5 {event option} {history e "* a*"} \
	{set a 12345}
test history-1.6 {event option} {catch {history event *gorp} msg} 1
test history-1.7 {event option} {
    catch {history event *gorp} msg
    set msg
} {no event matches "*gorp"}
test history-1.8 {event option} {history event} \
	{set b [format {A test %s} string]}
test history-1.9 {event option} {catch {history event 123 456} msg} 1
test history-1.10 {event option} {
    catch {history event 123 456} msg
    set msg
} {wrong # args: should be "history event ?event?"}

# "history redo"

set a 0
history redo -2
test history-2.1 {redo option} {set a} 12345
set b 0
history redo
test history-2.2 {redo option} {set b} {A test string}
test history-2.3 {redo option} {catch {history redo -3 -4}} 1
test history-2.4 {redo option} {
    catch {history redo -3 -4} msg
    set msg
} {wrong # args: should be "history redo ?event?"}

# "history add"

history add "set a 444" exec
test history-3.1 {add option} {set a} 444
test history-3.2 {add option} {catch {history add "set a 444" execGorp}} 1
test history-3.3 {add option} {
    catch {history add "set a 444" execGorp} msg
    set msg
} {bad argument "execGorp": should be "exec"}
test history-3.4 {add option} {catch {history add "set a 444" a} msg} 1
test history-3.5 {add option} {
    catch {history add "set a 444" a} msg
    set msg
} {bad argument "a": should be "exec"}
history add "set a 555" e
test history-3.6 {add option} {set a} 555
history add "set a 666"
test history-3.7 {add option} {set a} 555
test history-3.8 {add option} {catch {history add "set a 666" e f} msg} 1
test history-3.9 {add option} {
    catch {history add "set a 666" e f} msg
    set msg
} {wrong # args: should be "history add event ?exec?"}

# "history change"

history change "A test value"
test history-4.1 {change option} {history event [expr {[history n]-1}]} \
	"A test value"
history ch "Another test" -1
test history-4.2 {change option} {history e} "Another test"
test history-4.3 {change option} {history event [expr {[history n]-1}]} \
	"A test value"
test history-4.4 {change option} {catch {history change Foo 4 10}} 1
test history-4.5 {change option} {
    catch {history change Foo 4 10} msg
    set msg
} {wrong # args: should be "history change newValue ?event?"}
test history-4.6 {change option} {
    catch {history change Foo [expr {[history n]-4}]}
} 1
set num [expr {[history n]-4}]
test history-4.7 {change option} {
    catch {history change Foo $num} msg
    set msg
} "event \"$num\" is too far in the past"

# "history info"

set num [history n]
history add set\ a\ {b\nc\ d\ e}
history add {set b 1234}
history add set\ c\ {a\nb\nc}
test history-5.1 {info option} {history info} [format {%6d  set a {b
	c d e}
%6d  set b 1234
%6d  set c {a
	b
	c}} $num [expr $num+1] [expr $num+2]]
test history-5.2 {info option} {history i 2} [format {%6d  set b 1234
%6d  set c {a
	b
	c}} [expr $num+1] [expr $num+2]]
test history-5.3 {info option} {catch {history i 2 3}} 1
test history-5.4 {info option} {
    catch {history i 2 3} msg
    set msg
} {wrong # args: should be "history info ?count?"}
test history-5.5 {info option} {history} [format {%6d  set a {b
	c d e}
%6d  set b 1234
%6d  set c {a
	b
	c}} $num [expr $num+1] [expr $num+2]]

# "history keep"

history add "foo1"
history add "foo2"
history add "foo3"
history keep 2
test history-6.1 {keep option} {history event [expr [history n]-1]} foo3
test history-6.2 {keep option} {history event -1} foo2
test history-6.3 {keep option} {catch {history event -3}} 1
test history-6.4 {keep option} {
    catch {history event -3} msg
    set msg
} {event "-3" is too far in the past}
history k 5
test history-6.5 {keep option} {history event -1} foo2
test history-6.6 {keep option} {history event -2} {}
test history-6.7 {keep option} {history event -3} {}
test history-6.8 {keep option} {history event -4} {}
test history-6.9 {keep option} {catch {history event -5}} 1
test history-6.10 {keep option} {catch {history keep 4 6}} 1
test history-6.11 {keep option} {
    catch {history keep 4 6} msg
    set msg
} {wrong # args: should be "history keep ?count?"}
test history-6.12 {keep option} {catch {history keep}} 0
test history-6.13 {keep option} {
    history keep
} {5}
test history-6.14 {keep option} {catch {history keep -3}} 1
test history-6.15 {keep option} {
    catch {history keep -3} msg
    set msg
} {illegal keep count "-3"}
test history-6.16 {keep option} {
    catch {history keep butter} msg
    set msg
} {illegal keep count "butter"}

# "history nextid"

set num [history n]
history add "Testing"
history add "Testing2"
test history-7.1 {nextid option} {history event} "Testing"
test history-7.2 {nextid option} {history next} [expr $num+2]
test history-7.3 {nextid option} {catch {history nextid garbage}} 1
test history-7.4 {nextid option} {
    catch {history nextid garbage} msg
    set msg
} {wrong # args: should be "history nextid"}

# "history clear"

set num [history n]
history add "Testing"
history add "Testing2"
test history-8.1 {clear option} {catch {history clear junk}} 1
test history-8.2 {clear option} {history clear} {}
history add "Testing"
test history-8.3 {clear option} {history} {     1  Testing}

# miscellaneous

test history-9.1 {miscellaneous} {catch {history gorp} msg} 1
test history-9.2 {miscellaneous} {
    catch {history gorp} msg
    set msg
} {bad option "gorp": must be add, change, clear, event, info, keep, nextid, or redo}

# cleanup
::tcltest::cleanupTests
return












