/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.documentation;

import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.ruby.core.PredefinedVariables;
import org.eclipse.dltk.ruby.core.model.FakeField;
import org.eclipse.dltk.ruby.internal.ui.docs.RiHelper;
import org.eclipse.dltk.ruby.internal.ui.text.RubyPartitionScanner;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class RubyDocumentationProvider
implements IScriptDocumentationProvider {
    private static final String PUBLIC = "public";
    private static final String PROTECTED = "protected";
    private static final String PRIVATE = "private";
    private static final String NOTHING_KNOWN_ABOUT = "Nothing known about";

    protected String getLine(Document d, int line) throws BadLocationException {
        return d.get(d.getLineOffset(line), d.getLineLength(line));
    }

    private static void installStuff(Document document) {
        String[] types = new String[]{"__ruby_string", "__ruby_single_quote_string", "__ruby_percent_string", "__ruby_comment", "__ruby_doc", "__dftl_partition_content_type"};
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new RubyPartitionScanner(), types);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("__ruby_partitioning", (IDocumentPartitioner)partitioner);
    }

    private static void removeStuff(Document document) {
        document.setDocumentPartitioner("__ruby_partitioning", null);
    }

    private static int findOffsetBeforeMethod(Document doc, int start) throws BadLocationException {
        String s;
        IRegion r;
        int line = doc.getLineOfOffset(start);
        do {
            if (--line >= 0) continue;
            throw new BadLocationException();
        } while ((r = doc.getLineInformation(line)).getLength() == 0 || RubyDocumentationProvider.isBlank(s = doc.get(r.getOffset(), r.getLength())) || PUBLIC.equals(s = s.trim()) || PROTECTED.equals(s) || PRIVATE.equals(s));
        return r.getOffset() + r.getLength() - 1;
    }

    public static String getHeaderComment(String contents, int offset) {
        int start;
        int end = start = offset;
        Document doc = new Document(contents);
        RubyDocumentationProvider.installStuff(doc);
        try {
            String content;
            ITypedRegion region;
            int pos = 0;
            if (start > 0) {
                pos = RubyDocumentationProvider.findOffsetBeforeMethod(doc, start);
            }
            while (pos >= 0 && pos <= doc.getLength()) {
                region = TextUtilities.getPartition((IDocument)doc, (String)"__ruby_partitioning", (int)pos, (boolean)true);
                if (region.getType().equals("__ruby_doc") || region.getType().equals("__ruby_comment")) {
                    start = region.getOffset();
                }
                if (region.getType().equals("__dftl_partition_content_type") && (content = doc.get(region.getOffset(), region.getLength()).trim()).length() > 0 && !content.startsWith(PUBLIC) && !content.startsWith(PROTECTED) && !content.startsWith(PRIVATE)) break;
                pos = region.getOffset() - 1;
            }
            pos = start + 1;
            while (pos <= doc.getLength()) {
                region = TextUtilities.getPartition((IDocument)doc, (String)"__ruby_partitioning", (int)pos, (boolean)true);
                if (region.getType().equals("__ruby_doc") || region.getType().equals("__ruby_comment")) {
                    end = region.getOffset() + region.getLength();
                }
                if (region.getType().equals("__dftl_partition_content_type") && (content = doc.get(region.getOffset(), region.getLength()).trim()).length() > 0 && !content.startsWith(PUBLIC) && !content.startsWith(PROTECTED) && !content.startsWith(PRIVATE)) break;
                pos = region.getOffset() + region.getLength() + 1;
            }
            if (end >= doc.getLength()) {
                end = doc.getLength() - 1;
            }
            String string = doc.get(start, end - start);
            return string;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        finally {
            RubyDocumentationProvider.removeStuff(doc);
        }
    }

    protected String getHeaderComment(IMember member) {
        ISourceModule sourceModule;
        int offset;
        block9: {
            ISourceRange range;
            block8: {
                if (member instanceof IField) {
                    try {
                        if ((member.getFlags() & 2) == 0) {
                            return null;
                        }
                    }
                    catch (ModelException modelException) {
                        return null;
                    }
                }
                try {
                    range = member.getSourceRange();
                    if (range != null) break block8;
                    return null;
                }
                catch (ModelException modelException) {
                    return null;
                }
            }
            offset = range.getOffset();
            sourceModule = member.getSourceModule();
            if (sourceModule.isConsistent()) break block9;
            return null;
        }
        String contents = sourceModule.getSource();
        return RubyDocumentationProvider.getHeaderComment(contents, offset);
    }

    private Reader proccessBuiltinType(IType type) {
        String keyword = type.getElementName();
        RiHelper helper = RiHelper.getInstance();
        String doc = helper.getDocFor(keyword);
        if (doc != null) {
            return new StringReader(doc);
        }
        return null;
    }

    private Reader proccessBuiltinMethod(IMethod method) {
        IModelElement pp = method.getAncestor(7);
        if (pp == null) {
            return null;
        }
        if (pp.getElementName().startsWith("<<")) {
            pp = pp.getAncestor(7);
        }
        String keyword = String.valueOf(pp.getElementName()) + "#" + method.getElementName();
        RiHelper helper = RiHelper.getInstance();
        String doc = helper.getDocFor(keyword);
        if (doc != null && (doc.indexOf(NOTHING_KNOWN_ABOUT) >= 0 || RubyDocumentationProvider.isBlank(doc))) {
            if (pp.getElementName().equals("Kernel")) {
                keyword = "Object#" + method.getElementName();
                doc = helper.getDocFor(keyword);
                if (doc != null && doc.indexOf(NOTHING_KNOWN_ABOUT) >= 0) {
                    doc = null;
                }
            } else {
                doc = null;
            }
        }
        if (doc != null) {
            return new StringReader(doc);
        }
        return null;
    }

    public Reader getInfo(IMember member, boolean lookIntoParents, boolean lookIntoExternal) {
        FakeField field;
        String doc;
        boolean isBuiltin = member.getAncestor(3) instanceof BuiltinProjectFragment;
        if (isBuiltin && member instanceof IMethod) {
            IMethod method = (IMethod)member;
            return this.proccessBuiltinMethod(method);
        }
        if (isBuiltin && member instanceof IType) {
            IType type = (IType)member;
            return this.proccessBuiltinType(type);
        }
        if (member instanceof FakeField && (doc = PredefinedVariables.getDocOf((String)(field = (FakeField)member).getElementName())) != null) {
            return new StringReader(doc);
        }
        String header = this.getHeaderComment(member);
        if (header == null || header.length() == 0) {
            return null;
        }
        return new StringReader(this.convertToHTML(header));
    }

    private static String replaceSpecTag(String original, String sc, String tag) {
        Matcher matcher;
        String filtered = original;
        if (sc.equals("*") || sc.equals("+")) {
            sc = "\\" + sc;
        }
        Pattern bold = Pattern.compile(String.valueOf(sc) + "[_a-zA-Z0-9]+" + sc);
        while ((matcher = bold.matcher(filtered)).find()) {
            String startStr = filtered.substring(0, matcher.start());
            String endStr = filtered.substring(matcher.end());
            String grp = matcher.group();
            filtered = String.valueOf(startStr) + "<" + tag + ">" + grp.substring(1, grp.length() - 1) + "</" + tag + ">" + endStr;
        }
        return filtered;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String convertToHTML(String header) {
        if (header == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        Document d = new Document(header);
        boolean enabled = true;
        int line = 0;
        while (true) {
            block14: {
                try {
                    String str = this.getLine(d, line).trim();
                    if (str == null) {
                        return result.toString();
                    }
                    if (str.startsWith("#--")) {
                        enabled = false;
                    } else if (str.startsWith("#++")) {
                        enabled = true;
                        break block14;
                    }
                    if (!enabled || str.startsWith("=begin") || str.startsWith("=end")) break block14;
                    while (true) {
                        if (str.length() <= 0 || !str.startsWith("#")) {
                            str = RubyDocumentationProvider.replaceSpecTag(str, "*", "b");
                            str = RubyDocumentationProvider.replaceSpecTag(str, "+", "tt");
                            str = RubyDocumentationProvider.replaceSpecTag(str, "_", "em");
                            str.replaceAll("\\*[_a-zA-Z0-9]+\\*", "");
                            if (str.length() != 0) break;
                            result.append("<p>");
                            break block14;
                        }
                        str = str.substring(1);
                    }
                    if (str.trim().startsWith("== ")) {
                        result.append("<h2>");
                        result.append(str.substring(3));
                        result.append("</h2>");
                        break block14;
                    }
                    if (str.trim().startsWith("= ")) {
                        result.append("<h1>");
                        result.append(str.substring(2));
                        result.append("</h1>");
                        break block14;
                    }
                    if (str.trim().startsWith("---")) {
                        result.append("<hr>");
                    } else {
                        result.append(String.valueOf(str) + "<br>");
                    }
                }
                catch (BadLocationException badLocationException) {
                    return result.toString();
                }
            }
            ++line;
        }
    }

    public Reader getInfo(String content) {
        return null;
    }

    private static boolean isBlank(String s) {
        int len;
        if (s != null && (len = s.length()) != 0) {
            int i = 0;
            while (i < len) {
                if (!Character.isWhitespace(s.charAt(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

