/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.core.codeassist;

import com.xored.org.mozilla.javascript.CompilerEnvirons;
import com.xored.org.mozilla.javascript.Parser;
import com.xored.org.mozilla.javascript.ScriptOrFnNode;
import java.util.Collections;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.javascript.parser.NullReporter;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ResolverManager;
import org.eclipse.dltk.internal.javascript.typeinference.CompletionString;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.PositionReachedException;
import org.eclipse.dltk.internal.javascript.typeinference.TypeInferencer;

public class AssitUtils {
    public static ReferenceResolverContext buildContext(ISourceModule module, int position, String content, String fileName2) {
        ReferenceResolverContext createResolverContext = ResolverManager.createResolverContext(module, Collections.emptyMap(), false);
        createResolverContext.init();
        Parser p = new Parser(new CompilerEnvirons(), new NullReporter());
        ScriptOrFnNode parse = p.parse(content, fileName2, 0);
        TypeInferencer inf = new TypeInferencer((ModelElement)module, createResolverContext);
        try {
            inf.doInterferencing(parse, position);
        }
        catch (PositionReachedException positionReachedException) {}
        HostCollection collection = inf.getCollection();
        createResolverContext.setHostCollection(collection);
        return createResolverContext;
    }

    public static class PositionCalculator {
        private boolean isMember;
        private final String completion;
        private final String completionPart;
        private final String corePart;

        public PositionCalculator(String conString, int pos, boolean bothSides) {
            if (bothSides) {
                int maxPos = conString.length();
                if (pos < maxPos) {
                    while (pos < maxPos) {
                        char charAt = conString.charAt(pos);
                        if (Character.isJavaIdentifierPart(charAt)) {
                            ++pos;
                            continue;
                        }
                        break;
                    }
                } else {
                    pos = maxPos;
                }
            }
            this.completion = CompletionString.parse(conString.substring(0, pos), false);
            int lastDot = this.completion.lastIndexOf(46);
            if (lastDot != -1) {
                this.isMember = true;
                this.completionPart = this.completion.substring(lastDot + 1);
                this.corePart = this.completion.substring(0, lastDot);
            } else {
                this.isMember = false;
                this.completionPart = this.completion;
                this.corePart = this.completion;
            }
        }

        public String getCompletion() {
            return this.completion;
        }

        public String getCompletionPart() {
            return this.completionPart;
        }

        public String getCorePart() {
            return this.corePart;
        }

        public boolean isMember() {
            return this.isMember;
        }
    }
}

