/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.task.ITaskReporter;
import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.compiler.task.TodoTaskSimpleParser;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.Script;

public class JavaScriptTodoParser
extends TodoTaskSimpleParser
implements IBuildParticipant {
    public JavaScriptTodoParser(ITodoTaskPreferences preferences) {
        super(preferences);
    }

    public void build(IBuildContext context) throws CoreException {
        Script script = JavaScriptValidations.parse(context);
        if (script == null) {
            return;
        }
        DelegatingTaskReporter taskReporter = new DelegatingTaskReporter(context.getTaskReporter());
        for (Comment comment : script.getComments()) {
            taskReporter.locationOffset = comment.sourceStart();
            taskReporter.lineOffset = context.getLineTracker().getLineNumberOfOffset(comment.sourceStart());
            this.parse(taskReporter, comment.getText().toCharArray());
        }
    }

    protected int findCommentStart(char[] content, int begin, int end) {
        int i = begin = JavaScriptTodoParser.skipSpaces((char[])content, (int)begin, (int)end);
        while (i < end) {
            if (content[i] == '/' && i + 1 < end && content[i + 1] == '/') {
                return i + 2;
            }
            if (content[i] == '*') {
                return i + 1;
            }
            if (content[i] == '/' && i + 1 < end && content[i + 1] == '*') {
                i += 2;
                while (i < end && content[i] == '*') {
                    ++i;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static class DelegatingTaskReporter
    implements ITaskReporter {
        private final ITaskReporter taskReporter;
        int lineOffset;
        int locationOffset;

        public DelegatingTaskReporter(ITaskReporter taskReporter) {
            this.taskReporter = taskReporter;
        }

        public void reportTask(String message, int lineNumber, int priority, int charStart, int charEnd) {
            this.taskReporter.reportTask(message, lineNumber + this.lineOffset, priority, charStart + this.locationOffset, charEnd + this.locationOffset);
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }
}

