/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.util;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UTFDataFormatException;
import java.net.URI;
import java.util.StringTokenizer;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.RuntimePerformanceMonitor;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.osgi.util.NLS;

public class Util {
    private static final char NEW_FORMAT_MARK = '+';
    private static final char ARGUMENTS_DELIMITER = '#';
    private static final String ARGUMENTS_DELIMITER_STR = String.valueOf('#');
    private static final String EMPTY_ARGUMENT = "   ";
    public static final String UTF_8 = "UTF-8";

    public static String toString(Object[] objects) {
        return Util.toString(objects, new Displayable(){

            public String displayString(Object o) {
                if (o == null) {
                    return "null";
                }
                return o.toString();
            }
        });
    }

    public static String toString(Object[] objects, Displayable renderer) {
        if (objects == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(10);
        int i = 0;
        while (i < objects.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(renderer.displayString(objects[i]));
            ++i;
        }
        return buffer.toString();
    }

    public static void log(Throwable e, String message) {
        Throwable nestedException;
        if (e == null && message == null) {
            return;
        }
        if (e instanceof ModelException && (nestedException = ((ModelException)((Object)e)).getException()) != null) {
            e = nestedException;
        }
        Status status = new Status(4, "org.eclipse.dltk.core", 4, message != null ? message : e.toString(), e);
        DLTKCore.getDefault().getLog().log((IStatus)status);
    }

    public static int combineHashCodes(int hashCode1, int hashCode2) {
        return hashCode1 * 17 + hashCode2;
    }

    private static void quickSort(String[] sortedCollection, int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = sortedCollection[(left + right) / 2];
        while (true) {
            if (sortedCollection[left].compareTo(mid) < 0) {
                ++left;
                continue;
            }
            while (mid.compareTo(sortedCollection[right]) < 0) {
                --right;
            }
            if (left <= right) {
                String tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(sortedCollection, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(sortedCollection, left, original_right);
        }
    }

    public static boolean equalArrays(Object[] a, Object[] b, int len) {
        if (a == b) {
            return true;
        }
        if (a.length < len || b.length < len) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i] == null ? b[i] != null : !a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalArraysOrNull(Object[] a, Object[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (a[i] == null ? b[i] != null : !a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isNewProblemArgumentsFormat(String[] arguments) {
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i].indexOf(35) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getProblemArgumentsForMarker(String[] arguments) {
        if (Util.isNewProblemArgumentsFormat(arguments)) {
            return Util.encodeProblemArguments(arguments);
        }
        StringBuffer args = new StringBuffer(10);
        args.append(arguments.length);
        args.append(':');
        int j = 0;
        while (j < arguments.length) {
            if (j != 0) {
                args.append('#');
            }
            if (arguments[j].length() == 0) {
                args.append(EMPTY_ARGUMENT);
            } else {
                args.append(arguments[j]);
            }
            ++j;
        }
        return args.toString();
    }

    private static String encodeProblemArguments(String[] arguments) {
        StringBuffer args = new StringBuffer();
        args.append('+');
        args.append(arguments.length);
        int j = 0;
        while (j < arguments.length) {
            args.append('#');
            args.append(arguments[j].length());
            args.append('#');
            args.append(arguments[j]);
            ++j;
        }
        return args.toString();
    }

    public static String[] getProblemArgumentsFromMarker(String argumentsString) {
        int numberOfArg;
        if (argumentsString == null || argumentsString.length() == 0) {
            return null;
        }
        if (argumentsString.charAt(0) == '+') {
            return Util.decodeProblemArguments(argumentsString);
        }
        int index = argumentsString.indexOf(58);
        if (index == -1) {
            return null;
        }
        int length = argumentsString.length();
        try {
            numberOfArg = Integer.parseInt(argumentsString.substring(0, index));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        argumentsString = argumentsString.substring(index + 1, length);
        String[] args = new String[length];
        int count = 0;
        StringTokenizer tokenizer = new StringTokenizer(argumentsString, ARGUMENTS_DELIMITER_STR);
        while (tokenizer.hasMoreTokens()) {
            String argument = tokenizer.nextToken();
            if (argument.equals(EMPTY_ARGUMENT)) {
                argument = "";
            }
            args[count++] = argument;
        }
        if (count != numberOfArg) {
            return null;
        }
        String[] stringArray = args;
        args = new String[count];
        System.arraycopy(stringArray, 0, args, 0, count);
        return args;
    }

    private static String[] decodeProblemArguments(String s) {
        int numberOfArg;
        int begin = 1;
        int pos = s.indexOf(35, begin);
        if (pos == -1) {
            return null;
        }
        try {
            numberOfArg = Integer.parseInt(s.substring(begin, pos));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        begin = pos;
        String[] args = new String[numberOfArg];
        int length = s.length();
        int i = 0;
        while (i < numberOfArg) {
            int argLen;
            if (begin >= length || s.charAt(begin) != '#') {
                return null;
            }
            if ((pos = s.indexOf(35, ++begin)) == -1) {
                return null;
            }
            try {
                argLen = Integer.parseInt(s.substring(begin, pos));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            begin = pos + 1;
            if (begin + argLen > length) {
                return null;
            }
            args[i] = s.substring(begin, begin + argLen);
            begin += argLen;
            ++i;
        }
        if (begin != length) {
            return null;
        }
        return args;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getResourceContentsAsByteArray(IFile file) throws ModelException {
        byte[] byArray;
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(file.getContents(true));
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
        try {
            byte[] size = org.eclipse.dltk.compiler.util.Util.getInputStreamAsByteArray(stream, -1);
            p.done("#", "IO Read", size.length);
            byArray = size;
        }
        catch (IOException e) {
            try {
                throw new ModelException(e, 985);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            ((InputStream)stream).close();
            return byArray;
        }
        catch (IOException iOException) {}
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getResourceContentsAsByteArray(File file) throws ModelException {
        byte[] byArray;
        BufferedInputStream stream = null;
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        try {
            stream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        try {
            byte[] data = org.eclipse.dltk.compiler.util.Util.getInputStreamAsByteArray(stream, -1);
            p.done("#", "IO Read", data.length);
            byArray = data;
        }
        catch (IOException e) {
            try {
                throw new ModelException(e, 985);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            ((InputStream)stream).close();
            return byArray;
        }
        catch (IOException iOException) {}
        return byArray;
    }

    public static String getLineSeparator(String text, IScriptProject project) {
        IScopeContext[] scopeContext;
        String lineSeparator = null;
        if (text != null && text.length() != 0 && (lineSeparator = Util.findLineSeparator(text.toCharArray())) != null) {
            return lineSeparator;
        }
        if (project != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(project.getProject())};
            lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineSeparator != null) {
                return lineSeparator;
            }
        }
        scopeContext = new IScopeContext[]{new InstanceScope()};
        lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
        if (lineSeparator != null) {
            return lineSeparator;
        }
        return org.eclipse.dltk.compiler.util.Util.LINE_SEPARATOR;
    }

    public static String findLineSeparator(char[] text) {
        int length = text.length;
        if (length > 0) {
            int nextChar = text[0];
            int i = 0;
            while (i < length) {
                int currentChar = nextChar;
                nextChar = i < length - 1 ? text[i + 1] : 32;
                switch (currentChar) {
                    case 10: {
                        return "\n";
                    }
                    case 13: {
                        return nextChar == 10 ? "\r\n" : "\r";
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static void verbose(String log) {
        Util.verbose(log, System.out);
    }

    public static synchronized void verbose(String log, PrintStream printStream) {
        int end;
        int start = 0;
        do {
            end = log.indexOf(10, start);
            printStream.print(Thread.currentThread());
            printStream.print(" ");
            printStream.print(log.substring(start, end == -1 ? log.length() : end + 1));
        } while ((start = end + 1) != 0);
        printStream.println();
    }

    public static char[] getResourceContentsAsCharArray(IFile file) throws ModelException {
        char[] result = ModelManager.getModelManager().getFileCache().get(file);
        if (result != null) {
            return result;
        }
        String encoding = null;
        try {
            encoding = file.getCharset();
        }
        catch (CoreException coreException) {}
        return Util.getResourceContentsAsCharArray(file, encoding);
    }

    public static char[] getResourceContentsAsCharArray(IFileHandle file) throws ModelException {
        char[] result = ModelManager.getModelManager().getFileCache().get(file);
        if (result != null) {
            return result;
        }
        return Util.getResourceContentsAsCharArrayNoCache(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] getResourceContentsAsCharArrayNoCache(IFileHandle file) throws ModelException {
        char[] cArray;
        BufferedInputStream stream = null;
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        try {
            stream = new BufferedInputStream(file.openInputStream(null));
        }
        catch (Exception e) {
            throw new ModelException(e, 969);
        }
        try {
            char[] data = org.eclipse.dltk.compiler.util.Util.getInputStreamAsCharArray(stream, -1, null);
            p.done("#", "IO Read", data.length);
            cArray = data;
        }
        catch (IOException e) {
            try {
                throw new ModelException(e, 985);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            ((InputStream)stream).close();
            return cArray;
        }
        catch (IOException iOException) {}
        return cArray;
    }

    private static boolean isFatalException(CoreException e) {
        return e.getCause() instanceof FileNotFoundException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] getResourceContentsAsCharArray(IFile file, String encoding) throws ModelException {
        char[] cArray;
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        InputStream stream = null;
        int tryCount = 10;
        try {
            while (true) {
                if (stream != null) {
                    char[] data = org.eclipse.dltk.compiler.util.Util.getInputStreamAsCharArray(stream, -1, encoding);
                    IEnvironment env = EnvironmentManager.getEnvironment((IResource)file);
                    p.done("#", "IO Read", data.length, env);
                    cArray = data;
                    if (stream == null) return cArray;
                    break;
                }
                try {
                    stream = file.getContents(true);
                }
                catch (CoreException e) {
                    if (Util.isFatalException(e)) throw new ModelException(e, 969);
                    if (--tryCount == 0) {
                        throw new ModelException(e, 969);
                    }
                    Status status = new Status(2, "org.eclipse.dltk.core", NLS.bind((String)Messages.Util_errorReceivingFile, (Object)file.getFullPath(), (Object)String.valueOf(tryCount)), (Throwable)e);
                    DLTKCore.getDefault().getLog().log((IStatus)status);
                }
            }
        }
        catch (IOException e) {
            try {
                throw new ModelException(e, 985);
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            stream.close();
            return cArray;
        }
        catch (IOException iOException) {}
        return cArray;
    }

    public static String relativePath(IPath fullPath, int skipSegmentCount) {
        boolean hasTrailingSeparator = fullPath.hasTrailingSeparator();
        String[] segments = fullPath.segments();
        int length = 0;
        int max = segments.length;
        if (max > skipSegmentCount) {
            int i1 = skipSegmentCount;
            while (i1 < max) {
                length += segments[i1].length();
                ++i1;
            }
            length += max - skipSegmentCount - 1;
        }
        if (hasTrailingSeparator) {
            ++length;
        }
        char[] result = new char[length];
        int offset = 0;
        int len = segments.length - 1;
        if (len >= skipSegmentCount) {
            int i = skipSegmentCount;
            while (i < len) {
                int size = segments[i].length();
                segments[i].getChars(0, size, result, offset);
                offset += size;
                result[offset++] = 47;
                ++i;
            }
            int size = segments[len].length();
            segments[len].getChars(0, size, result, offset);
            offset += size;
        }
        if (hasTrailingSeparator) {
            result[offset++] = 47;
        }
        return new String(result);
    }

    public static final boolean isExcluded(IModelElement element) {
        int elementType = element.getElementType();
        switch (elementType) {
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
            case 4: {
                IProjectFragment root = (IProjectFragment)element.getAncestor(3);
                IResource resource = element.getResource();
                return resource != null && Util.isExcluded(resource, root);
            }
            case 5: {
                IProjectFragment root = (IProjectFragment)element.getAncestor(3);
                IResource resource = element.getResource();
                if (resource != null && Util.isExcluded(resource, root)) {
                    return true;
                }
                return Util.isExcluded(element.getParent());
            }
        }
        IModelElement cu = element.getAncestor(5);
        return cu != null && Util.isExcluded(cu);
    }

    public static final boolean isExcluded(IPath resourcePath, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean isFolderPath) {
        if (inclusionPatterns == null && exclusionPatterns == null) {
            return false;
        }
        return org.eclipse.dltk.compiler.util.Util.isExcluded(resourcePath.toString().toCharArray(), inclusionPatterns, exclusionPatterns, isFolderPath);
    }

    public static final boolean isExcluded(IResource resource, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        IPath path = resource.getFullPath();
        int resourceType = resource.getType();
        return Util.isExcluded(path, inclusionPatterns, exclusionPatterns, resourceType == 2 || resourceType == 4);
    }

    public static final boolean isExcluded(IResource resource, IProjectFragment fragment) {
        IPath path = resource.getFullPath();
        int resourceType = resource.getType();
        return Util.isExcluded(path, fragment, resourceType == 2 || resourceType == 4);
    }

    public static boolean isValidSourceModule(IModelElement parent, IResource resource) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(parent);
        if (toolkit != null) {
            return DLTKContentTypeManager.isValidResourceForContentType(toolkit, resource);
        }
        toolkit = DLTKLanguageManager.findToolkit(resource);
        if (toolkit != null) {
            return DLTKContentTypeManager.isValidResourceForContentType(toolkit, resource);
        }
        return false;
    }

    public static boolean isValidSourceModule(IModelElement parent, IPath path) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(parent);
        if (toolkit != null) {
            return DLTKContentTypeManager.isValidFileNameForContentType(toolkit, path);
        }
        toolkit = DLTKLanguageManager.findToolkit(path);
        if (toolkit != null) {
            return DLTKContentTypeManager.isValidFileNameForContentType(toolkit, path);
        }
        return false;
    }

    public static boolean isValidSourcePackageName(IModelElement parent, IPath path) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(parent);
        if (toolkit != null) {
            if (EnvironmentPathUtils.isFull(path)) {
                path = EnvironmentPathUtils.getLocalPath(path);
            }
            return toolkit.validateSourcePackage(path, EnvironmentManager.getEnvironment(parent));
        }
        return false;
    }

    public static boolean isValidSourceModuleName(IModelElement parent, String name) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(parent);
        if (toolkit != null) {
            return DLTKContentTypeManager.isValidFileNameForContentType(toolkit, name);
        }
        return false;
    }

    public static boolean isValidSourceModule(IResource res) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.findToolkit(res);
        if (toolkit != null) {
            return DLTKContentTypeManager.isValidResourceForContentType(toolkit, res);
        }
        return false;
    }

    public static File toLocalFile(URI uri, IProgressMonitor monitor) throws CoreException {
        IFileStore fileStore = EFS.getStore((URI)uri);
        File localFile = fileStore.toLocalFile(0, monitor);
        if (localFile == null) {
            localFile = fileStore.toLocalFile(4096, monitor);
        }
        return localFile;
    }

    private static void quickSort(char[][] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        char[] mid = list[(left + right) / 2];
        while (true) {
            if (Util.compare(list[left], mid) < 0) {
                ++left;
                continue;
            }
            while (Util.compare(mid, list[right]) < 0) {
                --right;
            }
            if (left <= right) {
                char[] tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    private static void quickSort(Comparable[] sortedCollection, int left, int right) {
        int original_left = left;
        int original_right = right;
        Comparable mid = sortedCollection[(left + right) / 2];
        while (true) {
            if (sortedCollection[left].compareTo(mid) < 0) {
                ++left;
                continue;
            }
            while (mid.compareTo(sortedCollection[right]) < 0) {
                --right;
            }
            if (left <= right) {
                Comparable tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(sortedCollection, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(sortedCollection, left, original_right);
        }
    }

    private static void quickSort(int[] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        int mid = list[(left + right) / 2];
        while (true) {
            if (list[left] < mid) {
                ++left;
                continue;
            }
            while (mid < list[right]) {
                --right;
            }
            if (left <= right) {
                int tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    private static void quickSort(Object[] sortedCollection, int left, int right, Comparer comparer) {
        int original_left = left;
        int original_right = right;
        Object mid = sortedCollection[(left + right) / 2];
        while (true) {
            if (comparer.compare(sortedCollection[left], mid) < 0) {
                ++left;
                continue;
            }
            while (comparer.compare(mid, sortedCollection[right]) < 0) {
                --right;
            }
            if (left <= right) {
                Object tmp = sortedCollection[left];
                sortedCollection[left] = sortedCollection[right];
                sortedCollection[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(sortedCollection, original_left, right, comparer);
        }
        if (left < original_right) {
            Util.quickSort(sortedCollection, left, original_right, comparer);
        }
    }

    public static void sort(char[][] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void sort(Comparable[] objects) {
        if (objects.length > 1) {
            Util.quickSort(objects, 0, objects.length - 1);
        }
    }

    public static void sort(int[] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void sort(Object[] objects, Comparer comparer) {
        if (objects.length > 1) {
            Util.quickSort(objects, 0, objects.length - 1, comparer);
        }
    }

    public static void sort(String[] strings) {
        if (strings.length > 1) {
            Util.quickSort(strings, 0, strings.length - 1);
        }
    }

    public static Comparable[] sortCopy(Comparable[] objects) {
        int len = objects.length;
        Comparable[] copy = new Comparable[len];
        System.arraycopy(objects, 0, copy, 0, len);
        Util.sort(copy);
        return copy;
    }

    public static IModelElement[] sortCopy(IModelElement[] elements) {
        int len = elements.length;
        Object[] copy = new IModelElement[len];
        System.arraycopy(elements, 0, copy, 0, len);
        Util.sort(copy, new Comparer(){

            public int compare(Object a, Object b) {
                return ((ModelElement)a).toStringWithAncestors().compareTo(((ModelElement)b).toStringWithAncestors());
            }
        });
        return copy;
    }

    public static Object[] sortCopy(Object[] objects, Comparer comparer) {
        int len = objects.length;
        Object[] copy = new Object[len];
        System.arraycopy(objects, 0, copy, 0, len);
        Util.sort(copy, comparer);
        return copy;
    }

    public static String[] sortCopy(String[] objects) {
        int len = objects.length;
        String[] copy = new String[len];
        System.arraycopy(objects, 0, copy, 0, len);
        Util.sort(copy);
        return copy;
    }

    public static int compare(byte[] a, byte[] b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        int len = Math.min(a.length, b.length);
        int i = 0;
        while (i < len) {
            int diff = a[i] - b[i];
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
        if (a.length > len) {
            return 1;
        }
        if (b.length > len) {
            return -1;
        }
        return 0;
    }

    public static int compare(char[] str1, char[] str2) {
        int len1 = str1.length;
        int len2 = str2.length;
        int n = Math.min(len1, len2);
        int i = 0;
        while (n-- != 0) {
            char c2;
            char c1 = str1[i];
            if (c1 == (c2 = str2[i++])) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static boolean isValidFolderNameForPackage(String folderName) {
        return true;
    }

    public static boolean isValidFolderNameForPackage(IContainer container, String folderName) {
        if (container.getType() == 4 && ".settings".equals(folderName)) {
            return false;
        }
        return Util.isValidFolderNameForPackage(folderName);
    }

    public static final String[] splitOn(char divider, String string, int start, int end) {
        int length;
        int n = length = string == null ? 0 : string.length();
        if (length == 0 || start > end) {
            return CharOperation.NO_STRINGS;
        }
        int wordCount = 1;
        int i = start;
        while (i < end) {
            if (string.charAt(i) == divider) {
                ++wordCount;
            }
            ++i;
        }
        String[] split = new String[wordCount];
        int last = start;
        int currentWord = 0;
        int i2 = start;
        while (i2 < end) {
            if (string.charAt(i2) == divider) {
                split[currentWord++] = string.substring(last, i2);
                last = i2 + 1;
            }
            ++i2;
        }
        split[currentWord] = string.substring(last, end);
        return split;
    }

    public static final String concatWith(String[] array, char separator) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = array.length;
        while (i < length) {
            buffer.append(array[i]);
            if (i < length - 1) {
                buffer.append(separator);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static final String concatWith(String[] array, String name, char separator) {
        if (array == null || array.length == 0) {
            return name;
        }
        if (name == null || name.length() == 0) {
            return Util.concatWith(array, separator);
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = array.length;
        while (i < length) {
            buffer.append(array[i]);
            buffer.append(separator);
            ++i;
        }
        buffer.append(name);
        return buffer.toString();
    }

    public static final String[] arrayConcat(String[] first, String second) {
        if (second == null) {
            return first;
        }
        if (first == null) {
            return new String[]{second};
        }
        int length = first.length;
        if (first.length == 0) {
            return new String[]{second};
        }
        String[] result = new String[length + 1];
        System.arraycopy(first, 0, result, 0, length);
        result[length] = second;
        return result;
    }

    public static boolean isReadOnly(IResource resource) {
        if (resource != null) {
            ResourceAttributes resourceAttributes = resource.getResourceAttributes();
            if (resourceAttributes == null) {
                return false;
            }
            return resourceAttributes.isReadOnly();
        }
        return true;
    }

    public static void setReadOnly(IResource resource, boolean readOnly) {
        ResourceAttributes resourceAttributes = resource.getResourceAttributes();
        if (resourceAttributes == null) {
            return;
        }
        resourceAttributes.setReadOnly(readOnly);
        try {
            resource.setResourceAttributes(resourceAttributes);
        }
        catch (CoreException coreException) {}
    }

    public static boolean equalsIgnoreExtension(String elementName, String cuName) {
        if (DLTKCore.DEBUG) {
            System.out.println("//TODO: Add more complex check here.");
        }
        return elementName.startsWith(cuName);
    }

    public static boolean startsWithIgnoreCase(String[] compoundName, String[] prefix) {
        int prefixLength = prefix.length;
        int nameLength = compoundName.length;
        if (prefixLength > nameLength) {
            return false;
        }
        int i = 0;
        while (i < prefixLength - 1) {
            if (!compoundName[i].equalsIgnoreCase(prefix[i])) {
                return false;
            }
            ++i;
        }
        return compoundName[prefixLength - 1].toLowerCase().startsWith(prefix[prefixLength - 1].toLowerCase());
    }

    public static final char[] readUTF(DataInput in) throws IOException {
        int utflen = in.readUnsignedShort();
        char[] str = new char[utflen];
        int count = 0;
        int strlen = 0;
        while (count < utflen) {
            int c = in.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = in.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = in.readUnsignedByte();
                    int char3 = in.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        if (strlen < utflen) {
            char[] cArray = str;
            str = new char[strlen];
            System.arraycopy(cArray, 0, str, 0, strlen);
        }
        return str;
    }

    public static int writeUTF(OutputStream out, char[] str) throws IOException {
        char c;
        int strlen = str.length;
        int utflen = 0;
        int i = 0;
        while (i < strlen) {
            c = str[i];
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        out.write(utflen >>> 8 & 0xFF);
        out.write(utflen >>> 0 & 0xFF);
        if (strlen == utflen) {
            i = 0;
            while (i < strlen) {
                out.write(str[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < strlen) {
                c = str[i];
                if (c >= '\u0001' && c <= '\u007f') {
                    out.write(c);
                } else if (c > '\u07ff') {
                    out.write(0xE0 | c >> 12 & 0xF);
                    out.write(0x80 | c >> 6 & 0x3F);
                    out.write(0x80 | c >> 0 & 0x3F);
                } else {
                    out.write(0xC0 | c >> 6 & 0x1F);
                    out.write(0x80 | c >> 0 & 0x3F);
                }
                ++i;
            }
        }
        return utflen + 2;
    }

    public static int scanIdentifier(char[] string, int start) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        int p = start;
        do {
            char c;
            if ((c = string[p]) != '<' && c != '>' && c != ':' && c != ';' && c != '.' && c != '/') continue;
            return p - 1;
        } while (++p != string.length);
        return p - 1;
    }

    public static boolean isExcluded(IPath path, IProjectFragment root, boolean isFolderPath) {
        char[][] inclusion = null;
        char[][] exclusion = null;
        if (root instanceof ProjectFragment) {
            ProjectFragment projectFragment = (ProjectFragment)root;
            inclusion = projectFragment.fullInclusionPatternChars();
            exclusion = projectFragment.fullExclusionPatternChars();
        }
        return Util.isExcluded(path, inclusion, exclusion, isFolderPath);
    }

    public static interface Comparer {
        public int compare(Object var1, Object var2);
    }

    public static interface Displayable {
        public String displayString(Object var1);
    }
}

