/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class PriorityDLTKExtensionManager {
    public static final String PRIORITY_ATTR = "priority";
    private Map extensions;
    private String extensionPoint = null;
    private String identifier = null;
    private Map prefferedLevels = new HashMap();
    private Map prefferedExtensionCache = new HashMap();

    protected void setIdentifierValue(String identifier) {
        this.identifier = identifier;
        if (this.extensions != null) {
            this.extensions = null;
        }
    }

    public PriorityDLTKExtensionManager(String extensionPoint, String identifier) {
        this.extensionPoint = extensionPoint;
        this.identifier = identifier;
        Assert.isNotNull((Object)this.extensionPoint);
        Assert.isNotNull((Object)this.identifier);
    }

    protected void initialize() {
        if (this.extensions != null) {
            return;
        }
        this.extensions = new HashMap(5);
        IConfigurationElement[] cfg = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPoint);
        int i = 0;
        while (i < cfg.length) {
            IConfigurationElement element = cfg[i];
            if (this.isValidConfigurationElement(element)) {
                int lev;
                String nature = element.getAttribute(this.identifier);
                ElementInfo oldInfo = (ElementInfo)this.extensions.get(nature);
                if (oldInfo != null && (lev = this.getLevel(element)) <= oldInfo.level) {
                    ElementInfo e = oldInfo;
                    ElementInfo nInfo = this.createNewInfo(element, null);
                    while (e != null) {
                        if (e.oldInfo == null) {
                            e.oldInfo = nInfo;
                        } else {
                            if (nInfo.level < e.oldInfo.level) {
                                e = e.oldInfo;
                                continue;
                            }
                            nInfo.oldInfo = e.oldInfo;
                            e.oldInfo = nInfo;
                        }
                        break;
                    }
                } else {
                    ElementInfo info = this.createNewInfo(element, oldInfo);
                    this.extensions.put(nature, info);
                }
            }
            ++i;
        }
    }

    protected boolean isValidConfigurationElement(IConfigurationElement element) {
        return true;
    }

    private ElementInfo createNewInfo(IConfigurationElement cfg, ElementInfo oldInfo) {
        ElementInfo info = this.createInfo(cfg);
        info.level = this.getLevel(info.config);
        info.oldInfo = oldInfo;
        return info;
    }

    protected ElementInfo internalGetElementInfo(String id) {
        this.initialize();
        if (this.prefferedExtensionCache.containsKey(id)) {
            return (ElementInfo)this.prefferedExtensionCache.get(id);
        }
        ElementInfo info = (ElementInfo)this.extensions.get(id);
        Object level = this.prefferedLevels.get(id);
        if (level != null) {
            int prefferedLevel = (Integer)level;
            while (info != null) {
                if (info.level == prefferedLevel) {
                    return info;
                }
                info = info.oldInfo;
            }
        }
        if (info != null) {
            this.prefferedExtensionCache.put(id, info);
        }
        return info;
    }

    protected ElementInfo getElementInfo(String id) {
        return this.internalGetElementInfo(id);
    }

    protected int getLevel(IConfigurationElement config) {
        String priority = config.getAttribute(PRIORITY_ATTR);
        if (priority == null) {
            return 0;
        }
        try {
            int parseInt = Integer.parseInt(priority);
            return parseInt;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public ElementInfo[] getElementInfos() {
        this.initialize();
        ElementInfo[] values = new ElementInfo[this.extensions.size()];
        Iterator j = this.extensions.keySet().iterator();
        int i = 0;
        while (i < values.length) {
            String key = (String)j.next();
            values[i] = this.getElementInfo(key);
            ++i;
        }
        return values;
    }

    protected ElementInfo createInfo(IConfigurationElement config) {
        return new ElementInfo(config);
    }

    public String findScriptNature(IProject project) {
        block5: {
            if (project.isAccessible()) break block5;
            return null;
        }
        try {
            String[] natureIds = project.getDescription().getNatureIds();
            int i = 0;
            while (i < natureIds.length) {
                String natureId = natureIds[i];
                if (this.getElementInfo(natureId) != null) {
                    return natureId;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    public void setPreffetedLevel(String id, int level) {
        if (level != -1) {
            this.prefferedExtensionCache.clear();
            this.prefferedLevels.put(id, new Integer(level));
        } else {
            this.prefferedExtensionCache.clear();
            this.prefferedLevels.put(id, null);
        }
    }

    public static class ElementInfo {
        int level;
        public IConfigurationElement config;
        public Object object;
        public ElementInfo oldInfo;

        protected ElementInfo(IConfigurationElement config) {
            this.config = config;
        }

        public IConfigurationElement getConfig() {
            return this.config;
        }
    }
}

