/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.documentation;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;

public class ScriptDocumentationAccess {
    private static final String DOCUMENTATION_PROVIDERS_EXTENSION_POINT = "org.eclipse.dltk.ui.scriptDocumentationProviders";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_NATURE = "nature";
    private static IScriptDocumentationProvider[] documentationProviders = null;
    private static Map providerNatures = new HashMap();
    private static final int BUFF_SIZE = 2048;

    private ScriptDocumentationAccess() {
    }

    private static IScriptDocumentationProvider[] createProviders(IConfigurationElement[] elements) {
        ArrayList<IScriptDocumentationProvider> result = new ArrayList<IScriptDocumentationProvider>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            try {
                IScriptDocumentationProvider pr = (IScriptDocumentationProvider)element.createExecutableExtension(ATTR_CLASS);
                String nature = element.getAttribute(ATTR_NATURE);
                result.add(pr);
                providerNatures.put(pr, nature);
            }
            catch (CoreException e) {
                DLTKUIPlugin.log(e);
            }
            ++i;
        }
        return result.toArray(new IScriptDocumentationProvider[result.size()]);
    }

    private static IScriptDocumentationProvider[] getContributedProviders() {
        if (documentationProviders == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(DOCUMENTATION_PROVIDERS_EXTENSION_POINT);
            providerNatures.clear();
            documentationProviders = ScriptDocumentationAccess.createProviders(elements);
        }
        return documentationProviders;
    }

    public static Reader getHTMLContentReader(String nature, IMember member, boolean allowInherited, boolean allowExternal) throws ModelException {
        IScriptDocumentationProvider[] providers = ScriptDocumentationAccess.getContributedProviders();
        StringBuffer buffer = new StringBuffer();
        char[] buff = null;
        boolean prev = false;
        int i = 0;
        while (i < providers.length) {
            Reader reader;
            IScriptDocumentationProvider p = providers[i];
            String pNature = (String)providerNatures.get(p);
            if (pNature != null && pNature.equals(nature) && (reader = p.getInfo(member, allowInherited, allowExternal)) != null) {
                int size;
                block9: {
                    size = 0;
                    if (buff == null) {
                        buff = new char[2048];
                    }
                    int len = 0;
                    try {
                        while ((len = reader.read(buff, 0, 2048)) != -1) {
                            buffer.append(buff, 0, len);
                        }
                    }
                    catch (IOException e) {
                        if (!DLTKCore.DEBUG) break block9;
                        e.printStackTrace();
                    }
                }
                if (prev && size > 0) {
                    buffer.append("<hr/>");
                }
                if (size > 0) {
                    prev = true;
                }
            }
            ++i;
        }
        if (buffer.length() > 0) {
            char[] content = new char[buffer.length()];
            buffer.getChars(0, buffer.length(), content, 0);
            return new CharArrayReader(content);
        }
        return null;
    }

    public static Reader getHTMLContentReader(String nature, String content) throws ModelException {
        IScriptDocumentationProvider[] providers = ScriptDocumentationAccess.getContributedProviders();
        StringBuffer buffer = new StringBuffer();
        char[] buff = null;
        boolean prev = false;
        int i = 0;
        while (i < providers.length) {
            IScriptDocumentationProvider p = providers[i];
            String pNature = (String)providerNatures.get(p);
            if (pNature != null && pNature.equals(nature)) {
                int size;
                block10: {
                    Reader reader = p.getInfo(content);
                    size = 0;
                    if (reader != null) {
                        if (buff == null) {
                            buff = new char[2048];
                        }
                        int len = 0;
                        try {
                            while ((len = reader.read(buff, 0, 2048)) != -1) {
                                size += len;
                                buffer.append(buff, 0, len);
                            }
                        }
                        catch (IOException e) {
                            if (!DLTKCore.DEBUG) break block10;
                            e.printStackTrace();
                        }
                    }
                }
                if (prev && size > 0) {
                    buffer.append("<hr/>");
                }
                if (size > 0) {
                    prev = true;
                }
            }
            ++i;
        }
        if (buffer.length() > 0) {
            char[] cnt = new char[buffer.length()];
            buffer.getChars(0, buffer.length(), cnt, 0);
            return new CharArrayReader(cnt);
        }
        return null;
    }
}

