/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.packages;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessOutputCollector {
    public static List<String> execute(Process process) {
        try {
            process.getOutputStream().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InputStream errorStream = process.getErrorStream();
        new ErrorStreamReaderThread(errorStream).start();
        InputStream inputStream = process.getInputStream();
        OutputReaderThread output = new OutputReaderThread(inputStream, "DLTK-TCL-HELPER-9E7A168E-5EEF-4a46-A86D-0C82E90686E4-END-OF-STREAM");
        output.start();
        try {
            output.join(50000L);
        }
        catch (InterruptedException interruptedException) {}
        try {
            errorStream.close();
        }
        catch (IOException iOException) {}
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        process.destroy();
        return output.output;
    }

    private static class ErrorStreamReaderThread
    extends Thread {
        final InputStream stream;

        public ErrorStreamReaderThread(InputStream stream) {
            this.stream = stream;
        }

        public void run() {
            byte[] buffer = new byte[256];
            try {
                while (this.stream.read(buffer) != -1) {
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static class OutputReaderThread
    extends Thread {
        final InputStream stream;
        final String endOfStreamMarker;
        final List<String> output = new ArrayList<String>();

        public OutputReaderThread(InputStream stream, String endOfStreamMarker) {
            this.stream = stream;
            this.endOfStreamMarker = endOfStreamMarker;
        }

        public void run() {
            BufferedReader input = new BufferedReader(new InputStreamReader(this.stream));
            try {
                String line;
                while ((line = input.readLine()) != null && line.indexOf(this.endOfStreamMarker) < 0) {
                    this.output.add(line);
                }
            }
            catch (IOException iOException) {}
        }
    }
}

