/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.tcl.activestatedebugger.InstrumentationUtils;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationConfig;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationContentProvider;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationLabelProvider;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationMode;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.LibraryContainerElement;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.LibraryPattern;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.ModelElementPattern;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.Pattern;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PreferenceMessages;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PreferencesFactory;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.ProjectSelectionDialogInput;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SelectionDialogComparator;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SelectionDialogInput;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.TreeSelectionControl;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.WorkspaceSelectionDialogInput;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class InstrumentationPatternList {
    private final IProject parentProject;
    private Composite fMode;
    private Button fDefaultMode;
    private Button fSourceModulesMode;
    private Button fSelectionMode;
    private CheckboxTreeViewer fViewer;
    private TreeSelectionControl fSelectionControl;
    private int updateCount = 0;
    private InstrumentationConfig configValue;

    public InstrumentationPatternList(IProject parentProject) {
        this.parentProject = parentProject;
    }

    public Control createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.fMode = new Composite(comp, 0);
        this.fMode.setLayoutData((Object)new GridData(768));
        this.fMode.setLayout((Layout)new FillLayout());
        this.fSourceModulesMode = SWTFactory.createRadioButtonNoLayoutData((Composite)this.fMode, (String)PreferenceMessages.InstrumentationPatternList_ModeSources);
        this.fSelectionMode = SWTFactory.createRadioButtonNoLayoutData((Composite)this.fMode, (String)PreferenceMessages.InstrumentationPatternList_ModeSelection);
        this.fDefaultMode = SWTFactory.createRadioButtonNoLayoutData((Composite)this.fMode, (String)PreferenceMessages.InstrumentationPatternList_ModeDefault);
        SelectionAdapter modeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!InstrumentationPatternList.this.isUpdate()) {
                    boolean newEnabled = InstrumentationPatternList.this.fSelectionMode.getSelection();
                    if (InstrumentationPatternList.this.fViewer.getControl().isEnabled() != newEnabled) {
                        InstrumentationPatternList.this.fViewer.getControl().setEnabled(newEnabled);
                    }
                }
            }
        };
        this.fDefaultMode.addSelectionListener((SelectionListener)modeListener);
        this.fSourceModulesMode.addSelectionListener((SelectionListener)modeListener);
        this.fSelectionMode.addSelectionListener((SelectionListener)modeListener);
        this.fViewer = new CheckboxTreeViewer(comp, 2048);
        GridData viewerLayoutData = new GridData(1808);
        viewerLayoutData.heightHint = new PixelConverter((Control)parent).convertHeightInCharsToPixels(15);
        this.fViewer.getTree().setLayoutData((Object)viewerLayoutData);
        InstrumentationContentProvider cp = new InstrumentationContentProvider();
        this.fViewer.setContentProvider((IContentProvider)cp);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new InstrumentationLabelProvider(cp));
        this.fViewer.setComparator((ViewerComparator)new SelectionDialogComparator());
        this.fSelectionControl = new TreeSelectionControl(this.fViewer){

            protected String getLabelOf(Object element) {
                if (element instanceof IModelElement) {
                    return ((IModelElement)element).getPath().toString();
                }
                return super.getLabelOf(element);
            }
        };
        this.fSelectionControl.install();
        return comp;
    }

    private boolean isUpdate() {
        return this.updateCount != 0;
    }

    private void beginUpdate() {
        ++this.updateCount;
    }

    private void endUpdate() {
        --this.updateCount;
    }

    public void setValue(InstrumentationConfig config) {
        this.beginUpdate();
        try {
            this.configValue = config;
            InstrumentationMode mode = InstrumentationUtils.getMode(config);
            SelectionDialogInput treeInput = this.parentProject == null ? new WorkspaceSelectionDialogInput() : new ProjectSelectionDialogInput(this.parentProject);
            this.fSelectionControl.setInput(treeInput);
            if (InstrumentationMode.SOURCES.equals((Object)mode)) {
                this.fSourceModulesMode.setSelection(true);
                this.fViewer.getControl().setEnabled(false);
                this.fSelectionControl.resetState();
            } else if (InstrumentationMode.SELECTION.equals((Object)mode)) {
                this.fSelectionMode.setSelection(true);
                this.fViewer.getControl().setEnabled(true);
                ArrayList<IModelElement> includes = new ArrayList<IModelElement>();
                ArrayList excludes = new ArrayList();
                for (Pattern pattern : config.getModelElements()) {
                    ArrayList<IModelElement> output;
                    ArrayList<Object> arrayList = output = pattern.isInclude() ? includes : excludes;
                    Object element = pattern instanceof ModelElementPattern ? DLTKCore.create((String)((ModelElementPattern)pattern).getHandleIdentifier()) : (pattern instanceof LibraryPattern ? new LibraryContainerElement(treeInput) : null);
                    if (element == null) continue;
                    output.add((IModelElement)element);
                }
                this.fSelectionControl.setInitialState(includes, excludes);
            } else {
                this.fDefaultMode.setSelection(true);
                this.fViewer.getControl().setEnabled(false);
                this.fSelectionControl.resetState();
            }
            this.fSelectionControl.aboutToOpen();
        }
        finally {
            this.endUpdate();
        }
    }

    public InstrumentationConfig getValue() {
        if (this.configValue == null) {
            this.configValue = PreferencesFactory.eINSTANCE.createInstrumentationConfig();
        }
        if (this.fSelectionMode.getSelection()) {
            Pattern pattern;
            final Object LIBRARY_CONTAINER = new Object();
            this.configValue.setMode(InstrumentationMode.SELECTION);
            final HashSet includes = new HashSet();
            final HashSet excludes = new HashSet();
            this.fSelectionControl.collectCheckedItems(new TreeSelectionControl.ICollector(){

                public void include(Object object) {
                    if (object instanceof IModelElement) {
                        includes.add(((IModelElement)object).getHandleIdentifier());
                    } else if (object instanceof LibraryContainerElement) {
                        includes.add(LIBRARY_CONTAINER);
                    }
                }

                public void exclude(Object object) {
                    if (object instanceof IModelElement) {
                        excludes.add(((IModelElement)object).getHandleIdentifier());
                    } else if (object instanceof LibraryContainerElement) {
                        excludes.add(LIBRARY_CONTAINER);
                    }
                }
            });
            ArrayList<Pattern> toRemove = new ArrayList<Pattern>();
            for (Pattern pattern2 : this.configValue.getModelElements()) {
                HashSet input;
                HashSet hashSet = input = pattern2.isInclude() ? includes : excludes;
                Object oldItem = pattern2 instanceof ModelElementPattern ? ((ModelElementPattern)pattern2).getHandleIdentifier() : (pattern2 instanceof LibraryPattern ? LIBRARY_CONTAINER : null);
                if (input.remove(oldItem)) continue;
                toRemove.add(pattern2);
            }
            for (Pattern pattern2 : toRemove) {
                this.configValue.getModelElements().remove((Object)pattern2);
            }
            for (Object include : includes) {
                if (include instanceof String) {
                    pattern = PreferencesFactory.eINSTANCE.createModelElementPattern();
                    pattern.setInclude(true);
                    pattern.setHandleIdentifier((String)include);
                    this.configValue.getModelElements().add((Object)pattern);
                    continue;
                }
                if (include != LIBRARY_CONTAINER) continue;
                pattern = PreferencesFactory.eINSTANCE.createLibraryPattern();
                pattern.setInclude(true);
                this.configValue.getModelElements().add((Object)pattern);
            }
            for (Object exclude : excludes) {
                if (exclude instanceof String) {
                    pattern = PreferencesFactory.eINSTANCE.createModelElementPattern();
                    pattern.setInclude(false);
                    pattern.setHandleIdentifier((String)exclude);
                    this.configValue.getModelElements().add((Object)pattern);
                    continue;
                }
                if (exclude != LIBRARY_CONTAINER) continue;
                pattern = PreferencesFactory.eINSTANCE.createLibraryPattern();
                pattern.setInclude(false);
                this.configValue.getModelElements().add((Object)pattern);
            }
        } else if (this.fSourceModulesMode.getSelection()) {
            this.configValue.setMode(InstrumentationMode.SOURCES);
            this.configValue.getModelElements().clear();
        } else {
            this.configValue.setMode(InstrumentationMode.DEFAULT);
            this.configValue.getModelElements().clear();
        }
        return this.configValue;
    }
}

