/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.core.search.TypeNameMatchRequestor;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ruby.ast.RubyAssignment;
import org.eclipse.dltk.ruby.ast.RubyBlock;
import org.eclipse.dltk.ruby.ast.RubyDAssgnExpression;
import org.eclipse.dltk.ruby.ast.RubyForStatement2;
import org.eclipse.dltk.ruby.ast.RubyIfStatement;
import org.eclipse.dltk.ruby.ast.RubyMethodArgument;
import org.eclipse.dltk.ruby.ast.RubyUnlessStatement;
import org.eclipse.dltk.ruby.ast.RubyUntilStatement;
import org.eclipse.dltk.ruby.ast.RubyWhileStatement;
import org.eclipse.dltk.ruby.core.RubyPlugin;
import org.eclipse.dltk.ruby.internal.parser.mixin.IRubyMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinBuildVisitor;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinClass;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.internal.parsers.jruby.ASTUtils;
import org.eclipse.dltk.ruby.typeinference.LocalVariableInfo;
import org.eclipse.dltk.ruby.typeinference.OffsetTargetedASTVisitor;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.IInstanceContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.dltk.ti.types.RecursionTypeCall;

public class RubyTypeInferencingUtils {
    public static IType[] getAllTypes(ISourceModule module, String prefix) {
        final ArrayList types = new ArrayList();
        TypeNameMatchRequestor requestor = new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch match) {
                IType type = match.getType();
                if (type.getParent() instanceof ISourceModule) {
                    types.add(type);
                }
            }
        };
        ScriptModelUtil.searchTypeDeclarations((IScriptProject)module.getScriptProject(), (String)(String.valueOf(prefix) + "*"), (TypeNameMatchRequestor)requestor);
        return types.toArray(new IType[types.size()]);
    }

    public static ASTNode[] getAllStaticScopes(ModuleDeclaration rootNode, int requestedOffset) {
        final ArrayList<ModuleDeclaration> scopes = new ArrayList<ModuleDeclaration>();
        OffsetTargetedASTVisitor visitor = new OffsetTargetedASTVisitor(requestedOffset){

            public boolean visitInteresting(MethodDeclaration s) {
                scopes.add(s);
                return true;
            }

            public boolean visitInteresting(ModuleDeclaration s) {
                scopes.add(s);
                return true;
            }

            public boolean visitInteresting(TypeDeclaration s) {
                scopes.add(s);
                return true;
            }

            protected boolean visitInteresting(RubyBlock b) {
                scopes.add(b);
                return true;
            }

            protected boolean visitGeneralInteresting(ASTNode s) {
                if (ASTUtils.isNodeScoping(s)) {
                    scopes.add(s);
                    return true;
                }
                return super.visitGeneralInteresting(s);
            }
        };
        try {
            rootNode.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            RubyPlugin.log(e);
        }
        if (scopes.size() == 0) {
            scopes.add(rootNode);
        }
        return scopes.toArray(new ASTNode[scopes.size()]);
    }

    public static IMixinElement[] getModelStaticScopes(MixinModel model, ModuleDeclaration rootNode, int requestedOffset) {
        String[] modelStaticScopesKeys = RubyTypeInferencingUtils.getModelStaticScopesKeys(model, rootNode, requestedOffset);
        IMixinElement[] result = new IMixinElement[modelStaticScopesKeys.length];
        int i = 1;
        while (i < modelStaticScopesKeys.length) {
            result[i] = model.get(modelStaticScopesKeys[i]);
            ++i;
        }
        return result;
    }

    public static String[] getModelStaticScopesKeys(MixinModel model, ModuleDeclaration rootNode, int requestedOffset) {
        ASTNode[] allStaticScopes = RubyTypeInferencingUtils.getAllStaticScopes(rootNode, requestedOffset);
        return RubyMixinBuildVisitor.restoreScopesByNodes(allStaticScopes);
    }

    public static IEvaluatedType determineSelfClass(RubyMixinModel mixinModel, IContext context, int keyOffset) {
        if (context instanceof IInstanceContext) {
            IInstanceContext instanceContext = (IInstanceContext)context;
            return instanceContext.getInstanceType();
        }
        ISourceModuleContext basicContext = (ISourceModuleContext)context;
        return RubyTypeInferencingUtils.determineSelfClass(mixinModel, basicContext.getSourceModule(), basicContext.getRootNode(), keyOffset);
    }

    public static RubyClassType determineSelfClass(RubyMixinModel rubyModel, ISourceModule sourceModule, ModuleDeclaration rootNode, int keyOffset) {
        String[] keys = RubyTypeInferencingUtils.getModelStaticScopesKeys(rubyModel.getRawModel(), rootNode, keyOffset);
        if (keys != null && keys.length > 0) {
            String inner = keys[keys.length - 1];
            IRubyMixinElement rubyElement = rubyModel.createRubyElement(inner);
            if (rubyElement == null && inner.indexOf(123) != -1) {
                rubyElement = rubyModel.createRubyElement(inner.substring(0, inner.lastIndexOf(123)));
            }
            if (rubyElement instanceof RubyMixinMethod) {
                RubyMixinMethod method = (RubyMixinMethod)rubyElement;
                RubyMixinClass selfType = method.getSelfType();
                if (selfType != null) {
                    return new RubyClassType(selfType.getKey());
                }
            } else if (rubyElement instanceof RubyMixinClass) {
                RubyMixinClass rubyMixinClass = (RubyMixinClass)rubyElement;
                return new RubyClassType(rubyMixinClass.getKey());
            }
        }
        return null;
    }

    public static RubyAssignment[] findLocalVariableAssignments(final ASTNode scope, final ASTNode nextScope, final String varName) {
        final ArrayList assignments = new ArrayList();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(MethodDeclaration s) throws Exception {
                return s == scope;
            }

            public boolean visit(TypeDeclaration s) throws Exception {
                return s == scope;
            }

            public boolean visit(ASTNode node) throws Exception {
                VariableReference varRef;
                RubyAssignment assignment;
                ASTNode lhs;
                if (node instanceof RubyAssignment && (lhs = (assignment = (RubyAssignment)node).getLeft()) instanceof VariableReference && varName.equals((varRef = (VariableReference)lhs).getName())) {
                    assignments.add(assignment);
                }
                return node != nextScope;
            }
        };
        try {
            scope.traverse(visitor);
        }
        catch (Exception e) {
            RubyPlugin.log(e);
        }
        return assignments.toArray(new RubyAssignment[assignments.size()]);
    }

    public static boolean isRootLocalScope(ASTNode node) {
        return node instanceof ModuleDeclaration || node instanceof TypeDeclaration || node instanceof MethodDeclaration;
    }

    public static IEvaluatedType combineTypes(Collection evaluaedTypes) {
        HashSet types = new HashSet(evaluaedTypes);
        types.remove(null);
        if (types.size() > 1 && types.contains(RecursionTypeCall.INSTANCE)) {
            types.remove(RecursionTypeCall.INSTANCE);
        }
        return RubyTypeInferencingUtils.combineUniqueTypes(types.toArray(new IEvaluatedType[types.size()]));
    }

    private static IEvaluatedType combineUniqueTypes(IEvaluatedType[] types) {
        if (types.length == 0) {
            return UnknownType.INSTANCE;
        }
        if (types.length == 1) {
            return types[0];
        }
        return new AmbiguousType(types);
    }

    public static IEvaluatedType combineTypes(IEvaluatedType[] evaluaedTypes) {
        return RubyTypeInferencingUtils.combineTypes(Arrays.asList(evaluaedTypes));
    }

    public static ModuleDeclaration parseSource(ISourceModule module) {
        return SourceParserUtil.getModuleDeclaration((ISourceModule)module);
    }

    public static IEvaluatedType getAmbiguousMetaType(IEvaluatedType receiver) {
        if (receiver instanceof AmbiguousType) {
            HashSet<IEvaluatedType> possibleReturns = new HashSet<IEvaluatedType>();
            AmbiguousType ambiguousType = (AmbiguousType)receiver;
            IEvaluatedType[] possibleTypes = ambiguousType.getPossibleTypes();
            int i = 0;
            while (i < possibleTypes.length) {
                IEvaluatedType type = possibleTypes[i];
                IEvaluatedType possibleReturn = RubyTypeInferencingUtils.getAmbiguousMetaType(type);
                possibleReturns.add(possibleReturn);
                ++i;
            }
            return RubyTypeInferencingUtils.combineTypes(possibleReturns);
        }
        return null;
    }

    public static String searchConstantElement(MixinModel mixinModel, ModuleDeclaration module, int calculationOffset, String constantName) {
        String[] modelStaticScopes = RubyTypeInferencingUtils.getModelStaticScopesKeys(mixinModel, module, calculationOffset);
        String resultKey = null;
        int i = modelStaticScopes.length - 1;
        while (i >= 0) {
            String possibleKey = String.valueOf(modelStaticScopes[i]) + IMixinRequestor.MIXIN_NAME_SEPARATOR + constantName;
            if (mixinModel.keyExists(possibleKey)) {
                resultKey = possibleKey;
                break;
            }
            --i;
        }
        if (resultKey == null && mixinModel.keyExists(constantName)) {
            resultKey = constantName;
        }
        return resultKey;
    }

    private static RubyAssignment findAssignments(String variableName, ASTNode scopeNode, int tillOffset, List conditionals) {
        LocalVariablesSearchVisitor visitor = new LocalVariablesSearchVisitor(variableName, scopeNode, tillOffset);
        try {
            scopeNode.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (conditionals != null) {
            conditionals.addAll(visitor.getConditionals());
        }
        return visitor.getUnconditionalAssignment();
    }

    public static LocalVariableInfo inspectLocalVariable(ModuleDeclaration module, int offset, String name) {
        LocalVariableInfo info = new LocalVariableInfo();
        ASTNode[] scopes = RubyTypeInferencingUtils.getAllStaticScopes(module, offset);
        int i = -1;
        i = scopes.length - 1;
        while (i >= 0) {
            VariableReference ref;
            RubyAssignment rubyAssignment;
            RubyForStatement2 forStatement;
            ASTNode var;
            Iterator iterator;
            ASTNode scope = scopes[i];
            if (scope instanceof TypeDeclaration) {
                info.setDeclaringScope(scope);
                ArrayList conditionals = new ArrayList();
                RubyAssignment last = RubyTypeInferencingUtils.findAssignments(name, scope, offset, conditionals);
                info.setLastAssignment(last);
                info.setDeclaringScope(scope);
                info.setConditionalAssignments(conditionals);
                break;
            }
            if (scope instanceof MethodDeclaration) {
                MethodDeclaration method = (MethodDeclaration)scope;
                boolean isArgument = false;
                List arguments = method.getArguments();
                iterator = arguments.iterator();
                while (iterator.hasNext()) {
                    RubyMethodArgument arg = (RubyMethodArgument)((Object)iterator.next());
                    String argName = arg.getName();
                    if (!argName.equals(name)) continue;
                    isArgument = true;
                    break;
                }
                if (isArgument && info.getKind() == 0) {
                    info.setKind(2);
                }
                ArrayList conditionals = new ArrayList();
                RubyAssignment last = RubyTypeInferencingUtils.findAssignments(name, scope, offset, conditionals);
                info.setLastAssignment(last);
                info.setDeclaringScope(scope);
                info.setConditionalAssignments(conditionals);
                break;
            }
            if (scope instanceof RubyBlock) {
                boolean isArgument = false;
                RubyBlock block = (RubyBlock)scope;
                Set vars = block.getVars();
                iterator = vars.iterator();
                while (iterator.hasNext()) {
                    RubyDAssgnExpression v;
                    ASTNode vnode = (ASTNode)iterator.next();
                    if (!(vnode instanceof RubyDAssgnExpression) || !(v = (RubyDAssgnExpression)vnode).getName().equals(name)) continue;
                    isArgument = true;
                    break;
                }
                if (isArgument && info.getKind() == 0) {
                    info.setKind(1);
                }
            } else if (scope instanceof RubyForStatement2 && (var = (forStatement = (RubyForStatement2)scope).getTarget()) instanceof RubyAssignment && (rubyAssignment = (RubyAssignment)var).getLeft() instanceof VariableReference && (ref = (VariableReference)rubyAssignment.getLeft()).getName().equals(name) && info.getKind() == 0) {
                info.setKind(3);
            }
            --i;
        }
        if (i < 0) {
            ArrayList conditionals = new ArrayList();
            RubyAssignment last = RubyTypeInferencingUtils.findAssignments(name, (ASTNode)module, offset, conditionals);
            info.setLastAssignment(last);
            info.setDeclaringScope((ASTNode)module);
            info.setConditionalAssignments(conditionals);
        }
        return info;
    }

    private static class LocalVariablesSearchVisitor
    extends ASTVisitor {
        private List assignements;
        private Stack level = new Stack();
        private int maxLevel;
        private final String name;
        private final int offset;
        private final ASTNode root;

        public LocalVariablesSearchVisitor(String name, ASTNode root, int offset) {
            this.name = name;
            this.root = root;
            this.offset = offset;
            this.maxLevel = 0;
            this.assignements = new ArrayList();
            this.level.clear();
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            if (node == this.root) {
                return true;
            }
            if (node instanceof MethodDeclaration || node instanceof TypeDeclaration) {
                return false;
            }
            if (node instanceof RubyAssignment) {
                VariableReference varRef;
                if (node.sourceEnd() > this.offset) {
                    return false;
                }
                RubyAssignment rubyAssignment = (RubyAssignment)node;
                ASTNode lhs = rubyAssignment.getLeft();
                if (lhs instanceof VariableReference && this.name.equals((varRef = (VariableReference)lhs).getName())) {
                    this.assignements.add(new VariableAssignment(rubyAssignment, this.level.size()));
                }
            } else if (node instanceof RubyIfStatement || node instanceof RubyForStatement2 || node instanceof RubyWhileStatement || node instanceof RubyBlock || node instanceof RubyUntilStatement || node instanceof RubyUnlessStatement) {
                if (node.sourceStart() >= this.offset) {
                    return false;
                }
                this.level.push(node);
                if (node.sourceEnd() >= this.offset && this.level.size() > this.maxLevel) {
                    this.maxLevel = this.level.size();
                }
            }
            return true;
        }

        public void endvisitGeneral(ASTNode node) throws Exception {
            if (this.level.size() > 0 && this.level.peek().equals(node)) {
                this.level.pop();
            }
        }

        public RubyAssignment getUnconditionalAssignment() {
            VariableAssignment[] array = this.assignements.toArray(new VariableAssignment[this.assignements.size()]);
            int i = array.length - 1;
            while (i >= 0) {
                VariableAssignment a = array[i];
                if (a.level <= this.maxLevel) {
                    return a.assignment;
                }
                --i;
            }
            return null;
        }

        public List getConditionals() {
            RubyAssignment unconditionalAssignment = this.getUnconditionalAssignment();
            ArrayList<RubyAssignment> result = new ArrayList<RubyAssignment>();
            Iterator iter = this.assignements.iterator();
            while (iter.hasNext()) {
                VariableAssignment assign = (VariableAssignment)iter.next();
                if (unconditionalAssignment != null && assign.assignment.sourceStart() <= unconditionalAssignment.sourceStart()) continue;
                result.add(assign.assignment);
            }
            return result;
        }

        private class VariableAssignment {
            public RubyAssignment assignment;
            public int level;

            public VariableAssignment(RubyAssignment assignenment, int level) {
                this.assignment = assignenment;
                this.level = level;
            }
        }
    }
}

