/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISourceable;

public class ObjectInitializer
extends Expression {
    private List initializers;
    private int LC = -1;
    private int RC = -1;
    private List commas;
    private boolean multiline;

    public ObjectInitializer(ASTNode parent) {
        super(parent);
    }

    public List getInitializers() {
        return this.initializers;
    }

    public void setInitializers(List initializers) {
        this.initializers = initializers;
    }

    public int getLC() {
        return this.LC;
    }

    public void setLC(int LC) {
        this.LC = LC;
    }

    public int getRC() {
        return this.RC;
    }

    public void setRC(int RC) {
        this.RC = RC;
    }

    public List getCommas() {
        return this.commas;
    }

    public void setCommas(List commas) {
        this.commas = commas;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.LC > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.RC > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.initializers.size() == 0 || this.commas.size() == this.initializers.size() - 1 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        int i = 0;
        while (i < this.initializers.size()) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(((ISourceable)this.initializers.get(i)).toSourceString(indentationString));
            ++i;
        }
        buffer.append("}");
        return buffer.toString();
    }

    public boolean isBlock() {
        return false;
    }
}

