/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.SearchPattern;

public class DLTKSearchPattern
extends SearchPattern {
    boolean isCaseSensitive;
    boolean isCamelCase;
    int matchMode;
    int matchCompatibility;
    public static final int MATCH_MODE_MASK = 7;
    public static final int MATCH_COMPATIBILITY_MASK = 112;
    private char[][][] typeArguments;
    private int flags = 0;
    static final int HAS_TYPE_ARGUMENTS = 1;
    static PackageNameSet internedPackageNames = new PackageNameSet(1001);

    protected DLTKSearchPattern(int patternKind, int matchRule, IDLTKLanguageToolkit toolkit) {
        super(matchRule, toolkit);
        this.kind = patternKind;
        int rule = this.getMatchRule();
        this.isCaseSensitive = (rule & 8) != 0;
        this.isCamelCase = (rule & 0x80) != 0;
        this.matchCompatibility = rule & 0x70;
        this.matchMode = rule & 7;
    }

    public SearchPattern getBlankPattern() {
        return null;
    }

    int getMatchMode() {
        return this.matchMode;
    }

    boolean isCamelCase() {
        return this.isCamelCase;
    }

    boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    boolean isErasureMatch() {
        return (this.matchCompatibility & 0x10) != 0;
    }

    boolean isEquivalentMatch() {
        return (this.matchCompatibility & 0x20) != 0;
    }

    char[][] extractMethodArguments(IMethod method) {
        int length;
        if (method == null) {
            return null;
        }
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: Search: Add correct code here if needed.");
        }
        String[] argumentsSignatures = null;
        try {
            argumentsSignatures = method.getParameters();
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        if (argumentsSignatures != null && (length = argumentsSignatures.length) > 0) {
            char[][] methodArguments = new char[length][];
            int i = 0;
            while (i < length) {
                methodArguments[i] = argumentsSignatures[i].toCharArray();
                CharOperation.replace(methodArguments[i], new char[]{'$', '/'}, '.');
                ++i;
            }
            return methodArguments;
        }
        return null;
    }

    public final boolean hasSignatures() {
        return false;
    }

    public final boolean hasTypeArguments() {
        return (this.flags & 1) != 0;
    }

    public final boolean hasTypeParameters() {
        return !this.hasSignatures() && this.hasTypeArguments();
    }

    protected StringBuffer print(StringBuffer output) {
        output.append(", ");
        if (this.isCamelCase) {
            output.append("camel case + ");
        }
        switch (this.getMatchMode()) {
            case 0: {
                output.append("exact match,");
                break;
            }
            case 1: {
                output.append("prefix match,");
                break;
            }
            case 2: {
                output.append("pattern match,");
                break;
            }
            case 4: {
                output.append("regexp match, ");
            }
        }
        if (this.isCaseSensitive()) {
            output.append(" case sensitive");
        } else {
            output.append(" case insensitive");
        }
        if ((this.matchCompatibility & 0x10) != 0) {
            output.append(", erasure only");
        }
        if ((this.matchCompatibility & 0x20) != 0) {
            output.append(", equivalent oronly");
        }
        return output;
    }

    public final String toString() {
        return this.print(new StringBuffer(30)).toString();
    }

    static class PackageNameSet {
        public char[][] names;
        public int elementSize = 0;
        public int threshold;

        PackageNameSet(int size) {
            this.threshold = size;
            int extraRoom = (int)((float)size * 1.5f);
            if (this.threshold == extraRoom) {
                ++extraRoom;
            }
            this.names = new char[extraRoom][];
        }

        char[] add(char[] name) {
            char[] current;
            int length = this.names.length;
            int index = CharOperation.hashCode(name) % length;
            while ((current = this.names[index]) != null) {
                if (CharOperation.equals(current, name)) {
                    return current;
                }
                if (++index != length) continue;
                index = 0;
            }
            this.names[index] = name;
            if (++this.elementSize > this.threshold) {
                this.rehash();
            }
            return name;
        }

        void rehash() {
            PackageNameSet newSet = new PackageNameSet(this.elementSize * 2);
            int i = this.names.length;
            while (--i >= 0) {
                char[] current = this.names[i];
                if (current == null) continue;
                newSet.add(current);
            }
            this.names = newSet.names;
            this.elementSize = newSet.elementSize;
            this.threshold = newSet.threshold;
        }
    }
}

