/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console.ui.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.dltk.console.IScriptExecResult;
import org.eclipse.dltk.console.ScriptConsoleHistory;
import org.eclipse.dltk.console.ScriptConsolePrompt;
import org.eclipse.dltk.console.ui.AnsiColorHelper;
import org.eclipse.dltk.console.ui.IScriptConsoleViewer;
import org.eclipse.dltk.console.ui.ScriptConsole;
import org.eclipse.dltk.console.ui.ScriptConsolePartitioner;
import org.eclipse.dltk.console.ui.internal.ICommandHandler;
import org.eclipse.dltk.console.ui.internal.IScriptConsoleContentHandler;
import org.eclipse.dltk.console.ui.internal.Messages;
import org.eclipse.dltk.console.ui.internal.ScriptConsoleViewer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.HyperlinkManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;

public class ScriptConsoleViewer
extends TextConsoleViewer
implements IScriptConsoleViewer {
    private ScriptConsoleHistory history;
    private ScriptConsole console;

    public int getCaretPosition() {
        return this.getTextWidget().getCaretOffset();
    }

    public void enableProcessing() {
        this.console.getDocumentListener().bEnabled = true;
    }

    public void disableProcessing() {
        this.console.getDocumentListener().bEnabled = false;
    }

    public void setCaretPosition(final int offset) {
        if (this.getTextWidget() != null) {
            this.getTextWidget().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (ScriptConsoleViewer.this.getTextWidget() != null) {
                        ScriptConsoleViewer.this.getTextWidget().setCaretOffset(offset);
                    }
                }
            });
        }
    }

    protected boolean isCaretOnLastLine() {
        try {
            IDocument doc = this.getDocument();
            int line = doc.getLineOfOffset(this.getCaretPosition());
            return line == doc.getNumberOfLines() - 1;
        }
        catch (BadLocationException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
    }

    protected StyledText createTextWidget(Composite parent, int styles) {
        return new ScriptConsoleStyledText(parent, styles);
    }

    public ScriptConsoleViewer(Composite parent, final ScriptConsole console, final IScriptConsoleContentHandler contentHandler) {
        super(parent, (TextConsole)console);
        this.console = console;
        this.history = console.getHistory();
        console.getDocumentListener().addViewer(this);
        final StyledText styledText = this.getTextWidget();
        styledText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ScriptConsoleViewer.this.setCaretPosition(ScriptConsoleViewer.this.getDocument().getLength());
                styledText.removeFocusListener((FocusListener)this);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        styledText.setKeyBinding(0x58 | SWT.MOD1, 17039369);
        styledText.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                try {
                    if (event.character != '\u0000') {
                        if ((event.stateMask & SWT.MOD1) == 0) {
                            ConsoleDocumentListener listener = console.getDocumentListener();
                            int selStart = ScriptConsoleViewer.this.getSelectedRange().x;
                            int selEnd = ScriptConsoleViewer.this.getSelectedRange().x + ScriptConsoleViewer.this.getSelectedRange().y;
                            int clOffset = listener.getCommandLineOffset();
                            int clLength = listener.getCommandLineLength();
                            if (selStart < clOffset) {
                                int selLength;
                                if (selEnd < clOffset) {
                                    selStart = clOffset + clLength;
                                    selLength = 0;
                                } else {
                                    selStart = clOffset;
                                    selLength = selEnd - selStart;
                                }
                                ScriptConsoleViewer.this.setSelectedRange(selStart, selLength);
                            }
                            if (ScriptConsoleViewer.this.getCaretPosition() < console.getDocumentListener().getCommandLineOffset()) {
                                event.doit = false;
                                return;
                            }
                        }
                        if (event.character == '\r') {
                            ScriptConsoleViewer.this.getTextWidget().setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
                            return;
                        }
                        if (event.keyCode == 32 && (event.stateMask & 0x40000) > 0) {
                            event.doit = false;
                            return;
                        }
                        if (event.keyCode == 9) {
                            event.doit = false;
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        styledText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 9 || e.keyCode == 32 && e.stateMask == 262144) {
                    contentHandler.contentAssistRequired();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        if (console.getDocumentListener().viewerList.size() == 1) {
            this.clear();
        }
    }

    public String getCommandLine() {
        try {
            return this.console.getDocumentListener().getCommandLine();
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public int getCommandLineOffset() {
        try {
            return this.console.getDocumentListener().getCommandLineOffset();
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public void clear() {
        this.console.getDocumentListener().clear();
    }

    public void insertText(String text) {
        this.getTextWidget().append(text);
    }

    public boolean canDoOperation(int operation) {
        boolean canDoOperation = super.canDoOperation(operation);
        if (canDoOperation) {
            switch (operation) {
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 11: 
                case 12: {
                    canDoOperation = this.isCaretOnLastLine();
                }
            }
        }
        return canDoOperation;
    }

    public void activatePlugins() {
        this.fHyperlinkManager = new HyperlinkManager(HyperlinkManager.LONGEST_REGION_FIRST);
        this.fHyperlinkManager.install((ITextViewer)this, this.fHyperlinkPresenter, this.fHyperlinkDetectors, this.fHyperlinkStateMask);
        super.activatePlugins();
    }

    public void dispose() {
        this.console.getDocumentListener().removeViewer(this);
    }

    static /* synthetic */ void access$0(ScriptConsoleViewer scriptConsoleViewer) {
        scriptConsoleViewer.revealEndOfDocument();
    }

    public static class ConsoleDocumentListener
    implements IDocumentListener {
        private boolean bEnabled = true;
        private ICommandHandler handler;
        private boolean handleSynchronously;
        private ScriptConsolePrompt prompt;
        private ScriptConsoleHistory history;
        private int inviteStart = 0;
        private int inviteEnd = 0;
        private IDocument doc;
        private AnsiColorHelper ansiHelper = new AnsiColorHelper();
        private List viewerList = new ArrayList();

        private void addViewer(ScriptConsoleViewer viewer) {
            this.viewerList.add(viewer);
        }

        private void removeViewer(ScriptConsoleViewer viewer) {
            this.viewerList.remove(viewer);
        }

        protected void connectListener() {
            this.doc.addDocumentListener((IDocumentListener)this);
        }

        protected void disconnectListener() {
            this.doc.removeDocumentListener((IDocumentListener)this);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void clear() {
            try {
                try {
                    this.disconnectListener();
                    this.doc.set("");
                    Iterator iter = this.viewerList.iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            this.appendInvitation();
                            iter = this.viewerList.iterator();
                            break;
                        }
                        ScriptConsoleViewer viewer = (ScriptConsoleViewer)iter.next();
                        IDocumentPartitioner partitioner = viewer.getDocument().getDocumentPartitioner();
                        if (!(partitioner instanceof ScriptConsolePartitioner)) continue;
                        ScriptConsolePartitioner scriptConsolePartitioner = (ScriptConsolePartitioner)partitioner;
                        scriptConsolePartitioner.clearRanges();
                    }
                    while (iter.hasNext()) {
                        ((ScriptConsoleViewer)iter.next()).setCaretPosition(this.doc.getLength());
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.connectListener();
                throw throwable;
            }
            {
                Object var5_8 = null;
                this.connectListener();
                return;
            }
        }

        public ConsoleDocumentListener(ICommandHandler handler, ScriptConsolePrompt prompt, ScriptConsoleHistory history) {
            this.prompt = prompt;
            this.handler = handler;
            this.history = history;
            this.doc = null;
        }

        public void setDocument(IDocument doc) {
            if (this.doc != null) {
                this.disconnectListener();
            }
            this.doc = doc;
            if (this.doc != null) {
                this.connectListener();
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        protected void handleCommandLine(String command) throws BadLocationException, IOException {
            if (this.handleSynchronously) {
                IScriptExecResult result = this.handler.handleCommand(command);
                if (((ScriptConsole)this.handler).getState() != 2) {
                    this.processResult(result);
                }
                return;
            }
            Thread handlerThread = new Thread(this, Messages.ScriptConsoleViewer_scriptConsoleCommandHandler, command){
                final /* synthetic */ ConsoleDocumentListener this$1;
                private final /* synthetic */ String val$command;
                {
                    this.this$1 = consoleDocumentListener;
                    this.val$command = string;
                }

                public void run() {
                    try {
                        IScriptExecResult result = ConsoleDocumentListener.access$0(this.this$1).handleCommand(this.val$command);
                        if (((ScriptConsole)ConsoleDocumentListener.access$0(this.this$1)).getState() != 2) {
                            ((ScriptConsole)ConsoleDocumentListener.access$0(this.this$1)).getPage().getSite().getShell().getDisplay().asyncExec(new Runnable(this, result){
                                final /* synthetic */ 1 this$2;
                                private final /* synthetic */ IScriptExecResult val$result;
                                {
                                    this.this$2 = var1_1;
                                    this.val$result = iScriptExecResult;
                                }

                                public void run() {
                                    1.access$0(this.this$2).processResult(this.val$result);
                                }
                            });
                        }
                    }
                    catch (IOException ixcn) {
                        ixcn.printStackTrace();
                    }
                }

                static /* synthetic */ ConsoleDocumentListener access$0(1 var0) {
                    return var0.this$1;
                }
            };
            handlerThread.setDaemon(true);
            handlerThread.setPriority(1);
            handlerThread.start();
        }

        protected void appendText(int offset, String text) throws BadLocationException {
            this.doc.replace(offset, 0, text);
        }

        protected void processText(int originalOffset, String content, boolean isInput, boolean isError, boolean shouldReveal, boolean shouldRedraw) throws BadLocationException {
            if (originalOffset == -1) {
                originalOffset = this.doc.getLength();
            }
            this.ansiHelper.processText(originalOffset, content, isInput, isError, new AnsiColorHelper.IAnsiColorHandler(this, shouldReveal, shouldRedraw){
                final /* synthetic */ ConsoleDocumentListener this$1;
                private final /* synthetic */ boolean val$shouldReveal;
                private final /* synthetic */ boolean val$shouldRedraw;
                {
                    this.this$1 = consoleDocumentListener;
                    this.val$shouldReveal = bl;
                    this.val$shouldRedraw = bl2;
                }

                public void handleText(int start, String content, boolean isInput, boolean isError) throws BadLocationException {
                    this.this$1.appendText(start, content);
                    this.this$1.addToPartitioner(start, content, isInput, isError);
                }

                public void processingComplete(int start, int length) {
                    Iterator<E> iter = ConsoleDocumentListener.access$1(this.this$1).iterator();
                    while (iter.hasNext()) {
                        ScriptConsoleViewer viewer = (ScriptConsoleViewer)iter.next();
                        if (this.val$shouldReveal) {
                            viewer.setCaretPosition(ConsoleDocumentListener.access$2(this.this$1).getLength());
                            ScriptConsoleViewer.access$0(viewer);
                        }
                        if (!this.val$shouldRedraw || viewer.getTextWidget() == null) continue;
                        viewer.getTextWidget().redrawRange(start, length, true);
                    }
                }
            });
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void processResult(IScriptExecResult result) {
            this.disconnectListener();
            try {
                try {
                    String output;
                    if (result != null && (output = result.getOutput()) != null && output.length() != 0) {
                        this.ansiHelper.reset();
                        this.processText(-1, output, false, result.isError(), false, true);
                    }
                    this.appendInvitation();
                }
                catch (BadLocationException bxcn) {
                    bxcn.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.connectListener();
                throw throwable;
            }
            {
                Object var3_6 = null;
                this.connectListener();
                return;
            }
        }

        private void addToPartitioner(ScriptConsoleViewer viewer, StyleRange style) {
            IDocumentPartitioner partitioner = viewer.getDocument().getDocumentPartitioner();
            if (partitioner instanceof ScriptConsolePartitioner) {
                ScriptConsolePartitioner scriptConsolePartitioner = (ScriptConsolePartitioner)partitioner;
                scriptConsolePartitioner.addRange(style);
            }
        }

        protected void addToPartitioner(int start, String content, boolean isInput, boolean isError) {
            ScriptConsoleViewer viewer;
            Iterator iter;
            StringTokenizer tokenizer = new StringTokenizer(content, " \t\n\r\f@#=|,()[]{}<>'\"", true);
            int tokenStart = start;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                iter = this.viewerList.iterator();
                while (iter.hasNext()) {
                    viewer = (ScriptConsoleViewer)iter.next();
                    if (isInput) {
                        this.addToPartitioner(viewer, new StyleRange(tokenStart, token.length(), AnsiColorHelper.COLOR_BLACK, null, 1));
                        continue;
                    }
                    this.addToPartitioner(viewer, this.ansiHelper.resolveStyleRange(tokenStart, token.length(), isError));
                }
                tokenStart += token.length();
            }
            iter = this.viewerList.iterator();
            while (iter.hasNext()) {
                viewer = (ScriptConsoleViewer)iter.next();
                viewer.getTextWidget().redraw();
            }
        }

        protected void processAddition(int offset, String text) {
            block8: {
                if (!this.bEnabled) {
                    return;
                }
                try {
                    int index;
                    String delim = TextUtilities.getDefaultLineDelimiter((IDocument)this.doc);
                    text = this.doc.get(offset, this.doc.getLength() - offset);
                    this.doc.replace(offset, text.length(), "");
                    text = text.replaceAll("\r\n|\n|\r", delim);
                    int start = 0;
                    while ((index = text.indexOf(delim, start)) != -1) {
                        if (index > start) {
                            this.processText(this.getCommandLineOffset(), text.substring(start, index), true, false, false, true);
                        }
                        String commandLine = this.getCommandLine();
                        this.processText(-1, delim, true, false, false, true);
                        this.inviteStart = this.inviteEnd = this.doc.getLength();
                        this.history.add(commandLine);
                        start = index + delim.length();
                        this.handleCommandLine(commandLine);
                    }
                    if (start < text.length()) {
                        this.processText(-1, text.substring(start, text.length()), true, false, false, true);
                    }
                }
                catch (BadLocationException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    if (!DLTKCore.DEBUG) break block8;
                    e.printStackTrace();
                }
            }
        }

        public void documentChanged(DocumentEvent event) {
            this.ansiHelper.disableWhile(new Runnable(this, event){
                final /* synthetic */ ConsoleDocumentListener this$1;
                private final /* synthetic */ DocumentEvent val$event;
                {
                    this.this$1 = consoleDocumentListener;
                    this.val$event = documentEvent;
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    this.this$1.disconnectListener();
                    try {
                        this.this$1.processAddition(this.val$event.getOffset(), this.val$event.getText());
                    }
                    catch (Throwable throwable) {
                        Object var1_2 = null;
                        this.this$1.connectListener();
                        throw throwable;
                    }
                    {
                        Object var1_3 = null;
                        this.this$1.connectListener();
                        return;
                    }
                }
            });
        }

        public void appendInvitation() throws BadLocationException {
            this.inviteStart = this.doc.getLength();
            this.processText(this.inviteStart, this.prompt.toString(), true, false, true, true);
            this.inviteEnd = this.doc.getLength();
        }

        public void appendDelimeter() throws BadLocationException {
            this.processText(-1, TextUtilities.getDefaultLineDelimiter((IDocument)this.doc), false, false, false, true);
        }

        protected int getLastLineLength() throws BadLocationException {
            int lastLine = this.doc.getNumberOfLines() - 1;
            return this.doc.getLineLength(lastLine);
        }

        public int getCommandLineOffset() throws BadLocationException {
            return this.inviteEnd;
        }

        public int getCommandLineLength() throws BadLocationException {
            return this.doc.getLength() - this.inviteEnd;
        }

        public String getCommandLine() throws BadLocationException {
            return this.doc.get(this.getCommandLineOffset(), this.getCommandLineLength());
        }

        public void setCommandLine(String command) {
            this.ansiHelper.disableWhile(new Runnable(this, command){
                final /* synthetic */ ConsoleDocumentListener this$1;
                private final /* synthetic */ String val$command;
                {
                    this.this$1 = consoleDocumentListener;
                    this.val$command = string;
                }

                public void run() {
                    try {
                        ConsoleDocumentListener.access$2(this.this$1).replace(this.this$1.getCommandLineOffset(), this.this$1.getCommandLineLength(), this.val$command);
                    }
                    catch (BadLocationException bxcn) {
                        bxcn.printStackTrace();
                    }
                }
            });
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void executeCommand(String command) {
            this.disconnectListener();
            try {
                try {
                    int docLen = this.doc.getLength();
                    if (docLen > this.inviteEnd) {
                        this.doc.replace(this.inviteEnd, docLen - this.inviteEnd, "");
                    }
                    this.processText(this.getCommandLineOffset(), String.valueOf(command) + TextUtilities.getDefaultLineDelimiter((IDocument)this.doc), true, false, true, true);
                    this.inviteStart = this.inviteEnd = this.doc.getLength();
                    this.handleCommandLine(command);
                }
                catch (BadLocationException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                this.connectListener();
                throw throwable;
            }
            {
                Object var3_7 = null;
                this.connectListener();
                return;
            }
        }

        public void write(String text, boolean isError) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(this, text, isError){
                    final /* synthetic */ ConsoleDocumentListener this$1;
                    private final /* synthetic */ String val$text;
                    private final /* synthetic */ boolean val$isError;
                    {
                        this.this$1 = consoleDocumentListener;
                        this.val$text = string;
                        this.val$isError = bl;
                    }

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        this.this$1.disconnectListener();
                        try {
                            try {
                                this.this$1.processText(ConsoleDocumentListener.access$3(this.this$1), this.val$text, false, this.val$isError, true, true);
                                ConsoleDocumentListener consoleDocumentListener = this.this$1;
                                ConsoleDocumentListener.access$4(consoleDocumentListener, ConsoleDocumentListener.access$3(consoleDocumentListener) + this.val$text.length());
                                ConsoleDocumentListener consoleDocumentListener2 = this.this$1;
                                ConsoleDocumentListener.access$6(consoleDocumentListener2, ConsoleDocumentListener.access$5(consoleDocumentListener2) + this.val$text.length());
                            }
                            catch (BadLocationException bxcn) {
                                if (DLTKCore.DEBUG) {
                                    bxcn.printStackTrace();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var2_3 = null;
                            this.this$1.connectListener();
                            throw throwable;
                        }
                        {
                            Object var2_4 = null;
                            this.this$1.connectListener();
                            return;
                        }
                    }
                });
            }
        }

        static /* synthetic */ ICommandHandler access$0(ConsoleDocumentListener consoleDocumentListener) {
            return consoleDocumentListener.handler;
        }

        static /* synthetic */ IDocument access$2(ConsoleDocumentListener consoleDocumentListener) {
            return consoleDocumentListener.doc;
        }

        static /* synthetic */ int access$3(ConsoleDocumentListener consoleDocumentListener) {
            return consoleDocumentListener.inviteStart;
        }

        static /* synthetic */ void access$4(ConsoleDocumentListener consoleDocumentListener, int n) {
            consoleDocumentListener.inviteStart = n;
        }

        static /* synthetic */ int access$5(ConsoleDocumentListener consoleDocumentListener) {
            return consoleDocumentListener.inviteEnd;
        }

        static /* synthetic */ void access$6(ConsoleDocumentListener consoleDocumentListener, int n) {
            consoleDocumentListener.inviteEnd = n;
        }

        static /* synthetic */ void access$8(ConsoleDocumentListener consoleDocumentListener, boolean bl) {
            consoleDocumentListener.handleSynchronously = bl;
        }
    }

    private class ScriptConsoleStyledText
    extends StyledText {
        public ScriptConsoleStyledText(Composite parent, int style) {
            super(parent, style | 0x40);
        }

        public void invokeAction(int action) {
            if (ScriptConsoleViewer.this.isEditable() && ScriptConsoleViewer.this.isCaretOnLastLine()) {
                switch (action) {
                    case 0x1000001: {
                        this.updateSelectedLine();
                        if (ScriptConsoleViewer.this.history.prev()) {
                            ScriptConsoleViewer.this.console.getDocumentListener().setCommandLine(ScriptConsoleViewer.this.history.get());
                            this.setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
                        } else {
                            this.beep();
                        }
                        return;
                    }
                    case 0x1000002: {
                        this.updateSelectedLine();
                        if (ScriptConsoleViewer.this.history.next()) {
                            ScriptConsoleViewer.this.console.getDocumentListener().setCommandLine(ScriptConsoleViewer.this.history.get());
                            this.setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
                        } else {
                            this.beep();
                        }
                        return;
                    }
                    case 8: {
                        if (this.getCaretOffset() > ScriptConsoleViewer.this.getCommandLineOffset() || this.getSelectionCount() != 0) break;
                        return;
                    }
                    case 127: {
                        if (this.getCaretOffset() >= ScriptConsoleViewer.this.getCommandLineOffset()) break;
                        return;
                    }
                    case 262152: {
                        return;
                    }
                    case 16908295: {
                        if (!ScriptConsoleViewer.this.isCaretOnLastLine()) break;
                        int prevCaret = this.getCaretOffset();
                        Point prevSelection = this.getSelection();
                        int caret = ScriptConsoleViewer.this.getCommandLineOffset();
                        if (prevCaret == prevSelection.x) {
                            this.setSelection(prevSelection.y, caret);
                        } else if (prevCaret == prevSelection.y) {
                            this.setSelection(prevSelection.x, caret);
                        } else {
                            this.setCaretOffset(caret);
                        }
                        return;
                    }
                    case 0x1000007: {
                        if (!ScriptConsoleViewer.this.isCaretOnLastLine()) break;
                        this.setCaretOffset(ScriptConsoleViewer.this.getCommandLineOffset());
                        return;
                    }
                    case 0x1000003: 
                    case 16908291: {
                        if (!ScriptConsoleViewer.this.isCaretOnLastLine() || this.getCaretOffset() != ScriptConsoleViewer.this.getCommandLineOffset()) break;
                        return;
                    }
                }
                super.invokeAction(action);
                if (ScriptConsoleViewer.this.isCaretOnLastLine() && this.getCaretOffset() <= ScriptConsoleViewer.this.getCommandLineOffset()) {
                    this.setCaretOffset(ScriptConsoleViewer.this.getCommandLineOffset());
                }
            } else {
                super.invokeAction(action);
            }
        }

        private void updateSelectedLine() {
            block2: {
                try {
                    ScriptConsoleViewer.this.history.updateSelectedLine(ScriptConsoleViewer.this.console.getDocumentListener().getCommandLine());
                }
                catch (BadLocationException e) {
                    if (!DLTKCore.DEBUG) break block2;
                    e.printStackTrace();
                }
            }
        }

        private void beep() {
            this.getDisplay().beep();
        }

        public void paste() {
            if (ScriptConsoleViewer.this.isCaretOnLastLine()) {
                ScriptConsoleViewer.this.console.getDocumentListener().ansiHelper.disableWhile(new Runnable(this){
                    final /* synthetic */ ScriptConsoleStyledText this$1;
                    {
                        this.this$1 = scriptConsoleStyledText;
                    }

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        ConsoleDocumentListener.access$8(ScriptConsoleViewer.access$2(ScriptConsoleStyledText.access$1(this.this$1)).getDocumentListener(), true);
                        try {
                            ScriptConsoleStyledText.access$0(this.this$1);
                            Clipboard clipboard = new Clipboard(this.this$1.getDisplay());
                            TextTransfer plainTextTransfer = TextTransfer.getInstance();
                            String text = (String)clipboard.getContents((Transfer)plainTextTransfer, 1);
                            clipboard.dispose();
                            if (text != null && text.length() > 0) {
                                if (text.indexOf("\n") == -1) {
                                    int cp = ScriptConsoleStyledText.access$1(this.this$1).getCaretPosition();
                                    ScriptConsoleStyledText.access$1(this.this$1).insertText(text);
                                    this.this$1.setCaretOffset(cp + text.length());
                                } else {
                                    StringTokenizer tokenizer = new StringTokenizer(text, "\n\r");
                                    while (tokenizer.hasMoreTokens()) {
                                        String finText = tokenizer.nextToken();
                                        ScriptConsoleStyledText.access$1(this.this$1).insertText(String.valueOf(finText) + "\n");
                                    }
                                }
                            }
                            Object var6_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_8 = null;
                            ConsoleDocumentListener.access$8(ScriptConsoleViewer.access$2(ScriptConsoleStyledText.access$1(this.this$1)).getDocumentListener(), false);
                            throw throwable;
                        }
                        ConsoleDocumentListener.access$8(ScriptConsoleViewer.access$2(ScriptConsoleStyledText.access$1(this.this$1)).getDocumentListener(), false);
                    }
                });
            }
        }

        static /* synthetic */ void access$0(ScriptConsoleStyledText scriptConsoleStyledText) {
            scriptConsoleStyledText.checkWidget();
        }

        static /* synthetic */ ScriptConsoleViewer access$1(ScriptConsoleStyledText scriptConsoleStyledText) {
            return scriptConsoleStyledText.ScriptConsoleViewer.this;
        }
    }
}

