/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.util.ArrayList;
import org.eclipse.dltk.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.dltk.ui.preferences.FormatterMessages;
import org.eclipse.dltk.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class EditorConfigurationBlock
extends AbstractConfigurationBlock {
    public static final int FLAG_TAB_POLICY = 1;
    public static final int FLAG_EDITOR_SMART_NAVIGATION = 2;
    public static final int FLAG_TAB_ALWAYS_INDENT = 4;
    private final int flags;

    public EditorConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store) {
        this(mainPreferencePage, store, 3);
    }

    public EditorConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store, boolean disableSmart) {
        this(mainPreferencePage, store, 1 | (disableSmart ? 0 : 2));
    }

    public EditorConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store, boolean disableSmart, boolean tabAlwaysIndent) {
        this(mainPreferencePage, store, 1 | (disableSmart ? 0 : 2) | (tabAlwaysIndent ? 4 : 0));
    }

    public EditorConfigurationBlock(PreferencePage mainPreferencePage, OverlayPreferenceStore store, int flags) {
        super(store, mainPreferencePage);
        this.flags = flags;
        this.getPreferenceStore().addKeys(EditorConfigurationBlock.createOverlayStoreKeys(flags));
    }

    private static OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys(int flags) {
        ArrayList<OverlayPreferenceStore.OverlayKey> keys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        if ((flags & 2) != 0) {
            keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Navigation.SmartHomeEnd"));
            keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "subWordNavigation"));
            keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editorSmartIndent"));
        }
        if ((flags & 1) != 0) {
            keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "formatter.tabulation.char"));
            keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "formatter.tabulation.size"));
            keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "formatter.indentation.size"));
        }
        if ((flags & 4) != 0) {
            keys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "tab_always_indent"));
        }
        return keys.toArray(new OverlayPreferenceStore.OverlayKey[keys.size()]);
    }

    public Control createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        if ((this.flags & 2) != 0) {
            Composite composite = this.createSubsection(control, null, PreferencesMessages.EditorPreferencePage_title0);
            this.createSettingsGroup(composite);
        }
        this.createTabsGroup(control);
        return control;
    }

    private void createTabsGroup(Composite composite) {
        Composite generalGroup = this.createSubsection(composite, null, FormatterMessages.IndentationTabPage_preview_header);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        generalGroup.setLayout((Layout)layout);
        if ((this.flags & 1) != 0) {
            String[] tabPolicyValues = new String[]{"space", "tab", "mixed"};
            String[] tabPolicyLabels = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED};
            this.addComboBox(generalGroup, FormatterMessages.IndentationTabPage_general_group_option_tab_policy, "formatter.tabulation.char", tabPolicyLabels, tabPolicyValues);
            this.addLabelledTextField(generalGroup, FormatterMessages.IndentationTabPage_general_group_option_indent_size, "formatter.indentation.size", 2, 1, true);
            this.addLabelledTextField(generalGroup, FormatterMessages.IndentationTabPage_general_group_option_tab_size, "formatter.tabulation.size", 2, 1, true);
        }
        if ((this.flags & 4) != 0) {
            this.addCheckBox(generalGroup, PreferencesMessages.EditorPreferencePage_tabAlwaysIndent, "tab_always_indent", 2);
        }
    }

    private Control createSettingsGroup(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.addCheckBox(composite, PreferencesMessages.EditorPreferencePage_smartHomeEnd, "AbstractTextEditor.Navigation.SmartHomeEnd", 0);
        this.addCheckBox(composite, PreferencesMessages.EditorPreferencePage_subWordNavigation, "subWordNavigation", 0);
        this.addCheckBox(composite, PreferencesMessages.EditorPreferencePage_smartIndent, "editorSmartIndent", 0);
        return composite;
    }

    public void initialize() {
        super.initialize();
    }

    public void performDefaults() {
        super.performDefaults();
    }
}

