/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.mixin;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.dltk.core.search.index.EntryResult;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.index.MixinIndex;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;

public class MixinIndexTests
extends TestCase {
    private File file;
    private MixinIndex index;

    protected void setUp() throws Exception {
        super.setUp();
        this.file = File.createTempFile("mixin", ".index");
        this.index = this.createIndex(true);
    }

    private MixinIndex createIndex(boolean isNew) throws IOException {
        return new MixinIndex(this.file.getPath(), this.file.getPath(), !isNew);
    }

    protected void tearDown() throws Exception {
        this.index = null;
        this.file.delete();
        super.tearDown();
    }

    public void testQuery() throws IOException {
        this.index.addIndexEntry(IIndexConstants.MIXIN, "key1".toCharArray(), "A");
        this.index.addIndexEntry(IIndexConstants.MIXIN, "key1".toCharArray(), "B");
        EntryResult[] result = this.index.query((char[][])new char[][]{IIndexConstants.MIXIN}, "key1".toCharArray(), 0);
        MixinIndexTests.assertEquals((int)1, (int)result.length);
        Object[] docNames = result[0].getDocumentNames((Index)this.index);
        MixinIndexTests.assertEquals((int)2, (int)docNames.length);
        Arrays.sort(docNames);
        MixinIndexTests.assertEquals((String)"A", (String)docNames[0]);
        MixinIndexTests.assertEquals((String)"B", (String)docNames[1]);
    }

    public void testQueryDocumentNames() throws IOException {
        this.index.addIndexEntry(IIndexConstants.MIXIN, "key1".toCharArray(), "A");
        this.index.addIndexEntry(IIndexConstants.MIXIN, "key1".toCharArray(), "B");
        Object[] docNames = this.index.queryDocumentNames(null);
        MixinIndexTests.assertEquals((int)2, (int)docNames.length);
        Arrays.sort(docNames);
        MixinIndexTests.assertEquals((String)"A", (String)docNames[0]);
        MixinIndexTests.assertEquals((String)"B", (String)docNames[1]);
        docNames = this.index.queryDocumentNames("");
        MixinIndexTests.assertEquals((int)2, (int)docNames.length);
        docNames = this.index.queryDocumentNames("Z");
        MixinIndexTests.assertEquals((int)0, (int)docNames.length);
    }

    public void testRemove() throws IOException {
        this.index.addIndexEntry(IIndexConstants.MIXIN, "key1".toCharArray(), "A");
        this.index.addIndexEntry(IIndexConstants.MIXIN, "key1".toCharArray(), "B");
        this.index.remove("A");
        String[] docNames = this.index.queryDocumentNames(null);
        MixinIndexTests.assertEquals((int)1, (int)docNames.length);
        MixinIndexTests.assertEquals((String)"B", (String)docNames[0]);
        EntryResult[] result = this.index.query((char[][])new char[][]{IIndexConstants.MIXIN}, "key1".toCharArray(), 0);
        MixinIndexTests.assertEquals((int)1, (int)result.length);
        docNames = result[0].getDocumentNames((Index)this.index);
        MixinIndexTests.assertEquals((int)1, (int)docNames.length);
        MixinIndexTests.assertEquals((String)"B", (String)docNames[0]);
    }

    public void testDocumentsWithoutKeys() throws IOException {
        this.index.addDocumentName("A");
        MixinIndexTests.assertTrue((boolean)this.index.hasChanged());
        this.index.save();
        this.index = this.createIndex(false);
        String[] docNames = this.index.queryDocumentNames(null);
        MixinIndexTests.assertEquals((int)1, (int)docNames.length);
        MixinIndexTests.assertEquals((String)"A", (String)docNames[0]);
    }

    public void testDocumentsWithoutKeysHasChanged() throws IOException {
        this.index.addDocumentName("A");
        MixinIndexTests.assertTrue((boolean)this.index.hasChanged());
        this.index.save();
        MixinIndexTests.assertFalse((boolean)this.index.hasChanged());
        this.index.addDocumentName("A");
        MixinIndexTests.assertFalse((boolean)this.index.hasChanged());
        this.index.addDocumentName("B");
        MixinIndexTests.assertTrue((boolean)this.index.hasChanged());
    }
}

