# Commands covered:  eval
#
# This file contains a collection of tests for one or more of the Tcl
# built-in commands.  Sourcing this file into Tcl runs the tests and
# generates output for errors.  No output means no errors were found.
#
# Copyright (c) 1991-1993 The Regents of the University of California.
# Copyright (c) 1994 Sun Microsystems, Inc.
# Copyright (c) 1998-1999 by Scriptics Corporation.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# RCS: @(#) $Id: eval.tcl,v 1.1 2006/12/29 09:02:53 fourdman Exp $

if {[lsearch [namespace children] ::tcltest] == -1} {
    package require tcltest
    namespace import -force ::tcltest::*
}

test eval-1.1 {single argument} {
    eval {format 22}
} 22
test eval-1.2 {multiple arguments} {
    set a {$b}
    set b xyzzy
    eval format $a
} xyzzy
test eval-1.3 {single argument} {
    eval concat a b c d e f g
} {a b c d e f g}

test eval-2.1 {error: not enough arguments} {catch eval} 1
test eval-2.2 {error: not enough arguments} {
    catch eval msg
    set msg
} {wrong # args: should be "eval arg ?arg ...?"}
test eval-2.3 {error in eval'ed command} {
    catch {eval {error "test error"}}
} 1
test eval-2.4 {error in eval'ed command} {
    catch {eval {error "test error"}} msg
    set msg
} {test error}
test eval-2.5 {error in eval'ed command: setting errorInfo} {
    catch {eval {
	set a 1
	error "test error"
    }} msg
    set errorInfo
} "test error
    while executing
\"error \"test error\"\"
    (\"eval\" body line 3)
    invoked from within
\"eval {
	set a 1
	error \"test error\"
    }\""

# cleanup
::tcltest::cleanupTests
return












