/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.launching;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.launching.AbstractInterpreterInstallType;
import org.eclipse.dltk.internal.launching.InterpreterMessages;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.ScriptLaunchUtil;
import org.eclipse.dltk.tcl.internal.launching.GenericTclInstall;
import org.eclipse.dltk.tcl.launching.TclLaunchingPlugin;
import org.osgi.framework.Bundle;

public class GenericTclInstallType
extends AbstractInterpreterInstallType {
    private static final String CORRECT_INTERPRETER_PATTERN = "#DLTK INTERPRETER TEST:5";
    private static final String INSTALL_TYPE_NAME = "Generic Tcl";
    private static final String[] INTERPRETER_NAMES = new String[]{"tclsh", "tclsh84", "tclsh8.4", "tclsh85", "tclsh8.5", "wish", "wish84", "wish8.4", "wish85", "wish8.5", "vtk", "expect", "base-tcl-linux", "base-tk-linux", "base-tcl-thread", "base-tk-thread", "base-tcl8.5-thread", "base-tk8.5-thread"};

    public String getNatureId() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    public String getName() {
        return INSTALL_TYPE_NAME;
    }

    protected String getPluginId() {
        return "org.eclipse.dltk.tcl.launching";
    }

    protected String[] getPossibleInterpreterNames() {
        return INTERPRETER_NAMES;
    }

    protected IInterpreterInstall doCreateInterpreterInstall(String id) {
        return new GenericTclInstall((IInterpreterInstallType)this, id);
    }

    protected void filterEnvironment(Map environment) {
        environment.remove("TCLLIBPATH");
        environment.remove("DISPLAY");
    }

    public IStatus validateInstallLocation(IFileHandle installLocation) {
        if (!installLocation.exists() || !installLocation.isFile()) {
            return this.createStatus(4, InterpreterMessages.errNonExistentOrInvalidInstallLocation, null);
        }
        IEnvironment environment = installLocation.getEnvironment();
        IExecutionEnvironment executionEnvironment = (IExecutionEnvironment)environment.getAdapter(IExecutionEnvironment.class);
        String output = ScriptLaunchUtil.runEmbeddedScriptReadContent((IExecutionEnvironment)executionEnvironment, (String)"scripts/test.tcl", (Bundle)TclLaunchingPlugin.getDefault().getBundle(), (IFileHandle)installLocation, (IProgressMonitor)new NullProgressMonitor());
        String[] lines = output.split("\\n");
        boolean correct = false;
        int i = 0;
        while (i < lines.length) {
            if (CORRECT_INTERPRETER_PATTERN.equals(lines[i])) {
                correct = true;
            }
            ++i;
        }
        if (correct) {
            return this.createStatus(0, "", null);
        }
        return this.createStatus(4, InterpreterMessages.errNoInterpreterExecutablesFound, null);
    }

    protected AbstractInterpreterInstallType.ILookupRunnable createLookupRunnable(IFileHandle installLocation, List locations, EnvironmentVariable[] variables) {
        return new AbstractInterpreterInstallType.ILookupRunnable(){

            public void run(IProgressMonitor monitor) {
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    protected String[] parsePaths(String res) {
        paths = new ArrayList<String>();
        subs = null;
        index = 0;
        result = res;
        if (!result.startsWith("DLTK:")) ** GOTO lbl28
        result = result.substring("DLTK:".length());
        ** GOTO lbl28
        {
            ++index;
            do {
                if (index < result.length() && Character.isWhitespace(result.charAt(index))) continue block0;
                if (index == result.length()) break block0;
                if (result.charAt(index) == '{') {
                    start = index;
                    while (index < result.length() && result.charAt(index) != '}') {
                        ++index;
                    }
                    if (index == result.length()) break block0;
                    subs = result.substring(start + 1, index);
                } else {
                    start = index;
                    while (index < result.length() && result.charAt(index) != ' ') {
                        ++index;
                    }
                    subs = result.substring(start, index);
                }
                paths.add(subs);
                ++index;
lbl28:
                // 3 sources

            } while (index < result.length());
        }
        return paths.toArray(new String[paths.size()]);
    }

    protected ILog getLog() {
        return TclLaunchingPlugin.getDefault().getLog();
    }

    protected IPath createPathFile(IDeployment deployment) throws IOException {
        return null;
    }
}

