/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;

public class JavaScriptModuleDeclaration
extends ModuleDeclaration {
    HostCollection collection;
    Map functionMap;
    private Collection references;

    public JavaScriptModuleDeclaration(int sourceLength) {
        super(sourceLength, true);
    }

    public void doRebuild() {
        this.buildAST(this.getTypeList(), this.getFunctionList(), this.getVariablesList());
    }

    public void setFunctionMap(Map functionMap) {
        this.functionMap = functionMap;
    }

    public void buildAST(List types, List functions, List vars) {
        List statements = this.getStatements();
        if (statements != null) {
            Iterator i = statements.iterator();
            while (i.hasNext()) {
                ASTNode node = (ASTNode)i.next();
                if (node instanceof MethodDeclaration) {
                    functions.add(node);
                    continue;
                }
                if (node instanceof TypeDeclaration) {
                    types.add(node);
                    continue;
                }
                if (!(node instanceof FieldDeclaration)) continue;
                vars.add(node);
            }
        }
    }

    public HostCollection getCollection() {
        return this.collection;
    }

    public boolean isEmpty() {
        return false;
    }

    public void setCollection(HostCollection collection) {
        this.collection = collection;
    }

    public Map getFunctionMap() {
        return this.functionMap;
    }

    public void setReferences(Collection references) {
        this.references = references;
    }

    public Collection getReferences() {
        return this.references;
    }
}

