/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.utils;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.IDbgpSessionInfo;
import org.eclipse.dltk.dbgp.IDbgpStatus;
import org.eclipse.dltk.dbgp.breakpoints.IDbgpBreakpoint;
import org.eclipse.dltk.dbgp.exceptions.DbgpDebuggingEngineException;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.exceptions.DbgpProtocolException;
import org.eclipse.dltk.dbgp.internal.DbgpFeature;
import org.eclipse.dltk.dbgp.internal.DbgpProperty;
import org.eclipse.dltk.dbgp.internal.DbgpSessionInfo;
import org.eclipse.dltk.dbgp.internal.DbgpStackLevel;
import org.eclipse.dltk.dbgp.internal.DbgpStatus;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpCallBreakpoint;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpConditionalBreakpoint;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpExceptionBreakpoint;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpLineBreakpoint;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpReturnBreakpoint;
import org.eclipse.dltk.dbgp.internal.breakpoints.DbgpWatchBreakpoint;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlParser;
import org.eclipse.dltk.dbgp.internal.utils.Messages;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbgpXmlEntityParser
extends DbgpXmlParser {
    private static final IDbgpProperty[] NO_CHILDREN = new IDbgpProperty[0];
    private static final String ENCODING_NONE = "none";
    private static final String ENCODING_BASE64 = "base64";
    public static final String TAG_PROPERTY = "property";
    private static final String ATTR_LEVEL = "level";
    private static final String ATTR_CMDBEGIN = "cmdbegin";
    private static final String ATTR_CMDEND = "cmdend";
    private static final String ATTR_LINENO = "lineno";
    private static final String ATTR_FILENAME = "filename";
    private static final String ATTR_WHERE = "where";
    private static final String FILE_SCHEME_PREFIX = "file:///";
    private static final String ATTR_FEATURE_NAME = "feature_name";
    private static final String ATTR_SUPPORTED = "supported";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_FULLNAME = "fullname";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_CHILDREN = "children";
    private static final String ATTR_NUMCHILDREN = "numchildren";
    private static final String ATTR_CONSTANT = "constant";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_PAGE = "page";
    private static final String ATTR_PAGE_SIZE = "pagesize";
    private static final String ATTR_ADDRESS = "address";
    private static final String ATTR_REASON = "reason";
    private static final String ATTR_STATUS = "status";
    private static final String LINE_BREAKPOINT = "line";
    private static final String CALL_BREAKPOINT = "call";
    private static final String RETURN_BREAKPOINT = "return";
    private static final String EXCEPTION_BREAKPOINT = "exception";
    private static final String CONDITIONAL_BREAKPOINT = "conditional";
    private static final String WATCH_BREAKPOINT = "watch";
    private static final String ATTR_ID = "id";
    private static final String ATTR_STATE = "state";
    private static final String ATTR_HIT_COUNT = "hit_count";
    private static final String ATTR_HIT_VALUE = "hit_value";
    private static final String ATTR_HIT_CONDITION = "hit_condition";
    private static final String ATTR_LINE = "line";
    private static final String ATTR_FUNCTION = "function";
    private static final String ATTR_EXCEPTION = "exception";
    private static final String ATTR_EXPRESSION = "expression";
    private static final String ATTR_APPID = "appid";
    private static final String ATTR_IDEKEY = "idekey";
    private static final String ATTR_SESSION = "session";
    private static final String ATTR_THREAD = "thread";
    private static final String ATTR_PARENT = "parent";
    private static final String ATTR_LANGUAGE = "language";
    private static final String ATTR_ENCODING = "encoding";

    protected DbgpXmlEntityParser() {
    }

    public static DbgpStackLevel parseStackLevel(Element element) throws DbgpException {
        int level = Integer.parseInt(element.getAttribute(ATTR_LEVEL));
        String cmdBegin = element.getAttribute(ATTR_CMDBEGIN);
        String cmdEnd = element.getAttribute(ATTR_CMDEND);
        int beginLine = -1;
        int beginColumn = -1;
        int endLine = -1;
        int endColumn = -1;
        if (cmdBegin.length() != 0 && cmdEnd.length() != 0) {
            beginLine = DbgpXmlEntityParser.parseLine(cmdBegin);
            beginColumn = DbgpXmlEntityParser.parseColumn(cmdBegin);
            endLine = DbgpXmlEntityParser.parseLine(cmdEnd);
            endColumn = DbgpXmlEntityParser.parseColumn(cmdEnd);
        }
        int lineNumber = Integer.parseInt(element.getAttribute(ATTR_LINENO));
        URI fileUri = DbgpXmlEntityParser.parseURI(element.getAttribute(ATTR_FILENAME));
        String where = element.getAttribute(ATTR_WHERE);
        return new DbgpStackLevel(fileUri, where, level, lineNumber, beginLine, beginColumn, endLine, endColumn);
    }

    private static URI parseURI(String fileName) {
        if (fileName.startsWith(FILE_SCHEME_PREFIX)) {
            int pos = FILE_SCHEME_PREFIX.length();
            if (fileName.length() > pos + 3 && Character.isLetter(fileName.charAt(pos)) && fileName.charAt(pos + 1) == '|' && fileName.charAt(pos + 2) == '/') {
                fileName = String.valueOf(fileName.substring(0, pos + 1)) + ':' + fileName.substring(pos + 2);
            }
        }
        try {
            return URI.create(fileName);
        }
        catch (IllegalArgumentException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            try {
                return new URI("unknown", "", "", fileName);
            }
            catch (URISyntaxException e2) {
                if (DLTKCore.DEBUG) {
                    e2.printStackTrace();
                }
                try {
                    return new URI("unknown", "", "", "unknown");
                }
                catch (URISyntaxException e3) {
                    throw new IllegalArgumentException(e3.getMessage());
                }
            }
        }
    }

    public static DbgpFeature parseFeature(Element element) throws DbgpProtocolException {
        String name = element.getAttribute(ATTR_FEATURE_NAME);
        boolean supported = DbgpXmlEntityParser.makeBoolean(element.getAttribute(ATTR_SUPPORTED));
        String value = DbgpXmlEntityParser.parseContent(element);
        return new DbgpFeature(supported, name, value);
    }

    public static IDbgpProperty parseProperty(Element property) {
        NodeList children;
        int length;
        String name = DbgpXmlEntityParser.getFromChildOrAttr(property, ATTR_NAME);
        String fullName = DbgpXmlEntityParser.getFromChildOrAttr(property, ATTR_FULLNAME);
        String type = property.getAttribute(ATTR_TYPE);
        boolean hasChildren = false;
        if (property.hasAttribute(ATTR_CHILDREN)) {
            hasChildren = DbgpXmlEntityParser.makeBoolean(property.getAttribute(ATTR_CHILDREN));
        }
        int childrenCount = -1;
        if (property.hasAttribute(ATTR_NUMCHILDREN)) {
            childrenCount = Integer.parseInt(property.getAttribute(ATTR_NUMCHILDREN));
        }
        int page = 0;
        if (property.hasAttribute(ATTR_PAGE)) {
            page = Integer.parseInt(property.getAttribute(ATTR_PAGE));
        }
        int pagesize = -1;
        if (property.hasAttribute(ATTR_PAGE_SIZE)) {
            pagesize = Integer.parseInt(property.getAttribute(ATTR_PAGE_SIZE));
        }
        boolean constant = false;
        if (property.hasAttribute(ATTR_CONSTANT)) {
            constant = DbgpXmlEntityParser.makeBoolean(property.getAttribute(ATTR_CONSTANT));
        }
        String key = null;
        if (property.hasAttribute(ATTR_KEY)) {
            key = property.getAttribute(ATTR_KEY);
        }
        String address = null;
        if (property.hasAttribute(ATTR_ADDRESS)) {
            address = property.getAttribute(ATTR_ADDRESS);
        }
        String value = "";
        NodeList list = property.getElementsByTagName("value");
        value = list.getLength() == 0 ? DbgpXmlEntityParser.getEncodedValue(property) : DbgpXmlEntityParser.getEncodedValue((Element)list.item(0));
        IDbgpProperty[] availableChildren = NO_CHILDREN;
        if (hasChildren && (length = (children = property.getElementsByTagName(TAG_PROPERTY)).getLength()) > 0) {
            availableChildren = new IDbgpProperty[length];
            int i = 0;
            while (i < length) {
                Element child = (Element)children.item(i);
                availableChildren[i] = DbgpXmlEntityParser.parseProperty(child);
                ++i;
            }
        }
        if (childrenCount < 0) {
            childrenCount = availableChildren.length;
        }
        return new DbgpProperty(name, fullName, type, value, childrenCount, hasChildren, constant, key, address, availableChildren, page, pagesize);
    }

    public static IDbgpStatus parseStatus(Element element) throws DbgpProtocolException {
        String status = element.getAttribute(ATTR_STATUS);
        String reason = element.getAttribute(ATTR_REASON);
        return DbgpStatus.parse(status, reason);
    }

    public static IDbgpBreakpoint parseBreakpoint(Element element) {
        String type = element.getAttribute(ATTR_TYPE);
        String id = element.getAttribute(ATTR_ID);
        boolean enabled = element.getAttribute(ATTR_STATE).equals("enabled");
        int hitCount = DbgpXmlEntityParser.getIntAttribute(element, ATTR_HIT_COUNT, 0);
        int hitValue = DbgpXmlEntityParser.getIntAttribute(element, ATTR_HIT_VALUE, 0);
        String hitCondition = DbgpXmlEntityParser.getStringAttribute(element, ATTR_HIT_CONDITION);
        if (type.equals("line")) {
            String fileName = element.getAttribute(ATTR_FILENAME);
            String lineno = element.getAttribute(ATTR_LINENO);
            if ("".equals(lineno)) {
                lineno = element.getAttribute("line");
            }
            int lineNumber = Integer.parseInt(lineno);
            return new DbgpLineBreakpoint(id, enabled, hitValue, hitCount, hitCondition, fileName, lineNumber);
        }
        if (type.equals(CALL_BREAKPOINT)) {
            String function = element.getAttribute(ATTR_FUNCTION);
            return new DbgpCallBreakpoint(id, enabled, hitValue, hitCount, hitCondition, function);
        }
        if (type.equals(RETURN_BREAKPOINT)) {
            String function = element.getAttribute(ATTR_FUNCTION);
            return new DbgpReturnBreakpoint(id, enabled, hitValue, hitCount, hitCondition, function);
        }
        if (type.equals("exception")) {
            String exception = element.getAttribute("exception");
            return new DbgpExceptionBreakpoint(id, enabled, hitValue, hitCount, hitCondition, exception);
        }
        if (type.equals(CONDITIONAL_BREAKPOINT)) {
            String expression = element.getAttribute(ATTR_EXPRESSION);
            return new DbgpConditionalBreakpoint(id, enabled, hitValue, hitCount, hitCondition, expression);
        }
        if (type.equals(WATCH_BREAKPOINT)) {
            String expression = element.getAttribute(ATTR_EXPRESSION);
            return new DbgpWatchBreakpoint(id, enabled, hitValue, hitCount, hitCondition, expression);
        }
        return null;
    }

    public static IDbgpSessionInfo parseSession(Element element) {
        String appId = element.getAttribute(ATTR_APPID);
        String ideKey = element.getAttribute(ATTR_IDEKEY);
        String session = element.getAttribute(ATTR_SESSION);
        String threadId = element.getAttribute(ATTR_THREAD);
        String parentId = element.getAttribute(ATTR_PARENT);
        String language = element.getAttribute(ATTR_LANGUAGE);
        DbgpDebuggingEngineException error = DbgpXmlParser.checkError(element);
        return new DbgpSessionInfo(appId, ideKey, session, threadId, parentId, language, null, error);
    }

    protected static String getFromChildOrAttr(Element property, String name) {
        NodeList list = property.getElementsByTagName(name);
        if (list.getLength() == 0) {
            return property.getAttribute(name);
        }
        return DbgpXmlEntityParser.getEncodedValue((Element)list.item(0));
    }

    protected static String getEncodedValue(Element element) {
        String encoding = ENCODING_NONE;
        if (element.hasAttribute(ATTR_ENCODING)) {
            encoding = element.getAttribute(ATTR_ENCODING);
        }
        if (ENCODING_NONE.equals(encoding)) {
            return DbgpXmlEntityParser.parseContent(element);
        }
        if (ENCODING_BASE64.equals(encoding)) {
            return DbgpXmlEntityParser.parseBase64Content(element);
        }
        throw new AssertionError((Object)NLS.bind((String)Messages.DbgpXmlEntityParser_invalidEncoding, (Object)encoding));
    }
}

