/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.handlers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class AbstractOpenPreferencePageStatusHandler
implements IStatusHandler {
    protected void showPreferencePage(String pageId) {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)pageId, null, null);
        dialog.open();
    }

    public Object handleStatus(final IStatus status, Object source) throws CoreException {
        final String pageId = this.getPreferencePageId(source);
        final boolean[] result = new boolean[1];
        DLTKDebugUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                String title = AbstractOpenPreferencePageStatusHandler.this.getTitle();
                if (pageId == null) {
                    MessageDialog.openError((Shell)DLTKDebugUIPlugin.getActiveWorkbenchShell(), (String)title, (String)status.getMessage());
                } else {
                    String message = String.valueOf(status.getMessage()) + " " + AbstractOpenPreferencePageStatusHandler.this.getQuestion();
                    result[0] = MessageDialog.openQuestion((Shell)DLTKDebugUIPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
                    if (result[0]) {
                        AbstractOpenPreferencePageStatusHandler.this.showPreferencePage(pageId);
                    }
                }
            }
        });
        return new Boolean(result[0]);
    }

    protected abstract String getTitle();

    protected abstract String getQuestion();

    protected abstract String getPreferencePageId(Object var1);
}

