/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing;

import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.internal.core.search.matching.FieldPattern;
import org.eclipse.dltk.internal.core.search.matching.MethodDeclarationPattern;
import org.eclipse.dltk.internal.core.search.matching.MethodPattern;
import org.eclipse.dltk.internal.core.search.matching.SuperTypeReferencePattern;
import org.eclipse.dltk.internal.core.search.matching.TypeDeclarationPattern;

public abstract class AbstractIndexer
implements IIndexConstants {
    protected SearchDocument document;

    public AbstractIndexer(SearchDocument document) {
        this.document = document;
    }

    public void addTypeDeclaration(int modifiers, char[] packageName, String name, char[][] enclosingTypeNames, String[] superclasss) {
        char[] indexKey = TypeDeclarationPattern.createIndexKey(modifiers, name.toCharArray(), packageName, enclosingTypeNames, CharOperation.stringArrayToCharCharArray(superclasss));
        this.addIndexEntry(TYPE_DECL, indexKey);
        if (superclasss != null) {
            int i = 0;
            int max = superclasss.length;
            while (i < max) {
                char[] superClass = this.erasure(superclasss[i].toCharArray());
                this.addTypeReference(superClass);
                this.addIndexEntry(SUPER_REF, SuperTypeReferencePattern.createIndexKey(modifiers, packageName, name.toCharArray(), enclosingTypeNames, null, 'C', superClass, 'C'));
                ++i;
            }
        }
    }

    private char[] erasure(char[] typeName) {
        return typeName;
    }

    public void addConstructorDeclaration(String typeName, String[] parameterTypes, String[] exceptionTypes) {
    }

    public void addConstructorReference(char[] typeName, int argCount) {
    }

    public void addFieldDeclaration(char[] typeName, char[] fieldName) {
        this.addIndexEntry(FIELD_DECL, FieldPattern.createIndexKey(fieldName));
        this.addTypeReference(typeName);
    }

    public void addFieldDeclaration(char[] fieldName) {
        this.addIndexEntry(FIELD_DECL, FieldPattern.createIndexKey(fieldName));
    }

    public void addFieldReference(char[] fieldName) {
        this.addNameReference(fieldName);
    }

    protected void addIndexEntry(char[] category, char[] key) {
        this.document.addIndexEntry(category, key);
    }

    public void addMethodDeclaration(int modifiers, char[] packageName, char[][] enclosingTypeNames, String methodName, String[] parameterNames, String[] exceptionTypes) {
        this.addIndexEntry(METHOD_DECL, MethodDeclarationPattern.createIndexKey(modifiers, methodName.toCharArray(), parameterNames, packageName, enclosingTypeNames));
    }

    public void addMethodReference(char[] methodName, int argCount) {
        this.addIndexEntry(METHOD_REF, MethodPattern.createIndexKey(methodName, argCount));
    }

    public void addNameReference(char[] name) {
        this.addIndexEntry(REF, name);
    }

    public void addTypeReference(char[] typeName) {
        this.addNameReference(CharOperation.lastSegment(typeName, '/'));
    }

    public abstract void indexDocument();
}

