/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.core.BuildpathContainerInitializer;
import org.eclipse.dltk.core.BuildpathVariableInitializer;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IRegion;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SetVariablesOperation;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.BatchOperation;
import org.eclipse.dltk.internal.core.BuildpathAccessRule;
import org.eclipse.dltk.internal.core.BuildpathAttribute;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.Region;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.internal.core.util.Util;
import org.osgi.framework.BundleContext;

public class DLTKCore
extends Plugin {
    public static final boolean VERBOSE = false;
    public static final boolean VERBOSE_MODEL_MANAGER = false;
    public static final boolean VERBOSE_BP_RESOLVE = false;
    public static final boolean VERBOSE_ZIP_ACCESS = false;
    public static final boolean VERBOSE_EXTERNAL_FRAGMENT = false;
    public static final boolean VERBOSE_JOBMANAGER = false;
    public static final boolean VERBOSE_SEARCH = false;
    public static final boolean VERBOSE_SEARCH_NAMELOOKUP = false;
    public static final boolean VERBOSE_COMPLETION = false;
    public static final boolean VERBOSE_MIXIN = false;
    public static final boolean PERFOMANCE = false;
    public static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.core/debug"));
    public static final boolean SHOW_REINDEX = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.core/show_reindex"));
    public static final boolean DEBUG_PRINT_MODEL = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.core/debugPrintModel"));
    public static final boolean DEBUG_SCOPES = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.core/debugScopes"));
    public static final boolean DEBUG_SCRIPT_BUILDER = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.core/debugScriptBuilder"));
    public static final boolean TRACE_SCRIPT_BUILDER = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.core/traceScriptBuilder"));
    public static final boolean DEBUG_COMPLETION = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.core/debugCompletion"));
    public static final boolean DEBUG_SELECTION = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.core/debugSelection"));
    public static final boolean DEBUG_PARSER = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.core/debugParser"));
    public static final boolean DEBUG_INDEX = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.core/debugIndex"));
    public static final boolean DEBUG_LOG = false;
    private static DLTKCore plugin;
    public static final String PLUGIN_ID = "org.eclipse.dltk.core";
    public static final String USER_LIBRARY_CONTAINER_ID = "org.eclipse.dltk.USER_LIBRARY";
    public static final String ERROR = "error";
    public static final String BUILDER_ID = "org.eclipse.dltk.core.scriptbuilder";
    public static final String ABORT = "abort";
    public static final String WARNING = "warning";
    public static final String IGNORE = "ignore";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final String CLEAN = "clean";
    public static final String COMPILER_PB_FORBIDDEN_REFERENCE = "org.eclipse.dltk.core.compiler.problem.forbiddenReference";
    public static final String COMPILER_PB_DISCOURAGED_REFERENCE = "org.eclipse.dltk.core.compiler.problem.discouragedReference";
    public static final String CORE_ENCODING = "org.eclipse.dltk.core.encoding";
    public static final String CORE_ENABLE_BUILDPATH_EXCLUSION_PATTERNS = "org.eclipse.dltk.core.buildpath.exclusionPatterns";
    public static final String CORE_CIRCULAR_BUILDPATH = "org.eclipse.dltk.core.circularBuildpath";
    public static final String CORE_INCOMPLETE_BUILDPATH = "org.eclipse.dltk.core.incompleteBuildpath";
    public static final String CODEASSIST_VISIBILITY_CHECK = "org.eclipse.dltk.core.codeComplete.visibilityCheck";
    public static final String CODEASSIST_DEPRECATION_CHECK = "org.eclipse.dltk.core.codeComplete.deprecationCheck";
    public static final String CODEASSIST_CAMEL_CASE_MATCH = "org.eclipse.dltk.core.codeComplete.camelCaseMatch";
    public static final String CODEASSIST_IMPLICIT_QUALIFICATION = "org.eclipse.dltk.core.codeComplete.forceImplicitQualification";
    public static final String CODEASSIST_FIELD_PREFIXES = "org.eclipse.dltk.core.codeComplete.fieldPrefixes";
    public static final String CODEASSIST_LOCAL_PREFIXES = "org.eclipse.dltk.core.codeComplete.localPrefixes";
    public static final String CODEASSIST_ARGUMENT_PREFIXES = "org.eclipse.dltk.core.codeComplete.argumentPrefixes";
    public static final String CODEASSIST_FIELD_SUFFIXES = "org.eclipse.dltk.core.codeComplete.fieldSuffixes";
    public static final String CODEASSIST_LOCAL_SUFFIXES = "org.eclipse.dltk.core.codeComplete.localSuffixes";
    public static final String CODEASSIST_ARGUMENT_SUFFIXES = "org.eclipse.dltk.core.codeComplete.argumentSuffixes";
    public static final String CODEASSIST_FORBIDDEN_REFERENCE_CHECK = "org.eclipse.dltk.core.codeComplete.forbiddenReferenceCheck";
    public static final String CODEASSIST_DISCOURAGED_REFERENCE_CHECK = "org.eclipse.dltk.core.codeComplete.discouragedReferenceCheck";
    public static final String FILE_CACHE = "org.eclipse.dltk.core.contentCache";
    public static final String BUILDER_ENABLED = "org.eclipse.dltk.core.builder";
    public static final String INDEXER_ENABLED = "org.eclipse.dltk.core.indexer";

    public DLTKCore() {
        plugin = this;
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public static void addElementChangedListener(IElementChangedListener listener) {
        DLTKCore.addElementChangedListener(listener, 5);
    }

    public static void addElementChangedListener(IElementChangedListener listener, int eventMask) {
        ModelManager.getModelManager().deltaState.addElementChangedListener(listener, eventMask);
    }

    public static void removeElementChangedListener(IElementChangedListener listener) {
        ModelManager.getModelManager().deltaState.removeElementChangedListener(listener);
    }

    public static void addPreProcessingResourceChangedListener(IResourceChangeListener listener, int eventMask) {
        ModelManager.getModelManager().deltaState.addPreResourceChangedListener(listener, eventMask);
    }

    public static void removePreProcessingResourceChangedListener(IResourceChangeListener listener) {
        ModelManager.getModelManager().deltaState.removePreResourceChangedListener(listener);
    }

    public static String getEncoding() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            try {
                return workspace.getRoot().getDefaultCharset();
            }
            catch (CoreException coreException) {}
        }
        return ResourcesPlugin.getEncoding();
    }

    public static IModelElement create(IFile file) {
        return ModelManager.create(file, null);
    }

    public static IModelElement create(IResource resource) {
        return ModelManager.create(resource, null);
    }

    public static IScriptModel create(IWorkspaceRoot root) {
        if (root == null) {
            return null;
        }
        return ModelManager.getModelManager().getModel();
    }

    public static IScriptProject create(IProject project) {
        if (project == null) {
            return null;
        }
        Model model = ModelManager.getModelManager().getModel();
        return model.getScriptProject((IResource)project);
    }

    public static IBuildpathEntry newSourceEntry(IPath path) {
        return DLTKCore.newSourceEntry(path, BuildpathEntry.INCLUDE_ALL, BuildpathEntry.EXCLUDE_NONE);
    }

    public static IBuildpathEntry newSourceEntry(IPath path, IPath[] exclusionPatterns) {
        return DLTKCore.newSourceEntry(path, BuildpathEntry.INCLUDE_ALL, exclusionPatterns);
    }

    public static IBuildpathEntry newSourceEntry(IPath path, IPath[] inclusionPatterns, IPath[] exclusionPatterns) {
        return DLTKCore.newSourceEntry(path, inclusionPatterns, exclusionPatterns, BuildpathEntry.NO_EXTRA_ATTRIBUTES);
    }

    public static IBuildpathEntry newSourceEntry(IPath path, IPath[] inclusionPatterns, IPath[] exclusionPatterns, IBuildpathAttribute[] extraAttributes) {
        Assert.isNotNull((Object)path, (String)"Source path cannot be null");
        if (!path.isAbsolute()) {
            Assert.isTrue((boolean)false, (String)"Path for IBuildpathEntry must be absolute");
        }
        if (exclusionPatterns == null) {
            Assert.isTrue((boolean)false, (String)"Exclusion pattern set cannot be null");
        }
        if (inclusionPatterns == null) {
            Assert.isTrue((boolean)false, (String)"Inclusion pattern set cannot be null");
        }
        return new BuildpathEntry(1, 3, path, false, inclusionPatterns, exclusionPatterns, null, false, extraAttributes, false);
    }

    public static IBuildpathEntry newProjectEntry(IPath path) {
        return DLTKCore.newProjectEntry(path, false);
    }

    public static IBuildpathEntry newProjectEntry(IPath path, boolean isExported) {
        if (!path.isAbsolute()) {
            Assert.isTrue((boolean)false, (String)"Path for IBuildpathEntry must be absolute");
        }
        return DLTKCore.newProjectEntry(path, BuildpathEntry.NO_ACCESS_RULES, true, BuildpathEntry.NO_EXTRA_ATTRIBUTES, isExported);
    }

    public static IBuildpathEntry newProjectEntry(IPath path, IAccessRule[] accessRules, boolean combineAccessRules, IBuildpathAttribute[] extraAttributes, boolean isExported) {
        if (!path.isAbsolute()) {
            Assert.isTrue((boolean)false, (String)"Path for IBuildpathEntry must be absolute");
        }
        return new BuildpathEntry(1, 2, path, isExported, BuildpathEntry.INCLUDE_ALL, BuildpathEntry.EXCLUDE_NONE, accessRules, combineAccessRules, extraAttributes, false);
    }

    public static IAccessRule newAccessRule(IPath filePattern, int kind) {
        return new BuildpathAccessRule(filePattern, kind);
    }

    public static IBuildpathAttribute newBuildpathAttribute(String name, String value) {
        return new BuildpathAttribute(name, value);
    }

    public static IBuildpathEntry newVariableEntry(IPath variablePath) {
        return DLTKCore.newVariableEntry(variablePath, false);
    }

    public static IBuildpathEntry newVariableEntry(IPath variablePath, boolean isExported) {
        return DLTKCore.newVariableEntry(variablePath, BuildpathEntry.NO_ACCESS_RULES, BuildpathEntry.NO_EXTRA_ATTRIBUTES, isExported);
    }

    public static IBuildpathEntry newVariableEntry(IPath variablePath, IAccessRule[] accessRules, IBuildpathAttribute[] extraAttributes, boolean isExported) {
        if (variablePath == null) {
            Assert.isTrue((boolean)false, (String)"Variable path cannot be null");
        }
        if (variablePath.segmentCount() < 1) {
            Assert.isTrue((boolean)false, (String)("Illegal buildpath variable path: '" + variablePath.makeRelative().toString() + "', must have at least one segment"));
        }
        return new BuildpathEntry(1, 4, variablePath, isExported, BuildpathEntry.INCLUDE_ALL, BuildpathEntry.EXCLUDE_NONE, accessRules, true, extraAttributes, false);
    }

    public static void removeBuildpathVariable(String variableName, IProgressMonitor monitor) {
        try {
            SetVariablesOperation operation = new SetVariablesOperation(new String[]{variableName}, new IPath[1], true);
            operation.runOperation(monitor);
        }
        catch (ModelException e) {
            Util.log((Throwable)((Object)e), "Exception while removing variable " + variableName);
        }
    }

    public static IBuildpathEntry newContainerEntry(IPath containerPath) {
        return DLTKCore.newContainerEntry(containerPath, BuildpathEntry.NO_ACCESS_RULES, BuildpathEntry.NO_EXTRA_ATTRIBUTES, false);
    }

    public static IBuildpathEntry newContainerEntry(IPath containerPath, boolean isExported) {
        return DLTKCore.newContainerEntry(containerPath, BuildpathEntry.NO_ACCESS_RULES, BuildpathEntry.NO_EXTRA_ATTRIBUTES, isExported);
    }

    public static IBuildpathEntry newContainerEntry(IPath containerPath, IAccessRule[] accessRules, IBuildpathAttribute[] extraAttributes, boolean isExported) {
        if (containerPath == null) {
            Assert.isTrue((boolean)false, (String)"Container path cannot be null");
        } else if (containerPath.segmentCount() < 1) {
            Assert.isTrue((boolean)false, (String)("Illegal buildpath container path: '" + containerPath.makeRelative().toString() + "', must have at least one segment (containerID+hints)"));
        }
        BuildpathEntry entry = new BuildpathEntry(1, 5, containerPath, isExported, BuildpathEntry.INCLUDE_ALL, BuildpathEntry.EXCLUDE_NONE, accessRules, true, extraAttributes, false);
        entry.setIsContainerEntry(true);
        return entry;
    }

    public static String getOption(String optionName) {
        return ModelManager.getModelManager().getOption(optionName);
    }

    public static Hashtable getOptions() {
        return ModelManager.getModelManager().getOptions();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ModelManager.getModelManager().startup();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            ModelManager.getModelManager().shutdown();
        }
        finally {
            super.stop(context);
            plugin = null;
        }
    }

    public static DLTKCore getDefault() {
        return plugin;
    }

    public static void run(IWorkspaceRunnable action, IProgressMonitor monitor) throws CoreException {
        DLTKCore.run(action, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), monitor);
    }

    public static void run(IWorkspaceRunnable action, ISchedulingRule rule, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.isTreeLocked()) {
            new BatchOperation(action).run(monitor);
        } else {
            workspace.run((IWorkspaceRunnable)new BatchOperation(action), rule, 1, monitor);
        }
    }

    public static BuildpathVariableInitializer getBuildpathVariableInitializer(String variable) {
        Plugin dltkCorePlugin = DLTKCore.getPlugin();
        if (dltkCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "buildpathVariableInitializer");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        Object execExt;
                        String varAttribute = configElement.getAttribute("variable");
                        if (variable.equals(varAttribute) && (execExt = configElement.createExecutableExtension("class")) instanceof BuildpathVariableInitializer) {
                            BuildpathVariableInitializer initializer = (BuildpathVariableInitializer)execExt;
                            String readOnlyAttribute = configElement.getAttribute("readOnly");
                            if ("true".equals(readOnlyAttribute)) {
                                ModelManager.getModelManager().readOnlyVariables.add(variable);
                            }
                            return initializer;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static IPath getBuildpathVariable(String variableName) {
        ModelManager manager = ModelManager.getModelManager();
        IPath variablePath = manager.variableGet(variableName);
        if (variablePath == ModelManager.VARIABLE_INITIALIZATION_IN_PROGRESS) {
            return manager.getPreviousSessionVariable(variableName);
        }
        if (variablePath != null) {
            if (variablePath == ModelManager.BP_ENTRY_IGNORE_PATH) {
                return null;
            }
            return variablePath;
        }
        BuildpathVariableInitializer initializer = DLTKCore.getBuildpathVariableInitializer(variableName);
        if (initializer != null) {
            manager.variablePut(variableName, ModelManager.VARIABLE_INITIALIZATION_IN_PROGRESS);
            boolean ok = false;
            try {
                initializer.initialize(variableName);
                variablePath = manager.variableGet(variableName);
                if (variablePath == ModelManager.VARIABLE_INITIALIZATION_IN_PROGRESS) {
                    return null;
                }
                try {
                    manager.variablesWithInitializer.add(variableName);
                    ok = true;
                }
                catch (RuntimeException e) {
                    if (ModelManager.BP_RESOLVE_VERBOSE) {
                        e.printStackTrace();
                    }
                    throw e;
                }
                catch (Error e) {
                    if (ModelManager.BP_RESOLVE_VERBOSE) {
                        e.printStackTrace();
                    }
                    throw e;
                }
            }
            finally {
                if (!ok) {
                    ModelManager.getModelManager().variablePut(variableName, null);
                }
            }
        }
        return variablePath;
    }

    public static IBuildpathEntry getResolvedBuildpathEntry(IBuildpathEntry entry) {
        if (entry.getEntryKind() != 4) {
            return entry;
        }
        IPath resolvedPath = DLTKCore.getResolvedVariablePath(entry.getPath());
        if (resolvedPath == null) {
            return null;
        }
        Object target = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), resolvedPath, false);
        if (target == null) {
            return null;
        }
        if (target instanceof IResource) {
            IResource resolvedResource = (IResource)target;
            switch (resolvedResource.getType()) {
                case 4: {
                    return DLTKCore.newProjectEntry(resolvedPath, entry.getAccessRules(), entry.combineAccessRules(), entry.getExtraAttributes(), entry.isExported());
                }
                case 1: {
                    return DLTKCore.newLibraryEntry(resolvedPath, entry.getAccessRules(), entry.getExtraAttributes(), entry.isExported(), entry.isExternal());
                }
                case 2: {
                    return DLTKCore.newLibraryEntry(resolvedPath, entry.getAccessRules(), entry.getExtraAttributes(), entry.isExported(), entry.isExternal());
                }
            }
        }
        if (target instanceof File) {
            IFileHandle externalFile = Model.getFile(target);
            if (externalFile != null) {
                return DLTKCore.newLibraryEntry(resolvedPath, entry.getAccessRules(), entry.getExtraAttributes(), entry.isExported(), entry.isExternal());
            }
            if (resolvedPath.isAbsolute()) {
                return DLTKCore.newLibraryEntry(resolvedPath, entry.getAccessRules(), entry.getExtraAttributes(), entry.isExported(), entry.isExternal());
            }
        }
        return null;
    }

    public static IPath getResolvedVariablePath(IPath variablePath) {
        if (variablePath == null) {
            return null;
        }
        int count = variablePath.segmentCount();
        if (count == 0) {
            return null;
        }
        String variableName = variablePath.segment(0);
        IPath resolvedPath = DLTKCore.getBuildpathVariable(variableName);
        if (resolvedPath == null) {
            return null;
        }
        if (count > 1) {
            resolvedPath = resolvedPath.append(variablePath.removeFirstSegments(1));
        }
        return resolvedPath;
    }

    public static IBuildpathContainer getBuildpathContainer(IPath containerPath, IScriptProject project) throws ModelException {
        ModelManager manager = ModelManager.getModelManager();
        IBuildpathContainer container = manager.getBuildpathContainer(containerPath, project);
        if (container == ModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS) {
            return manager.getPreviousSessionContainer(containerPath, project);
        }
        return container;
    }

    public static BuildpathContainerInitializer getBuildpathContainerInitializer(String containerID) {
        HashMap containerInitializersCache = ModelManager.getModelManager().containerInitializersCache;
        BuildpathContainerInitializer initializer = (BuildpathContainerInitializer)containerInitializersCache.get(containerID);
        if (initializer == null) {
            initializer = DLTKCore.computeBuildpathContainerInitializer(containerID);
            if (initializer == null) {
                return null;
            }
            containerInitializersCache.put(containerID, initializer);
        }
        return initializer;
    }

    private static BuildpathContainerInitializer computeBuildpathContainerInitializer(String containerID) {
        Plugin dltkCorePlugin = DLTKCore.getPlugin();
        if (dltkCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "buildpathContainerInitializer");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    block9: {
                        String initializerID = configElements[j].getAttribute("id");
                        if (initializerID != null && initializerID.equals(containerID)) {
                            if (ModelManager.BP_RESOLVE_VERBOSE) {
                                Util.verbose("BPContainer INIT - found initializer\n\tcontainer ID: " + containerID + '\n' + "\tclass: " + configElements[j].getAttribute("class"));
                            }
                            try {
                                Object execExt = configElements[j].createExecutableExtension("class");
                                if (execExt instanceof BuildpathContainerInitializer) {
                                    return (BuildpathContainerInitializer)execExt;
                                }
                            }
                            catch (CoreException e) {
                                if (!ModelManager.BP_RESOLVE_VERBOSE) break block9;
                                Util.verbose("BPContainer INIT - failed to instanciate initializer\n\tcontainer ID: " + containerID + '\n' + "\tclass: " + configElements[j].getAttribute("class"), System.err);
                                e.printStackTrace();
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static void setBuildpathContainer(final IPath containerPath, IScriptProject[] affectedProjects, IBuildpathContainer[] respectiveContainers, IProgressMonitor monitor) throws ModelException {
        if (affectedProjects.length != respectiveContainers.length) {
            Assert.isTrue((boolean)false, (String)"Projects and containers collections should have the same size");
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (ModelManager.BP_RESOLVE_VERBOSE) {
            Util.verbose("BPContainer SET  - setting container\n\tcontainer path: " + containerPath + '\n' + "\tprojects: {" + Util.toString(affectedProjects, new Util.Displayable(){

                public String displayString(Object o) {
                    return ((IScriptProject)o).getElementName();
                }
            }) + "}\n\tvalues: {\n" + Util.toString(respectiveContainers, new Util.Displayable(){

                public String displayString(Object o) {
                    StringBuffer buffer = new StringBuffer("\t\t");
                    if (o == null) {
                        buffer.append("<null>");
                        return buffer.toString();
                    }
                    IBuildpathContainer container = (IBuildpathContainer)o;
                    buffer.append(container.getDescription(null));
                    buffer.append(" {\n");
                    IBuildpathEntry[] entries = container.getBuildpathEntries(null);
                    if (entries != null) {
                        int i = 0;
                        while (i < entries.length) {
                            buffer.append(" \t\t\t");
                            buffer.append(entries[i]);
                            buffer.append('\n');
                            ++i;
                        }
                    }
                    buffer.append(" \t\t}");
                    return buffer.toString();
                }
            }) + "\n\t}\n\tinvocation stack trace:");
            new Exception("<Fake exception>").printStackTrace(System.out);
        }
        if ((manager = ModelManager.getModelManager()).containerPutIfInitializingWithSameEntries(containerPath, affectedProjects, respectiveContainers)) {
            return;
        }
        projectLength = affectedProjects.length;
        modifiedProjects = new IScriptProject[projectLength];
        System.arraycopy(affectedProjects, 0, modifiedProjects, 0, projectLength);
        oldResolvedPaths = new IBuildpathEntry[projectLength][];
        remaining = 0;
        i = 0;
        while (i < projectLength) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            affectedProject = (ScriptProject)affectedProjects[i];
            newContainer = respectiveContainers[i];
            if (newContainer == null) {
                newContainer = ModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS;
            }
            found = false;
            if (ScriptProject.hasScriptNature(affectedProject.getProject())) {
                rawClasspath = affectedProject.getRawBuildpath();
                j = 0;
                cpLength = rawClasspath.length;
                while (j < cpLength) {
                    entry = rawClasspath[j];
                    if (entry.getEntryKind() == 5 && entry.getPath().equals((Object)containerPath)) {
                        found = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!found) {
                modifiedProjects[i] = null;
                manager.containerPut(affectedProject, containerPath, newContainer);
            } else {
                oldContainer = manager.containerGet(affectedProject, containerPath);
                if (oldContainer == ModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS) {
                    oldContainer = null;
                }
                if (oldContainer != null && oldContainer.equals(respectiveContainers[i])) {
                    modifiedProjects[i] = null;
                } else {
                    ++remaining;
                    oldResolvedPaths[i] = affectedProject.getResolvedBuildpath(true, false, false);
                    manager.containerPut(affectedProject, containerPath, newContainer);
                }
            }
            ++i;
        }
        if (remaining == 0) {
            return;
        }
        try {
            try {
                canChangeResources = ResourcesPlugin.getWorkspace().isTreeLocked() == false;
                DLTKCore.run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor progressMonitor) throws CoreException {
                        int i = 0;
                        while (i < projectLength) {
                            if (progressMonitor != null && progressMonitor.isCanceled()) {
                                return;
                            }
                            ScriptProject affectedProject = (ScriptProject)modifiedProjects[i];
                            if (affectedProject != null) {
                                if (ModelManager.BP_RESOLVE_VERBOSE) {
                                    Util.verbose("BPContainer SET  - updating affected project due to setting container\n\tproject: " + affectedProject.getElementName() + '\n' + "\tcontainer path: " + containerPath);
                                }
                                affectedProject.setRawBuildpath(affectedProject.getRawBuildpath(), progressMonitor, canChangeResources, oldResolvedPaths[i], false, false);
                            }
                            ++i;
                        }
                    }
                }, null, monitor);
            }
            catch (CoreException e) {
                if (ModelManager.BP_RESOLVE_VERBOSE) {
                    Util.verbose("CPContainer SET  - FAILED DUE TO EXCEPTION\n\tcontainer path: " + containerPath, System.err);
                    e.printStackTrace();
                }
                if (e instanceof ModelException) {
                    throw (ModelException)e;
                }
                throw new ModelException(e);
            }
        }
        finally {
            i = 0;
            ** while (i < projectLength)
        }
lbl-1000:
        // 1 sources

        {
            if (respectiveContainers[i] == null) {
                manager.containerPut(affectedProjects[i], containerPath, null);
            }
            ++i;
            continue;
        }
lbl72:
        // 1 sources

    }

    public static void refreshBuildpathContainers(IScriptProject project) throws CoreException {
        IBuildpathEntry[] entries = project.getRawBuildpath();
        int j = 0;
        while (j < entries.length) {
            IBuildpathEntry entry = entries[j];
            switch (entry.getEntryKind()) {
                case 5: {
                    IPath reference = entry.getPath();
                    BuildpathContainerInitializer initializer = DLTKCore.getBuildpathContainerInitializer(reference.segment(0));
                    initializer.initialize(reference, project);
                }
            }
            ++j;
        }
    }

    public static void setBuildpathVariable(String variableName, IPath path, IProgressMonitor monitor) throws ModelException {
        if (path == null) {
            Assert.isTrue((boolean)false, (String)"Variable path cannot be null");
        }
        DLTKCore.setBuildpathVariables(new String[]{variableName}, new IPath[]{path}, monitor);
    }

    public static void setBuildpathVariables(String[] variableNames, IPath[] paths, IProgressMonitor monitor) throws ModelException {
        if (variableNames.length != paths.length) {
            Assert.isTrue((boolean)false, (String)"Variable names and paths collections should have the same size");
        }
        SetVariablesOperation operation = new SetVariablesOperation(variableNames, paths, true);
        operation.runOperation(monitor);
    }

    public static IBuildpathEntry newLibraryEntry(IPath path) {
        return DLTKCore.newLibraryEntry(path, BuildpathEntry.NO_ACCESS_RULES, BuildpathEntry.NO_EXTRA_ATTRIBUTES, false, false);
    }

    public static IBuildpathEntry newExtLibraryEntry(IPath path) {
        return DLTKCore.newLibraryEntry(path, BuildpathEntry.NO_ACCESS_RULES, BuildpathEntry.NO_EXTRA_ATTRIBUTES, false, true);
    }

    public static IBuildpathEntry newLibraryEntry(IPath path, boolean isExported) {
        return DLTKCore.newLibraryEntry(path, BuildpathEntry.NO_ACCESS_RULES, BuildpathEntry.NO_EXTRA_ATTRIBUTES, isExported, false);
    }

    public static IBuildpathEntry newLibraryEntry(IPath path, boolean isExported, boolean externalLib) {
        return DLTKCore.newLibraryEntry(path, BuildpathEntry.NO_ACCESS_RULES, BuildpathEntry.NO_EXTRA_ATTRIBUTES, isExported, externalLib);
    }

    public static IBuildpathEntry newLibraryEntry(IPath path, IAccessRule[] accessRules, IBuildpathAttribute[] extraAttributes, boolean isExported, boolean externalLib) {
        if (path == null) {
            Assert.isTrue((boolean)false, (String)"Library path cannot be null");
        }
        if (!path.isAbsolute()) {
            Assert.isTrue((boolean)false, (String)"Path for IBuildpathEntry must be absolute");
        }
        return new BuildpathEntry(3, 1, ScriptProject.canonicalizedPath(path), isExported, BuildpathEntry.INCLUDE_ALL, BuildpathEntry.EXCLUDE_NONE, accessRules, false, extraAttributes, externalLib);
    }

    public static IBuildpathEntry newLibraryEntry(IPath path, IAccessRule[] accessRules, IBuildpathAttribute[] extraAttributes, IPath[] include, IPath[] exclude, boolean isExported, boolean externalLib) {
        if (path == null) {
            Assert.isTrue((boolean)false, (String)"Library path cannot be null");
        }
        if (!path.isAbsolute()) {
            Assert.isTrue((boolean)false, (String)"Path for IBuildpathEntry must be absolute");
        }
        return new BuildpathEntry(3, 1, ScriptProject.canonicalizedPath(path), isExported, include, exclude, accessRules, false, extraAttributes, externalLib);
    }

    public static IBuildpathEntry newBuiltinEntry(IPath path, IAccessRule[] accessRules, IBuildpathAttribute[] extraAttributes, IPath[] include, IPath[] exclude, boolean isExported, boolean externalLib) {
        if (path == null) {
            Assert.isTrue((boolean)false, (String)"Library path cannot be null");
        }
        return new BuildpathEntry(3, 1, path, isExported, include, exclude, accessRules, false, extraAttributes, externalLib);
    }

    public static IModelElement create(String handleIdentifier) {
        return DLTKCore.create(handleIdentifier, DefaultWorkingCopyOwner.PRIMARY);
    }

    public static IModelElement create(String handleIdentifier, WorkingCopyOwner owner) {
        if (handleIdentifier == null) {
            return null;
        }
        MementoTokenizer memento = new MementoTokenizer(handleIdentifier);
        Model model = ModelManager.getModelManager().getModel();
        return model.getHandleFromMemento(memento, owner);
    }

    public static ISourceModule createSourceModuleFrom(IFile file) {
        return ModelManager.createSourceModuleFrom(file, null);
    }

    public static String[] getBuildpathVariableNames() {
        return ModelManager.getModelManager().variableNames();
    }

    public static boolean isBuildpathVariableReadOnly(String variableName) {
        return ModelManager.getModelManager().readOnlyVariables.contains(variableName);
    }

    public static Hashtable getDefaultOptions() {
        return ModelManager.getModelManager().getDefaultOptions();
    }

    public static void setOptions(Hashtable defaultOptions) {
        ModelManager.getModelManager().setOptions(defaultOptions);
    }

    public static IRegion newRegion() {
        return new Region();
    }

    public static String[] getUserLibraryNames(IDLTKLanguageToolkit toolkit) {
        return ModelManager.getUserLibraryManager().getUserLibraryNames(toolkit);
    }

    public static void error(String message) {
        plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, message, null));
    }

    public static void error(String message, Throwable t) {
        plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, message, t));
    }

    public static void warn(String message) {
        DLTKCore.warn(message, null);
    }

    public static void warn(String message, Throwable t) {
        plugin.getLog().log((IStatus)new Status(2, PLUGIN_ID, 0, message, t));
    }
}

