/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISearchFactory;
import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.core.search.matching.PatternLocator;
import org.eclipse.dltk.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.dltk.internal.core.search.matching.MethodDeclarationPattern;

public class MethodDeclarationLocator
extends PatternLocator {
    protected MethodDeclarationPattern pattern;

    public MethodDeclarationLocator(MethodDeclarationPattern pattern) {
        super(pattern);
        this.pattern = pattern;
    }

    protected void clear() {
    }

    public void initializePolymorphicSearch(MatchLocator locator) {
    }

    public int match(MethodDeclaration node, MatchingNodeSet nodeSet) {
        String declaringType;
        if (!this.matchesName(this.pattern.simpleName, node.getName().toCharArray())) {
            return 0;
        }
        List arguments = node.getArguments();
        if (this.pattern.parameterNames != null) {
            int argsLength;
            int length = this.pattern.parameterNames.length;
            int n = argsLength = arguments == null ? 0 : arguments.size();
            if (length != argsLength) {
                return 0;
            }
        }
        if (this.checkTypeName(declaringType = node.getDeclaringTypeName())) {
            return 1;
        }
        return nodeSet.addMatch(node, 3);
    }

    public int matchContainer() {
        return 7;
    }

    public SearchMatch newDeclarationMatch(ASTNode reference, IModelElement element, int accuracy, MatchLocator locator) {
        return super.newDeclarationMatch(reference, element, accuracy, locator);
    }

    protected int referenceType() {
        return 9;
    }

    public String toString() {
        return "Locator for " + this.pattern.toString();
    }

    public int match(CallExpression node, MatchingNodeSet nodeSet) {
        return 0;
    }

    private boolean checkTypeName(String declaringType) {
        IDLTKLanguageToolkit toolkit = this.pattern.getToolkit();
        ISearchFactory factory = DLTKLanguageManager.getSearchFactory(toolkit.getNatureId());
        ISearchPatternProcessor processor = factory.createSearchPatternProcessor();
        if (processor != null && this.pattern.enclosingTypeNames != null && this.pattern.enclosingTypeNames.length > 0) {
            char[] delimeter = processor.getDelimiterReplacementString().toCharArray();
            char[] typeName = this.pattern.enclosingTypeNames[0];
            if (typeName == null) {
                return false;
            }
            int i = 1;
            while (i < this.pattern.enclosingTypeNames.length) {
                typeName = CharOperation.concatWithSeparator(typeName, this.pattern.enclosingTypeNames[i], delimeter);
                ++i;
            }
            if (declaringType != null) {
                char[] declaringTypeName = declaringType.toCharArray();
                if (!this.matchesName(typeName, declaringTypeName)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

