/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.Util;

public class ProjectReferenceChange {
    private ScriptProject project;
    private IBuildpathEntry[] oldResolvedBuildpath;

    public ProjectReferenceChange(ScriptProject project, IBuildpathEntry[] oldResolvedBuildpath) {
        this.project = project;
        this.oldResolvedBuildpath = oldResolvedBuildpath;
    }

    public void updateProjectReferencesIfNecessary() throws ModelException {
        if (!this.project.getProject().isAccessible()) {
            return;
        }
        String[] oldRequired = this.oldResolvedBuildpath == null ? CharOperation.NO_STRINGS : this.project.projectPrerequisites(this.oldResolvedBuildpath);
        IBuildpathEntry[] newResolvedBuildpath = this.project.getResolvedBuildpath();
        String[] newRequired = this.project.projectPrerequisites(newResolvedBuildpath);
        try {
            int newSize;
            HashSet newReferences;
            IProjectDescription description;
            IProject projectResource;
            block11: {
                String projectName;
                projectResource = this.project.getProject();
                description = projectResource.getDescription();
                IProject[] projectReferences = description.getDynamicReferences();
                HashSet<String> oldReferences = new HashSet<String>(projectReferences.length);
                int i = 0;
                while (i < projectReferences.length) {
                    String projectName2 = projectReferences[i].getName();
                    oldReferences.add(projectName2);
                    ++i;
                }
                newReferences = (HashSet)oldReferences.clone();
                int i2 = 0;
                while (i2 < oldRequired.length) {
                    projectName = oldRequired[i2];
                    newReferences.remove(projectName);
                    ++i2;
                }
                i2 = 0;
                while (i2 < newRequired.length) {
                    projectName = newRequired[i2];
                    newReferences.add(projectName);
                    ++i2;
                }
                newSize = newReferences.size();
                if (oldReferences.size() == newSize) {
                    Iterator iter = newReferences.iterator();
                    while (iter.hasNext()) {
                        if (oldReferences.contains(iter.next())) {
                            continue;
                        }
                        break block11;
                    }
                    return;
                }
            }
            String[] requiredProjectNames = new String[newSize];
            int index = 0;
            Iterator iter = newReferences.iterator();
            while (iter.hasNext()) {
                requiredProjectNames[index++] = (String)iter.next();
            }
            Util.sort(requiredProjectNames);
            IProject[] requiredProjectArray = new IProject[newSize];
            IWorkspaceRoot wksRoot = projectResource.getWorkspace().getRoot();
            int i = 0;
            while (i < newSize) {
                requiredProjectArray[i] = wksRoot.getProject(requiredProjectNames[i]);
                ++i;
            }
            description.setDynamicReferences(requiredProjectArray);
            projectResource.setDescription(description, null);
        }
        catch (CoreException coreException) {}
    }
}

