/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.InstrumentationContentProvider;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SelectionDialogComparator;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class SelectionDialog
extends SelectionStatusDialog
implements ISelectionChangedListener {
    private CheckboxTreeViewer fViewer;
    private List<ViewerFilter> fFilters;
    private Object fInput;
    private Set<Object> fExisting;
    private Object fFocusElement;

    public SelectionDialog(Shell parent) {
        super(parent);
        this.setSelectionResult(null);
        this.setStatusLineAboveButtons(true);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
        this.fExisting = null;
        this.fFocusElement = null;
        this.fFilters = null;
    }

    public void setExisting(Object[] existing) {
        this.fExisting = new HashSet<Object>();
        int i = 0;
        while (i < existing.length) {
            this.fExisting.add(existing[i]);
            ++i;
        }
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    public void addFilter(ViewerFilter filter) {
        if (this.fFilters == null) {
            this.fFilters = new ArrayList<ViewerFilter>(4);
        }
        this.fFilters.add(filter);
    }

    protected void cancelPressed() {
        this.setSelectionResult(null);
        super.cancelPressed();
    }

    protected void computeResult() {
        Object[] checked = this.fViewer.getCheckedElements();
        if (this.fExisting == null) {
            if (checked.length == 0) {
                checked = null;
            }
        } else {
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < checked.length) {
                Object elem = checked[i];
                if (!this.fExisting.contains(elem)) {
                    result.add(elem);
                }
                ++i;
            }
            checked = !result.isEmpty() ? result.toArray() : (Object[])null;
        }
        this.setSelectionResult(checked);
    }

    private void access$superCreate() {
        super.create();
    }

    public void create() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                SelectionDialog.this.access$superCreate();
                SelectionDialog.this.fViewer.setCheckedElements(SelectionDialog.this.getInitialElementSelections().toArray());
                SelectionDialog.this.fViewer.expandToLevel(2);
                if (SelectionDialog.this.fExisting != null) {
                    for (Object item : SelectionDialog.this.fExisting) {
                        SelectionDialog.this.fViewer.reveal(item);
                    }
                }
                SelectionDialog.this.updateOKStatus();
            }
        });
    }

    protected CheckboxTreeViewer createTreeViewer(Composite parent) {
        this.fViewer = new CheckboxTreeViewer(parent, 2048);
        this.fViewer.setContentProvider((IContentProvider)new InstrumentationContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new ModelElementLabelProvider());
        this.fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SelectionDialog.this.updateOKStatus();
            }
        });
        this.fViewer.setComparator((ViewerComparator)new SelectionDialogComparator());
        if (this.fFilters != null) {
            for (ViewerFilter filter : this.fFilters) {
                this.fViewer.addFilter(filter);
            }
        }
        this.fViewer.setInput(this.fInput);
        return this.fViewer;
    }

    protected void updateOKStatus() {
        this.computeResult();
        if (this.getResult() != null) {
            this.updateStatus((IStatus)new StatusInfo());
        } else {
            this.updateStatus((IStatus)new StatusInfo(4, ""));
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        CheckboxTreeViewer treeViewer = this.createTreeViewer(composite);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(60);
        data.heightHint = this.convertHeightInCharsToPixels(18);
        Tree treeWidget = treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(composite.getFont());
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.fExisting != null) {
            Object[] existing = this.fExisting.toArray();
            treeViewer.setGrayedElements(existing);
            this.setInitialSelections(existing);
        }
        if (this.fFocusElement != null) {
            treeViewer.setSelection((ISelection)new StructuredSelection(this.fFocusElement), true);
        }
        treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SelectionDialog.this.forceExistingChecked(event);
            }
        });
        SelectionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void forceExistingChecked(CheckStateChangedEvent event) {
        Object elem;
        if (this.fExisting != null && this.fExisting.contains(elem = event.getElement())) {
            this.fViewer.setChecked(elem, true);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void setInitialFocus(Object focusElement) {
        this.fFocusElement = focusElement;
    }
}

