/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.actions;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class OpenModelElementWithMenu
extends ContributionItem {
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    private IWorkbenchPage page;
    private IAdaptable element;
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    private static Hashtable imageCache = new Hashtable(11);
    public static final String ID = "org.eclipse.ui.OpenWithMenu";
    private static final int MATCH_BOTH = 3;
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object arg0, Object arg1) {
            String s1 = ((IEditorDescriptor)arg0).getLabel();
            String s2 = ((IEditorDescriptor)arg1).getLabel();
            return this.collator.compare(s1, s2);
        }
    };

    public OpenModelElementWithMenu(IWorkbenchPage page) {
        this(page, null);
    }

    public OpenModelElementWithMenu(IWorkbenchPage page, IAdaptable element) {
        super(ID);
        this.page = page;
        this.element = element;
    }

    private Image getImage(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = this.getImageDescriptor(editorDesc);
        if (imageDesc == null) {
            return null;
        }
        Image image = (Image)imageCache.get(imageDesc);
        if (image == null) {
            image = imageDesc.createImage();
            imageCache.put(imageDesc, image);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = null;
        imageDesc = editorDesc == null ? this.registry.getImageDescriptor(this.getFileResource().getName()) : editorDesc.getImageDescriptor();
        if (imageDesc == null && editorDesc.getId().equals("org.eclipse.ui.systemExternalEditor")) {
            imageDesc = this.registry.getSystemExternalEditorImageDescriptor(this.getFileResource().getName());
        }
        return imageDesc;
    }

    private void createMenuItem(Menu menu, final IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean isPreferred = preferredEditor != null && descriptor.getId().equals(preferredEditor.getId());
        menuItem.setSelection(isPreferred);
        menuItem.setText(descriptor.getLabel());
        Image image = this.getImage(descriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        OpenModelElementWithMenu.this.openEditor(descriptor);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    IEditorDescriptor getDefaultEditor() {
        String editorId;
        IDLTKUILanguageToolkit toolkit;
        IEditorDescriptor desc = null;
        IModelElement elem = this.getModelElement();
        if (elem != null && (toolkit = DLTKUILanguageManager.getLanguageToolkit(elem)) != null && (editorId = toolkit.getEditorId(elem)) != null) {
            desc = this.registry.findEditor(editorId);
        }
        if (desc != null) {
            return desc;
        }
        IFile file = this.getFileResource();
        if (file != null) {
            return IDE.getDefaultEditor((IFile)file);
        }
        return null;
    }

    public void fill(Menu menu, int index) {
        IFile file = this.getFileResource();
        if (file == null) {
            return;
        }
        IEditorDescriptor defaultEditor = this.registry.findEditor(DEFAULT_TEXT_EDITOR_ID);
        IEditorDescriptor preferredEditor = this.getDefaultEditor();
        IEditorDescriptor[] editors = this.registry.getEditors(file.getName(), IDE.getContentType((IFile)file));
        Collections.sort(Arrays.asList(editors), comparer);
        boolean defaultFound = false;
        ArrayList<IEditorDescriptor> alreadyMapped = new ArrayList<IEditorDescriptor>();
        if (preferredEditor != null) {
            this.createMenuItem(menu, preferredEditor, preferredEditor);
            if (defaultEditor != null && preferredEditor.getId().equals(defaultEditor.getId())) {
                defaultFound = true;
            }
            alreadyMapped.add(preferredEditor);
        }
        int i = 0;
        while (i < editors.length) {
            IEditorDescriptor editor = editors[i];
            if (!alreadyMapped.contains(editor)) {
                this.createMenuItem(menu, editor, preferredEditor);
                if (defaultEditor != null && editor.getId().equals(defaultEditor.getId())) {
                    defaultFound = true;
                }
                alreadyMapped.add(editor);
            }
            ++i;
        }
        if (editors.length > 0) {
            new MenuItem(menu, 2);
        }
        if (!defaultFound && defaultEditor != null) {
            this.createMenuItem(menu, defaultEditor, preferredEditor);
        }
        IEditorDescriptor descriptor = this.registry.findEditor("org.eclipse.ui.systemExternalEditor");
        this.createMenuItem(menu, descriptor, preferredEditor);
        this.createDefaultMenuItem(menu, file);
    }

    private IModelElement getModelElement() {
        if (this.element instanceof IModelElement) {
            return (IModelElement)this.element;
        }
        return null;
    }

    private IFile getFileResource() {
        IResource resource = (IResource)this.element.getAdapter(IResource.class);
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public boolean isDynamic() {
        return true;
    }

    private void openEditor(IEditorDescriptor editor) {
        block3: {
            IFile file = this.getFileResource();
            if (file == null) {
                return;
            }
            try {
                String editorId = editor == null ? "org.eclipse.ui.systemExternalEditor" : editor.getId();
                this.page.openEditor((IEditorInput)new FileEditorInput(file), editorId, true, 3);
                IDE.setDefaultEditor((IFile)file, (String)editorId);
            }
            catch (PartInitException e) {
                if (!DLTKCore.DEBUG) break block3;
                e.printStackTrace();
            }
        }
    }

    private void createDefaultMenuItem(Menu menu, final IFile file) {
        IEditorDescriptor desc = this.getDefaultEditor();
        if (desc == null) {
            return;
        }
        final MenuItem menuItem = new MenuItem(menu, 16);
        menuItem.setSelection(desc == null);
        menuItem.setText(ActionMessages.DefaultEditorDescription_name);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        IDE.setDefaultEditor((IFile)file, null);
                        try {
                            IEditorDescriptor desc = IDE.getEditorDescriptor((IFile)file);
                            OpenModelElementWithMenu.this.page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId(), true, 3);
                            break;
                        }
                        catch (PartInitException e) {
                            if (!DLTKCore.DEBUG) break;
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }
}

