/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.console;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.dltk.console.ConsoleRequest;
import org.eclipse.dltk.console.ScriptConsoleServer;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.internal.launching.execution.DeploymentManager;
import org.eclipse.dltk.launching.ScriptLaunchUtil;
import org.eclipse.dltk.tcl.console.TclInterpreter;
import org.eclipse.dltk.tcl.launching.TclLaunchingPlugin;

public class TclConsoleUtil {
    public static ILaunch runDefaultTclInterpreter(TclInterpreter interpreter) throws CoreException, IOException {
        ScriptConsoleServer server = ScriptConsoleServer.getInstance();
        String id = server.register((ConsoleRequest)interpreter);
        String port = Integer.toString(server.getPort());
        String[] args = new String[]{DLTKDebugPlugin.getDefault().getBindAddress(), port, id};
        IExecutionEnvironment exeEnv = (IExecutionEnvironment)EnvironmentManager.getLocalEnvironment().getAdapter(IExecutionEnvironment.class);
        IDeployment deployment = exeEnv.createDeployment();
        IPath path = deployment.add(TclLaunchingPlugin.getDefault().getBundle(), TclLaunchingPlugin.getDefault().getConsoleProxy());
        IFileHandle scriptFile = deployment.getFile(path);
        final ILaunch launch = ScriptLaunchUtil.runScript((String)"org.eclipse.dltk.tcl.core.nature", (IFileHandle)scriptFile, null, null, (String[])args, null);
        DeploymentManager.getInstance().addDeployment(launch, deployment);
        if (launch != null) {
            interpreter.addCloseOperation(new Runnable(){

                public void run() {
                    IProcess[] processes = launch.getProcesses();
                    if (processes != null) {
                        int i = 0;
                        while (i < processes.length) {
                            block4: {
                                try {
                                    processes[i].terminate();
                                }
                                catch (DebugException e) {
                                    if (!DLTKCore.DEBUG) break block4;
                                    e.printStackTrace();
                                }
                            }
                            ++i;
                        }
                    }
                }
            });
        }
        return launch;
    }
}

