/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.browsing.ext;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.ui.actions.BuildActionGroup;
import org.eclipse.dltk.internal.ui.actions.CCPActionGroup;
import org.eclipse.dltk.internal.ui.actions.CompositeActionGroup;
import org.eclipse.dltk.internal.ui.actions.ImportActionGroup;
import org.eclipse.dltk.internal.ui.actions.NewWizardsActionGroup;
import org.eclipse.dltk.internal.ui.actions.refactoring.RefactorActionGroup;
import org.eclipse.dltk.internal.ui.search.SearchUtil;
import org.eclipse.dltk.ui.DLTKExecuteExtensionHelper;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ModelElementSorter;
import org.eclipse.dltk.ui.actions.OpenEditorActionGroup;
import org.eclipse.dltk.ui.actions.OpenViewActionGroup;
import org.eclipse.dltk.ui.actions.SearchActionGroup;
import org.eclipse.dltk.ui.browsing.ScriptElementTypeComparator;
import org.eclipse.dltk.ui.browsing.ext.ExtendedClasesContentProvider;
import org.eclipse.dltk.ui.browsing.ext.ExtendedClasesLabelProvider;
import org.eclipse.dltk.ui.browsing.ext.MixedClass;
import org.eclipse.dltk.ui.browsing.ext.MultiSelectionListViewer;
import org.eclipse.dltk.ui.infoviews.AbstractInfoView;
import org.eclipse.dltk.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.ViewPart;

public class ExtendedClassesView
extends ViewPart
implements IViewPartInputProvider,
ISelectionListener,
ISelectionProvider,
IExecutableExtension,
IMenuListener {
    private OpenEditorActionGroup fOpenEditorGroup;
    private CCPActionGroup fCCPActionGroup;
    private BuildActionGroup fBuildActionGroup;
    protected CompositeActionGroup fActionGroups;
    private MultiSelectionListViewer browsingPane;
    protected IWorkbenchPart fPreviousSelectionProvider;
    protected Object fPreviousSelectedElement;
    private ScriptElementTypeComparator fTypeComparator;
    private boolean fProcessSelectionEvents = true;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref != null && ref.getId() == ExtendedClassesView.this.getSite().getId()) {
                ExtendedClassesView.this.fProcessSelectionEvents = true;
                IWorkbenchPage page = ExtendedClassesView.this.getSite().getWorkbenchWindow().getActivePage();
                if (page != null) {
                    ExtendedClassesView.this.selectionChanged(page.getActivePart(), page.getSelection());
                }
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (ref != null && ref.getId() == ExtendedClassesView.this.getSite().getId()) {
                ExtendedClassesView.this.fProcessSelectionEvents = false;
            }
        }
    };
    ListenerList listenerList = new ListenerList();
    private IDLTKLanguageToolkit fToolkit;
    private IElementChangedListenerImplementation elementChangedListenerImplementation = new IElementChangedListenerImplementation();
    static /* synthetic */ Class class$0;

    public ExtendedClassesView() {
        DLTKCore.addElementChangedListener((IElementChangedListener)this.elementChangedListenerImplementation);
    }

    public void dispose() {
        super.dispose();
        DLTKCore.removeElementChangedListener((IElementChangedListener)this.elementChangedListenerImplementation);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.browsingPane = new MultiSelectionListViewer(parent, 0){

            public void elementSelectionChanged(ISelection selection) {
                Object[] listeners = ExtendedClassesView.this.listenerList.getListeners();
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)ExtendedClassesView.this, ExtendedClassesView.this.convertSelection(selection));
                int i = 0;
                while (i < listeners.length) {
                    ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
                    ++i;
                }
            }

            protected void configureViewer(TreeViewer viewer) {
                viewer.setUseHashlookup(true);
                viewer.setSorter((ViewerSorter)new ModelElementSorter(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        e1 = this.unWrap(e1);
                        e2 = this.unWrap(e2);
                        return super.compare(viewer, e1, e2);
                    }

                    private Object unWrap(Object e1) {
                        MixedClass cl;
                        if (e1 instanceof MixedClass && (cl = (MixedClass)e1).getElements().size() > 0) {
                            e1 = cl.getElements().get(0);
                        }
                        return e1;
                    }

                    protected String getElementName(Object element) {
                        element = this.unWrap(element);
                        return super.getElementName(element);
                    }

                    public int category(Object element) {
                        return super.category(this.unWrap(element));
                    }
                });
                ExtendedClassesView.this.createContextMenu(viewer.getControl());
            }
        };
        this.browsingPane.setContentProvider(new ExtendedClasesContentProvider(this, SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)this.fToolkit), parent, this.fToolkit));
        this.browsingPane.setLabelProvider(new ExtendedClasesLabelProvider(DLTKUILanguageManager.createLabelProvider(this.fToolkit.getNatureId())));
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.getViewSite().getPage().addPostSelectionListener((ISelectionListener)this);
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.createActions();
    }

    protected void createActions() {
        ActionGroup[] actionGroupArray = new ActionGroup[8];
        actionGroupArray[0] = new NewWizardsActionGroup((IWorkbenchSite)this.getSite());
        this.fOpenEditorGroup = new OpenEditorActionGroup((IViewPart)this);
        actionGroupArray[1] = this.fOpenEditorGroup;
        actionGroupArray[2] = new OpenViewActionGroup((IViewPart)this);
        this.fCCPActionGroup = new CCPActionGroup((IViewPart)this);
        actionGroupArray[3] = this.fCCPActionGroup;
        actionGroupArray[4] = new RefactorActionGroup((IViewPart)this);
        actionGroupArray[5] = new ImportActionGroup((IViewPart)this);
        this.fBuildActionGroup = new BuildActionGroup((IViewPart)this);
        actionGroupArray[6] = this.fBuildActionGroup;
        actionGroupArray[7] = new SearchActionGroup((IViewPart)this, this.fToolkit);
        this.fActionGroups = new CompositeActionGroup(actionGroupArray);
    }

    protected void createContextMenu(Control parent) {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu contextMenu = menuManager.createContextMenu((Control)this.browsingPane);
        parent.setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this);
    }

    protected ISelection convertSelection(ISelection selection) {
        ArrayList result = new ArrayList();
        if (selection instanceof StructuredSelection) {
            StructuredSelection sel = (StructuredSelection)selection;
            List list = sel.toList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o instanceof MixedClass) {
                    List mixedElements = ((MixedClass)o).getElements();
                    result.addAll(mixedElements);
                    continue;
                }
                result.add(o);
            }
        }
        if (result.size() > 0) {
            return new StructuredSelection(result);
        }
        return new StructuredSelection();
    }

    public void setFocus() {
    }

    public Object getViewPartInput() {
        return this.browsingPane.getSelection();
    }

    private boolean isSearchResultView(IWorkbenchPart part) {
        return SearchUtil.isSearchPlugInActivated() && part instanceof ISearchResultViewPart;
    }

    protected boolean needsToProcessSelectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.fProcessSelectionEvents || part == this || this.isSearchResultView(part) || part instanceof AbstractInfoView) {
            if (part == this) {
                this.fPreviousSelectionProvider = part;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final Object getSingleElementFromSelection(ISelection selection) {
        Object element;
        if (!(selection instanceof IStructuredSelection)) return null;
        if (selection.isEmpty()) {
            return null;
        }
        Iterator iter = ((IStructuredSelection)selection).iterator();
        Object e = iter.next();
        if (!(e instanceof IModelElement)) {
            Class<?> clazz;
            IModelElement je;
            void var3_5;
            if (e instanceof IMarker) {
                IResource iResource = ((IMarker)e).getResource();
            }
            if (!(var3_5 instanceof IAdaptable)) return var3_5;
            IAdaptable iAdaptable = (IAdaptable)var3_5;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.dltk.core.IModelElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz2 = class$0 = clazz3;
            }
            if ((je = (IModelElement)iAdaptable.getAdapter((Class)clazz2)) != null) return je;
            if (!(var3_5 instanceof IFile)) return je;
            IContainer parent = ((IFile)var3_5).getParent();
            if (parent == null) return null;
            Class<?> clazz4 = class$0;
            Class<?> clazz5 = clazz4;
            if (clazz4 != null) return parent.getAdapter((Class)clazz5);
            try {
                clazz = Class.forName("org.eclipse.dltk.core.IModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz5 = class$0 = clazz;
            return parent.getAdapter((Class)clazz5);
        }
        Object currentInput = this.browsingPane.getInput();
        new ArrayList();
        if (currentInput == null || !currentInput.equals((IModelElement)e)) {
            if (!iter.hasNext()) return e;
            if (!(selection instanceof StructuredSelection)) return e;
            return ((StructuredSelection)selection).toList();
        }
        do {
            if (!iter.hasNext()) {
                return e;
            }
            element = iter.next();
            if (element instanceof IModelElement) continue;
            return null;
        } while (currentInput.equals((IModelElement)element));
        return null;
    }

    private Comparator getTypeComparator() {
        if (this.fTypeComparator == null) {
            this.fTypeComparator = new ScriptElementTypeComparator();
        }
        return this.fTypeComparator;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.needsToProcessSelectionChanged(part, selection)) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        ArrayList selectedElement = this.getSingleElementFromSelection(selection);
        if (!this.checkElementNature(selectedElement)) {
            return;
        }
        if (selectedElement instanceof List) {
            ArrayList newList = new ArrayList();
            List list = selectedElement;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!this.checkElementNature(obj)) continue;
                newList.add(obj);
            }
            if (newList.size() > 0) {
                selectedElement = newList;
            } else {
                return;
            }
        }
        if (selectedElement != null && (part == null || part.equals(this.fPreviousSelectionProvider)) && ((Object)selectedElement).equals(this.fPreviousSelectedElement)) {
            return;
        }
        this.fPreviousSelectedElement = selectedElement;
        if (selectedElement != null && (selectedElement instanceof IScriptProject || selectedElement instanceof IProjectFragment)) {
            this.browsingPane.setInput(selectedElement);
        }
    }

    private boolean checkElementNature(Object selectedElement) {
        if (selectedElement instanceof IModelElement) {
            String natureId = this.fToolkit.getNatureId();
            IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)((IModelElement)selectedElement));
            if (languageToolkit != null && natureId.equals(languageToolkit.getNatureId())) {
                return true;
            }
        }
        return false;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listenerList.add((Object)listener);
    }

    public ISelection getSelection() {
        return this.convertSelection(this.browsingPane.getSelection());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listenerList.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        super.setInitializationData(config, propertyName, data);
        this.fToolkit = DLTKExecuteExtensionHelper.getLanguageToolkit(config, propertyName, data);
    }

    public void menuAboutToShow(IMenuManager menu) {
        DLTKUIPlugin.createStandardGroups(menu);
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        this.fActionGroups.setContext(new ActionContext((ISelection)selection));
        this.fActionGroups.fillContextMenu(menu);
        this.fActionGroups.setContext(null);
    }

    private final class IElementChangedListenerImplementation
    implements IElementChangedListener {
        private IElementChangedListenerImplementation() {
        }

        public void elementChanged(ElementChangedEvent event) {
            IModelElementDelta delta = event.getDelta();
            if (ExtendedClassesView.this.browsingPane != null && !ExtendedClassesView.this.browsingPane.isDisposed() && this.typesChanged(delta)) {
                ExtendedClassesView.this.browsingPane.refresh();
            }
        }

        private boolean typesChanged(IModelElementDelta delta) {
            IModelElementDelta[] affectedChildren = delta.getAffectedChildren();
            int i = 0;
            while (i < affectedChildren.length) {
                if (affectedChildren[i].getElement().getElementType() == 7) {
                    return true;
                }
                if (this.typesChanged(affectedChildren[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

