/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.internal.ui.actions.OpenModelElementWithMenu;
import org.eclipse.dltk.internal.ui.actions.OpenStorageWithMenu;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.actions.OpenAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenWithMenu;

public class OpenEditorActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private boolean fIsEditorOwner;
    private OpenAction fOpen;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public OpenEditorActionGroup(IViewPart part) {
        this.fSite = part.getSite();
        this.fOpen = new OpenAction(this.fSite);
        this.fOpen.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.open.editor");
        this.initialize(this.fSite.getSelectionProvider());
    }

    public OpenEditorActionGroup(ScriptEditor editor) {
        this.fIsEditorOwner = true;
        this.fOpen = new OpenAction((IEditorPart)editor);
        this.fOpen.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.open.editor");
        editor.setAction("OpenEditor", (IAction)this.fOpen);
        this.fSite = editor.getEditorSite();
        this.initialize(this.fSite.getSelectionProvider());
    }

    public IAction getOpenAction() {
        return this.fOpen;
    }

    private void initialize(ISelectionProvider provider) {
        ISelection selection = provider.getSelection();
        this.fOpen.update(selection);
        if (!this.fIsEditorOwner) {
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fOpen);
        }
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.appendToGroup(menu, (IAction)this.fOpen);
        if (!this.fIsEditorOwner) {
            this.addOpenWithMenu(menu);
        }
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpen);
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("org.eclipse.dltk.ui.actions.Open", (IAction)this.fOpen);
    }

    private void appendToGroup(IMenuManager menu, IAction action) {
        if (action.isEnabled()) {
            menu.appendToGroup("group.open", action);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addOpenWithMenu(IMenuManager menu) {
        Object resource;
        block19: {
            IAdaptable element;
            block18: {
                ISelection selection = this.getContext().getSelection();
                if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                if (ss.size() != 1) {
                    return;
                }
                Object o = ss.getFirstElement();
                if (!(o instanceof IAdaptable)) {
                    return;
                }
                element = (IAdaptable)o;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resource = element.getAdapter((Class)clazz);
                if (element instanceof IStorage && !(resource instanceof IFile)) {
                    MenuManager submenu = new MenuManager(ActionMessages.OpenWithMenu_label);
                    submenu.add((IContributionItem)new OpenStorageWithMenu(this.fSite.getPage(), element));
                    menu.appendToGroup("group.open", (IContributionItem)submenu);
                    return;
                }
                if (element instanceof IModelElement) break block18;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.dltk.core.IModelElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (element.getAdapter((Class)clazz2) == null) break block19;
            }
            MenuManager submenu = new MenuManager(ActionMessages.OpenWithMenu_label);
            IWorkbenchPage iWorkbenchPage = this.fSite.getPage();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.dltk.core.IModelElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            submenu.add((IContributionItem)new OpenModelElementWithMenu(iWorkbenchPage, (IAdaptable)((IModelElement)element.getAdapter((Class)clazz))));
            menu.appendToGroup("group.open", (IContributionItem)submenu);
            return;
        }
        if (!(resource instanceof IFile)) return;
        MenuManager submenu = new MenuManager(ActionMessages.OpenWithMenu_label);
        submenu.add((IContributionItem)new OpenWithMenu(this.fSite.getPage(), (IAdaptable)((IFile)resource)));
        menu.appendToGroup("group.open", (IContributionItem)submenu);
    }
}

