/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ui.tests.dialogs;

import java.util.ArrayList;
import java.util.Hashtable;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.tests.ScriptProjectHelper;
import org.eclipse.dltk.ui.tests.TestOptions;

public class NewProjectTestSetup
extends TestSetup {
    public static final String WORKSPACE_PROJECT = "WorkspaceProject";
    public static final String WORKSPACE_PROJECT_SRC = "WorkspaceProjectWithSourceAndInFolder";
    private IScriptProject fWorkspaceProject;
    private IScriptProject fWorkspaceProjectWithSrc;
    private IScriptProject fExternalProject;
    private boolean fAutobuilding;

    public static IScriptProject getProject(String projectName) throws CoreException {
        return ScriptProjectHelper.createScriptProject((String)projectName);
    }

    public NewProjectTestSetup(Test test) {
        super(test);
        try {
            this.fAutobuilding = ScriptProjectHelper.setAutoBuilding((boolean)false);
        }
        catch (CoreException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    public IScriptProject getProject(IScriptProject currentProject) throws CoreException {
        String name = currentProject.getElementName();
        currentProject.getProject().delete(true, null);
        if (name.equals(WORKSPACE_PROJECT)) {
            return this.getWorkspaceProject();
        }
        if (name.equals(WORKSPACE_PROJECT_SRC)) {
            return this.getWorkspaceProjectWithSrc();
        }
        return null;
    }

    public IScriptProject getWorkspaceProject() {
        try {
            this.fWorkspaceProject = NewProjectTestSetup.getProject(WORKSPACE_PROJECT);
            ArrayList<IBuildpathEntry> cpEntries = new ArrayList<IBuildpathEntry>();
            IPath projectPath = this.fWorkspaceProject.getProject().getFullPath();
            cpEntries.add(DLTKCore.newSourceEntry((IPath)projectPath));
            IBuildpathEntry[] entries = cpEntries.toArray(new IBuildpathEntry[cpEntries.size()]);
            this.fWorkspaceProject.setRawBuildpath(entries, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ModelException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        catch (CoreException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        return this.fWorkspaceProject;
    }

    public IScriptProject getWorkspaceProjectWithSrc() {
        try {
            this.fWorkspaceProjectWithSrc = NewProjectTestSetup.getProject(WORKSPACE_PROJECT_SRC);
            this.createWithSrcAndBinFolder(this.fWorkspaceProjectWithSrc);
        }
        catch (CoreException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        return this.fWorkspaceProjectWithSrc;
    }

    public IScriptProject getExternalProject() throws CoreException {
        return this.fExternalProject;
    }

    protected void setUp() throws Exception {
        super.setUp();
        DLTKCore.setOptions((Hashtable)TestOptions.getDefaultOptions());
        TestOptions.initializeCodeGenerationOptions();
    }

    protected void tearDown() throws Exception {
        if (this.fWorkspaceProject != null && this.fWorkspaceProject.exists()) {
            ScriptProjectHelper.delete((IModelElement)this.fWorkspaceProject);
        }
        if (this.fWorkspaceProjectWithSrc != null && this.fWorkspaceProjectWithSrc.exists()) {
            ScriptProjectHelper.delete((IModelElement)this.fWorkspaceProjectWithSrc);
        }
        if (this.fExternalProject != null && this.fExternalProject.exists()) {
            ScriptProjectHelper.delete((IModelElement)this.fExternalProject);
        }
        ScriptProjectHelper.setAutoBuilding((boolean)this.fAutobuilding);
    }

    private void createWithSrcAndBinFolder(IScriptProject project) {
        Path srcPath = new Path("src");
        try {
            if (srcPath.segmentCount() > 0) {
                IFolder folder = project.getProject().getFolder((IPath)srcPath);
                CoreUtility.createFolder((IFolder)folder, (boolean)true, (boolean)true, null);
            }
            IPath projectPath = project.getProject().getFullPath();
            ArrayList<IBuildpathEntry> cpEntries = new ArrayList<IBuildpathEntry>();
            cpEntries.add(DLTKCore.newSourceEntry((IPath)projectPath.append((IPath)srcPath)));
            IBuildpathEntry[] entries = cpEntries.toArray(new IBuildpathEntry[cpEntries.size()]);
            project.setRawBuildpath(entries, null);
        }
        catch (CoreException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }
}

