/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.activestatedebugger;

import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.ExternalDebuggingEngineRunner;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.debug.DbgpInterpreterConfig;

public class RubyActiveStateDebuggerRunner
extends ExternalDebuggingEngineRunner {
    public static final String ENGINE_ID = "org.eclipse.dltk.ruby.activestatedebugger";

    public RubyActiveStateDebuggerRunner(IInterpreterInstall install) {
        super(install);
    }

    protected InterpreterConfig alterConfig(InterpreterConfig config, PreferencesLookupDelegate delegate) {
        IFileHandle debugEnginePath = this.getDebuggingEnginePath(delegate);
        DbgpInterpreterConfig dbgpConfig = new DbgpInterpreterConfig(config);
        String host = dbgpConfig.getHost();
        int port = dbgpConfig.getPort();
        String sessionId = dbgpConfig.getSessionId();
        String dir = debugEnginePath.getParent().toString();
        config.addEnvVar("RUBYDB_OPTS", "RemotePort=" + host + ":" + port);
        config.addEnvVar("DBGP_IDEKEY", sessionId);
        config.addInterpreterArg("-I");
        config.addInterpreterArg(dir);
        config.addInterpreterArg("-r");
        config.addInterpreterArg(debugEnginePath.toOSString());
        return config;
    }

    protected String getDebuggingEngineId() {
        return ENGINE_ID;
    }

    protected String getDebuggingEnginePreferenceKey() {
        return "debugging_engine_path";
    }

    protected String getDebuggingEnginePreferenceQualifier() {
        return ENGINE_ID;
    }

    protected String getDebugPreferenceQualifier() {
        return "org.eclipse.dltk.ruby.debug";
    }

    protected String getLoggingEnabledPreferenceKey() {
        return "enable_logging";
    }

    protected String getLogFileNamePreferenceKey() {
        return "log_file_name";
    }

    protected String getLogFilePathPreferenceKey() {
        return "log_file_path";
    }
}

