/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.dbgp.tests.service;

import java.io.IOException;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.IDbgpThreadAcceptor;
import org.eclipse.dltk.debug.dbgp.tests.service.AbstractDbgpAcceptor;
import org.eclipse.dltk.debug.dbgp.tests.service.AbstractDbgpServiceTests;
import org.eclipse.dltk.debug.dbgp.tests.service.SendPacketOperation;
import org.eclipse.dltk.debug.dbgp.tests.service.TestInitPacket;
import org.eclipse.dltk.internal.debug.core.model.DbgpService;

public class DbgpServiceDispatcherTests
extends AbstractDbgpServiceTests {
    private static final String IDE1 = "IDE001";
    private static final String IDE2 = "IDE002";
    private static final String IDE3 = "IDE003";
    private static final int COUNT1 = 10;
    private static final int COUNT2 = 20;
    private static final int COUNT3 = 5;
    volatile int count1;
    volatile int count2;

    protected void setUp() throws Exception {
        super.setUp();
        this.count1 = 0;
        this.count2 = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testInitPacketParser() throws IOException {
        DbgpService service = this.createService(-1);
        try {
            byte[] packet;
            service.registerAcceptor(IDE1, (IDbgpThreadAcceptor)new AbstractDbgpAcceptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void acceptDbgpThread(IDbgpSession session) {
                    DbgpServiceDispatcherTests dbgpServiceDispatcherTests = DbgpServiceDispatcherTests.this;
                    synchronized (dbgpServiceDispatcherTests) {
                        ++DbgpServiceDispatcherTests.this.count1;
                    }
                }
            });
            service.registerAcceptor(IDE2, (IDbgpThreadAcceptor)new AbstractDbgpAcceptor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void acceptDbgpThread(IDbgpSession session) {
                    DbgpServiceDispatcherTests dbgpServiceDispatcherTests = DbgpServiceDispatcherTests.this;
                    synchronized (dbgpServiceDispatcherTests) {
                        ++DbgpServiceDispatcherTests.this.count2;
                    }
                }
            });
            int i = 0;
            while (i < 10) {
                packet = TestInitPacket.build(IDE1);
                DbgpServiceDispatcherTests.assertNotNull((Object)packet);
                this.performOperation(service.getPort(), new SendPacketOperation(packet));
                ++i;
            }
            i = 0;
            while (i < 20) {
                packet = TestInitPacket.build(IDE2);
                DbgpServiceDispatcherTests.assertNotNull((Object)packet);
                this.performOperation(service.getPort(), new SendPacketOperation(packet));
                ++i;
            }
            i = 0;
            while (i < 5) {
                packet = TestInitPacket.build(IDE3);
                DbgpServiceDispatcherTests.assertNotNull((Object)packet);
                this.performOperation(service.getPort(), new SendPacketOperation(packet));
                ++i;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            service.shutdown();
            throw throwable;
        }
        service.shutdown();
        DbgpServiceDispatcherTests.assertEquals((int)10, (int)this.count1);
        DbgpServiceDispatcherTests.assertEquals((int)20, (int)this.count2);
    }
}

