/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.console;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.console.ConsoleRequest;
import org.eclipse.dltk.console.IScriptConsoleIO;
import org.eclipse.dltk.console.IScriptInterpreter;
import org.eclipse.dltk.console.InterpreterResponse;
import org.eclipse.dltk.console.ShellResponse;

public class TclInterpreter
implements IScriptInterpreter,
ConsoleRequest {
    private static final String COMPLETE_COMMAND = "complete";
    private static final String DESCRIBE_COMMAND = "describe";
    private static final String CLOSE_COMMAND = "close";
    private IScriptConsoleIO protocol;
    private String content;
    private int state;
    private List closeRunnables = new ArrayList();
    private List initialListeners = new ArrayList();

    public void exec(String command) throws IOException {
        InterpreterResponse response = this.protocol.execInterpreter(command);
        this.content = response.getContent();
        this.state = response.getState();
    }

    public boolean isValid() {
        return this.protocol != null;
    }

    public String getOutput() {
        return this.content;
    }

    public int getState() {
        return this.state;
    }

    public List getCompletions(String commandLine, int position) throws IOException {
        String[] args = new String[]{commandLine, Integer.toString(position)};
        ShellResponse response = this.protocol.execShell(COMPLETE_COMMAND, args);
        return response.getCompletions();
    }

    public String getDescription(String commandLine, int position) throws IOException {
        String[] args = new String[]{commandLine, Integer.toString(position)};
        ShellResponse response = this.protocol.execShell(DESCRIBE_COMMAND, args);
        return response.getDescription();
    }

    public String[] getNames(String type) throws IOException {
        return null;
    }

    public void close() throws IOException {
        try {
            if (this.protocol != null) {
                this.protocol.execShell(CLOSE_COMMAND, new String[0]);
                this.protocol.close();
            }
            Iterator iterator = this.closeRunnables.iterator();
            while (iterator.hasNext()) {
                Runnable op = (Runnable)iterator.next();
                op.run();
            }
        }
        catch (SocketException socketException) {}
    }

    public void consoleConnected(IScriptConsoleIO protocol) {
        this.protocol = protocol;
        Iterator iterator = this.initialListeners.iterator();
        while (iterator.hasNext()) {
            Runnable op = (Runnable)iterator.next();
            Thread t = new Thread(op);
            t.run();
        }
        this.initialListeners.clear();
    }

    public void addCloseOperation(Runnable runnable) {
        this.closeRunnables.add(runnable);
    }

    public void addInitialListenerOperation(Runnable runnable) {
        if (this.protocol != null) {
            new Thread(runnable).start();
        } else {
            this.initialListeners.add(runnable);
        }
    }

    public InputStream getInitialOutputStream() {
        return this.protocol.getInitialResponseStream();
    }
}

