/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.debug;

import org.eclipse.dltk.debug.core.model.AtomicScriptType;
import org.eclipse.dltk.debug.core.model.CollectionScriptType;
import org.eclipse.dltk.debug.core.model.ComplexScriptType;
import org.eclipse.dltk.debug.core.model.IScriptType;
import org.eclipse.dltk.debug.core.model.IScriptTypeFactory;
import org.eclipse.dltk.debug.core.model.StringScriptType;

public class RubyTypeFactory
implements IScriptTypeFactory {
    private static final String[] atomicTypes = new String[]{"Bignum", "FalseClass", "Fixnum", "Float", "Integer", "NilClass", "Numeric", "Range", "Regexp", "String", "Symbol", "TrueClass"};
    private static final String[] collectionTypes = new String[]{"Array", "Hash", "Set"};

    public IScriptType buildType(String type) {
        if ("String".equals(type)) {
            return new StringScriptType(type);
        }
        int i = 0;
        while (i < atomicTypes.length) {
            if (atomicTypes[i].equals(type)) {
                return new AtomicScriptType(type);
            }
            ++i;
        }
        i = 0;
        while (i < collectionTypes.length) {
            if (collectionTypes[i].equals(type)) {
                return new CollectionScriptType(type);
            }
            ++i;
        }
        return new ComplexScriptType(type);
    }
}

