/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.codeassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.codeassist.complete.CompletionNodeFound;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.compiler.env.lookup.Scope;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.CompletionContext;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.CompletionOnKeywordOrFunction;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.CompletionOnVariable;
import org.eclipse.dltk.tcl.internal.core.codeassist.completion.TclCompletionParser;
import org.eclipse.dltk.tcl.internal.parser.TclParseUtils;

public class TclCompletionEngine
extends ScriptCompletionEngine {
    private TclCompletionParser parser = new TclCompletionParser();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void complete(ISourceModule sourceModule, int completionPosition, int pos) {
        block16: {
            if (DEBUG) {
                System.out.print("COMPLETION IN ");
                System.out.print(sourceModule.getFileName());
                System.out.print(" AT POSITION ");
                System.out.println(completionPosition);
                System.out.println("COMPLETION - Source :");
                System.out.println(sourceModule.getSourceContents());
            }
            this.requestor.beginReporting();
            boolean contextAccepted = false;
            try {
                block15: {
                    this.fileName = sourceModule.getFileName();
                    this.actualCompletionPosition = completionPosition;
                    this.offset = pos;
                    ModuleDeclaration parsedUnit = this.parser.parse(sourceModule);
                    if (parsedUnit != null) {
                        if (DEBUG) {
                            System.out.println("COMPLETION - Diet AST :");
                            System.out.println(parsedUnit.toString());
                        }
                        try {
                            this.lookupEnvironment.buildTypeScope(parsedUnit, null);
                            this.unitScope = parsedUnit.scope;
                            if (this.unitScope == null) break block15;
                            this.source = sourceModule.getSourceContents().toCharArray();
                            this.parseBlockStatements(parsedUnit, this.actualCompletionPosition);
                            if (DEBUG) {
                                System.out.println("COMPLETION - AST :");
                                System.out.println(parsedUnit.toString());
                            }
                        }
                        catch (CompletionNodeFound e) {
                            if (e.astNode == null) break block15;
                            if (DEBUG) {
                                System.out.print("COMPLETION - Completion node : ");
                                System.out.println(e.astNode.toString());
                                if (this.parser.getAssistNodeParent() != null) {
                                    System.out.print("COMPLETION - Parent Node : ");
                                    System.out.println(this.parser.getAssistNodeParent());
                                }
                            }
                            contextAccepted = this.complete(e.astNode, this.parser.getAssistNodeParent(), e.scope, e.insideTypeAnnotation);
                        }
                    }
                }
                if (this.noProposal && this.problem != null) {
                    if (!contextAccepted) {
                        contextAccepted = true;
                        CompletionContext context = new CompletionContext();
                        context.setOffset(completionPosition);
                        context.setTokenKind(0);
                        this.requestor.acceptContext(context);
                    }
                    this.requestor.completionFailure((IProblem)this.problem);
                    if (DEBUG) {
                        this.printDebug(this.problem);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (!contextAccepted) {
                    contextAccepted = true;
                    CompletionContext context = new CompletionContext();
                    context.setTokenKind(0);
                    context.setOffset(completionPosition);
                    this.requestor.acceptContext(context);
                }
                this.requestor.endReporting();
                throw throwable;
            }
            {
                Object var7_10 = null;
                if (contextAccepted) break block16;
                contextAccepted = true;
            }
            CompletionContext context = new CompletionContext();
            context.setTokenKind(0);
            context.setOffset(completionPosition);
            this.requestor.acceptContext(context);
        }
        this.requestor.endReporting();
    }

    private boolean complete(ASTNode astNode, ASTNode astNodeParent, Scope scope, boolean insideTypeAnnotation) {
        this.setSourceRange(astNode.sourceStart(), astNode.sourceEnd());
        if (astNode instanceof CompletionOnKeywordOrFunction) {
            CompletionOnKeywordOrFunction key = (CompletionOnKeywordOrFunction)astNode;
            if (!this.requestor.isIgnored(2)) {
                String[] kw = key.getPossibleKeywords();
                char[][] choices = new char[kw.length][];
                boolean add = false;
                char[] token = key.getToken();
                if (token != null && token.length > 0 && token[0] == ':') {
                    add = true;
                }
                int i = 0;
                while (i < kw.length) {
                    choices[i] = add ? ("::" + kw[i]).toCharArray() : kw[i].toCharArray();
                    ++i;
                }
                this.findKeywords(key.getToken(), choices, key.canCompleteEmptyToken());
            }
            if (!this.requestor.isIgnored(6)) {
                ArrayList methodNames = new ArrayList();
                this.findLocalFunctions(key.getToken(), key.canCompleteEmptyToken(), astNodeParent, methodNames);
                char[] token = key.getToken();
                token = this.removeLastColonFromToken(token);
                this.findNamespaceFunctions(token, methodNames);
            }
        } else if (astNode instanceof CompletionOnVariable && !this.requestor.isIgnored(4) && !this.requestor.isIgnored(8)) {
            CompletionOnVariable completion = (CompletionOnVariable)astNode;
            this.findVariables(completion.getToken(), completion.getInNode(), completion.canHandleEmpty(), astNode.sourceStart(), completion.getProvideDollar(), null);
        }
        return true;
    }

    private char[] removeLastColonFromToken(char[] token) {
        if (token.length > 2 && token[token.length - 1] == ':' && token[token.length - 2] != ':') {
            char[] co2 = new char[token.length - 1];
            System.arraycopy(token, 0, co2, 0, co2.length);
            token = co2;
        }
        return token;
    }

    private void findNamespaceFunctions(char[] token, final List methodNames) {
        final ArrayList methods = new ArrayList();
        final ArrayList types = new ArrayList();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (element instanceof IType) {
                    IType type = (IType)element;
                    if (!(type.getParent() instanceof ISourceModule)) {
                        return;
                    }
                    String tName = type.getTypeQualifiedName();
                    if (!methodNames.contains(tName)) {
                        types.add(type);
                    }
                    this.processTypeFunctions(methodNames, methods, type);
                } else if (element instanceof IMethod) {
                    IMethod method = (IMethod)element;
                    if (method.getParent() instanceof IType) {
                        return;
                    }
                    String mn = method.getTypeQualifiedName("$", false).replaceAll("\\$", "::");
                    if (!mn.startsWith("::")) {
                        mn = "::" + mn;
                    }
                    if (!methodNames.contains(mn) && !methodNames.contains(mn.substring(2))) {
                        methods.add(method);
                        methodNames.add(mn);
                    }
                }
            }

            private void processTypeFunctions(List methodNames2, List methods2, IType type) throws ModelException {
                IMethod[] tmethods = type.getMethods();
                int i = 0;
                while (i < tmethods.length) {
                    String mn = tmethods[i].getTypeQualifiedName("$", false).replaceAll("\\$", "::");
                    if (!(methodNames2.contains(mn) || (!mn.startsWith("::") ? methodNames2.contains("::" + mn) : methodNames2.contains(mn.substring(2))) || methodNames2.contains(mn))) {
                        methods2.add(tmethods[i]);
                        methodNames2.add(mn);
                    }
                    ++i;
                }
                IType[] types2 = type.getTypes();
                int i2 = 0;
                while (i2 < types2.length) {
                    this.processTypeFunctions(methodNames2, methods2, types2[i2]);
                    ++i2;
                }
            }
        };
        IDLTKLanguageToolkit toolkit = null;
        try {
            toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)this.scriptProject);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit);
        String to = new String(token);
        if (token != null && token.length >= 3 && token[0] == ':') {
            String[] tokens = to.split("::");
            if (tokens.length < 2) {
                return;
            }
            String tok = tokens[1];
            try {
                this.search(String.valueOf(tok) + "*", 0, 0, scope, requestor);
                int nonNoneCount = 0;
                String mtok = null;
                int i = 0;
                while (i < tokens.length) {
                    if (tokens[i].length() > 0) {
                        ++nonNoneCount;
                        if (mtok == null) {
                            mtok = tokens[i];
                        }
                    }
                    ++i;
                }
                if (nonNoneCount == 1 && tok.length() >= 2) {
                    this.search(String.valueOf(new String(mtok)) + "*", 1, 0, scope, requestor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (token != null && token.length >= 1 && token[0] != ':') {
            try {
                String[] tokens = to.split("::");
                if (tokens.length == 0) {
                    return;
                }
                String tok = tokens[0];
                this.search(String.valueOf(tok) + "*", 0, 0, scope, requestor);
                int nonNoneCount = 0;
                int i = 0;
                while (i < tokens.length) {
                    if (tokens[i].length() > 0) {
                        ++nonNoneCount;
                    }
                    ++i;
                }
                if (nonNoneCount == 1 && tok.length() >= 2) {
                    this.search(String.valueOf(tok) + "*", 1, 0, scope, requestor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        this.findTypes(token, true, types);
        this.findMethods(token, false, methods);
    }

    protected void search(String patternString, int searchFor, int limitTo, IDLTKSearchScope scope, SearchRequestor resultCollector) throws CoreException {
        this.search(patternString, searchFor, limitTo, EXACT_RULE, scope, resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo, int matchRule, IDLTKSearchScope scope, SearchRequestor requestor) throws CoreException {
        if (patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1) {
            matchRule |= 2;
        }
        SearchPattern pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule);
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    private void findLocalFunctions(char[] token, boolean canCompleteEmptyToken, ASTNode astNodeParent, List methodNames) {
        token = this.removeLastColonFromToken(token);
        ArrayList methods = new ArrayList();
        this.fillFunctionsByLevels(token, astNodeParent, methods, methodNames);
        if (methods.size() > 0) {
            this.findLocalMethods(token, canCompleteEmptyToken, methods, methodNames);
        }
    }

    private void fillFunctionsByLevels(char[] token, ASTNode parent, List methods, List gmethodNames) {
        List levels = this.parser.findLevelsTo(parent);
        int len = levels.size();
        ArrayList visited = new ArrayList();
        ArrayList methodNames = new ArrayList();
        int j = 0;
        while (j < len) {
            List statements;
            TypeDeclaration decl;
            ASTNode astNodeParent = (ASTNode)levels.get(len - 1 - j);
            boolean topLevel = false;
            if (token != null && token.length > 0 && token[0] == ':') {
                topLevel = true;
            }
            if (astNodeParent instanceof TypeDeclaration && !topLevel) {
                decl = (TypeDeclaration)astNodeParent;
                statements = decl.getStatements();
                if (statements != null) {
                    this.processMethods(methods, methodNames, statements, "", visited, parent);
                }
            } else if (astNodeParent instanceof ModuleDeclaration && (statements = (decl = (ModuleDeclaration)astNodeParent).getStatements()) != null) {
                this.processMethods(methods, methodNames, statements, topLevel ? "::" : "", visited, parent);
            }
            ++j;
        }
        gmethodNames.addAll(methodNames);
    }

    private void processMethods(List methods, List methodNames, List statements, String namePrefix, List visited, ASTNode realParent) {
        int i = 0;
        while (i < statements.size()) {
            String prefix;
            String name;
            ASTNode nde = (ASTNode)statements.get(i);
            if (nde instanceof MethodDeclaration) {
                String mName = ((MethodDeclaration)nde).getName();
                if (!mName.startsWith("::")) {
                    mName = String.valueOf(namePrefix) + mName;
                }
                if (realParent instanceof MethodDeclaration) {
                    name = ((MethodDeclaration)realParent).getName();
                    prefix = String.valueOf(namePrefix) + ((MethodDeclaration)nde).getName();
                    if (name.startsWith("::") && !prefix.startsWith("::")) {
                        prefix = "::" + prefix;
                    }
                    if (!name.equals(prefix)) {
                        String nn;
                        String p2;
                        String p1;
                        int i1 = name.lastIndexOf("::");
                        int i2 = prefix.lastIndexOf("::");
                        if (i1 != -1 && i2 != -1 && (p1 = name.substring(0, i1)).startsWith(p2 = prefix.substring(0, i2)) && !methodNames.contains(nn = prefix.substring(i2 + 2))) {
                            methods.add(nde);
                            methodNames.add(nn);
                        }
                    }
                }
                if (!methodNames.contains(mName)) {
                    methods.add(nde);
                    methodNames.add(mName);
                }
            } else if (nde instanceof TypeDeclaration && !visited.contains(nde)) {
                String nn;
                List tStatements = ((TypeDeclaration)nde).getStatements();
                visited.add(nde);
                if (realParent instanceof MethodDeclaration) {
                    name = ((MethodDeclaration)realParent).getName();
                    prefix = String.valueOf(namePrefix) + ((TypeDeclaration)nde).getName();
                    if (name.startsWith("::") && !prefix.startsWith("::")) {
                        prefix = "::" + prefix;
                    }
                    if (name.startsWith(namePrefix)) {
                        this.processMethods2(methods, methodNames, tStatements, "", realParent);
                    }
                }
                if ((nn = ((TypeDeclaration)nde).getName()).startsWith("::")) {
                    nn = nn.substring(2);
                }
                String pr = String.valueOf(namePrefix) + nn;
                this.processMethods(methods, methodNames, tStatements, String.valueOf(pr) + "::", visited, realParent);
            }
            visited.add(nde);
            ++i;
        }
    }

    private void processMethods2(List methods, List methodNames, List statements, String namePrefix, ASTNode realParent) {
        int i = 0;
        while (i < statements.size()) {
            ASTNode nde = (ASTNode)statements.get(i);
            if (nde instanceof MethodDeclaration) {
                String mName = String.valueOf(namePrefix) + ((MethodDeclaration)nde).getName();
                if (mName.startsWith("::::")) {
                    mName = mName.substring(2);
                }
                if (!methodNames.contains(mName) && !methods.contains(nde)) {
                    methods.add(nde);
                    methodNames.add(mName);
                }
            } else if (nde instanceof TypeDeclaration) {
                List tStatements = ((TypeDeclaration)nde).getStatements();
                this.processMethods2(methods, methodNames, tStatements, String.valueOf(namePrefix) + ((TypeDeclaration)nde).getName() + "::", realParent);
            }
            ++i;
        }
    }

    private void findVariables(char[] token, ASTNode parent, boolean canCompleteEmptyToken, int beforePosition, boolean provideDollar, List cho) {
        List statements;
        ArrayList choices;
        ArrayList gChoices = new ArrayList();
        if (cho != null) {
            gChoices.addAll(cho);
        }
        if (token.length > 0 && token[0] != '$') {
            provideDollar = false;
        }
        token = this.removeLastColonFromToken(token);
        if (parent instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)parent;
            choices = new ArrayList();
            statements = method.getArguments();
            if (statements != null) {
                int i = 0;
                while (i < statements.size()) {
                    Argument a = (Argument)statements.get(i);
                    if (a != null) {
                        String n = a.getName();
                        this.checkAddVariable(choices, n);
                    }
                    ++i;
                }
            }
            statements = method.getStatements();
            this.checkVariableStatements(beforePosition, choices, statements);
            char[][] cc = new char[choices.size()][];
            int i = 0;
            while (i < choices.size()) {
                cc[i] = ((String)choices.get(i)).toCharArray();
                gChoices.add(choices.get(i));
                ++i;
            }
            this.findLocalVariables(token, cc, canCompleteEmptyToken, provideDollar);
        } else if (parent instanceof ModuleDeclaration) {
            ModuleDeclaration module = (ModuleDeclaration)parent;
            this.checkVariables(token, canCompleteEmptyToken, beforePosition, module.getStatements(), provideDollar, gChoices);
        } else if (parent instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)parent;
            this.checkVariables(token, canCompleteEmptyToken, beforePosition, type.getStatements(), provideDollar, gChoices);
            String prefix = "";
            if (provideDollar) {
                prefix = "$" + prefix;
            }
            statements = type.getStatements();
            int l = 0;
            while (l < statements.size()) {
                this.findASTVariables((ASTNode)statements.get(l), prefix, token, canCompleteEmptyToken, gChoices);
                ++l;
            }
        }
        String prefix = "";
        choices = new ArrayList();
        if (token.length > 0 && (token[0] == ':' || token[0] == '$') || token.length == 0 || token.length > 2 && token[1] == ':') {
            prefix = "::";
            if (provideDollar) {
                prefix = "$" + prefix;
            }
            this.findASTVariables((ASTNode)this.parser.module, prefix, token, canCompleteEmptyToken, choices);
        }
        int i = 0;
        while (i < gChoices.size()) {
            String cc;
            String c = (String)gChoices.get(i);
            if (choices.contains(c)) {
                choices.remove(c);
            }
            if (c.startsWith("$") && choices.contains(cc = c.substring(1))) {
                choices.remove(cc);
            }
            ++i;
        }
        char[][] cc = new char[choices.size()][];
        int i2 = 0;
        while (i2 < choices.size()) {
            cc[i2] = ((String)choices.get(i2)).toCharArray();
            gChoices.add(choices.get(i2));
            ++i2;
        }
        this.findLocalVariables(token, cc, canCompleteEmptyToken, true);
        this.findGlobalVariables(token, gChoices, provideDollar);
        if (!this.checkValidParetNode(parent)) {
            List findLevelsTo = this.parser.findLevelsTo(parent);
            Object realParent = null;
            Iterator iterator = findLevelsTo.iterator();
            while (iterator.hasNext()) {
                ASTNode nde = (ASTNode)iterator.next();
                if (!this.checkValidParetNode(nde)) continue;
                realParent = nde;
            }
            if (realParent != null && !realParent.equals(parent)) {
                this.findVariables(token, (ASTNode)realParent, canCompleteEmptyToken, beforePosition, provideDollar, gChoices);
            }
        }
    }

    private boolean checkValidParetNode(ASTNode parent) {
        return parent instanceof MethodDeclaration || parent instanceof ModuleDeclaration || parent instanceof TypeDeclaration;
    }

    private void findGlobalVariables(char[] token, final List choices, final boolean provideDollar) {
        final ArrayList fields = new ArrayList();
        final ArrayList types = new ArrayList();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                Object element = match.getElement();
                if (element instanceof IType) {
                    IType type = (IType)element;
                    if (!(type.getParent() instanceof ISourceModule)) {
                        return;
                    }
                    String tName = type.getTypeQualifiedName();
                    if (!choices.contains(tName)) {
                        types.add(type);
                    }
                    this.processTypeFields(choices, fields, type);
                } else if (element instanceof IField) {
                    IField field = (IField)element;
                    if (field.getParent() instanceof IType) {
                        return;
                    }
                    String mn = field.getTypeQualifiedName("$", false).replaceAll("\\$", "::");
                    if (!mn.startsWith("::")) {
                        mn = "::" + mn;
                    }
                    if (provideDollar) {
                        mn = "$" + mn;
                    }
                    if (!choices.contains(mn) && !choices.contains(mn.substring(2))) {
                        fields.add(field);
                        choices.add(mn);
                    }
                }
            }

            private void processTypeFields(List methodNames, List methods, IType type) throws ModelException {
                IField[] tmethods = type.getFields();
                int i = 0;
                while (i < tmethods.length) {
                    String mn = tmethods[i].getTypeQualifiedName("$", false).replaceAll("\\$", "::");
                    if (!mn.startsWith("::")) {
                        mn = "::" + mn;
                    }
                    if (!methodNames.contains(mn)) {
                        methods.add(tmethods[i]);
                        methodNames.add(mn);
                    }
                    ++i;
                }
                IType[] types2 = type.getTypes();
                int i2 = 0;
                while (i2 < types2.length) {
                    this.processTypeFields(methodNames, methods, types2[i2]);
                    ++i2;
                }
            }
        };
        IDLTKLanguageToolkit toolkit = null;
        try {
            toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)this.scriptProject);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        IDLTKSearchScope scope = SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit);
        if (token.length >= 1 && token[0] == '$') {
            char[] token2 = new char[token.length - 1];
            int i = 0;
            while (i < token.length - 1) {
                token2[i] = token[i + 1];
                ++i;
            }
            token = token2;
        }
        String to = new String(token);
        if (token != null && token.length >= 3 && token[0] == ':') {
            String[] tokens = to.split("::");
            if (tokens.length < 2) {
                return;
            }
            String tok = tokens[1];
            try {
                this.search(String.valueOf(tok) + "*", 0, 0, scope, requestor);
                int nonNoneCount = 0;
                String mtok = null;
                int i = 0;
                while (i < tokens.length) {
                    if (tokens[i].length() > 0) {
                        ++nonNoneCount;
                        if (mtok == null) {
                            mtok = tokens[i];
                        }
                    }
                    ++i;
                }
                if (nonNoneCount == 1 && tok.length() >= 2) {
                    this.search(String.valueOf(new String(mtok)) + "*", 2, 0, scope, requestor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (token != null && token.length >= 1 && token[0] != ':') {
            try {
                String[] tokens = to.split("::");
                if (tokens.length == 0) {
                    return;
                }
                String tok = tokens[0];
                this.search(String.valueOf(tok) + "*", 0, 0, scope, requestor);
                int nonNoneCount = 0;
                int i = 0;
                while (i < tokens.length) {
                    if (tokens[i].length() > 0) {
                        ++nonNoneCount;
                    }
                    ++i;
                }
                if (nonNoneCount == 1 && tok.length() >= 2) {
                    this.search(String.valueOf(tok) + "*", 2, 0, scope, requestor);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        this.findTypes(token, true, types);
        this.findFields(token, false, fields, provideDollar ? "$" : "");
    }

    private void findASTVariables(ASTNode node, String prefix, char[] token, boolean canCompleteEmptyToken, List choices) {
        List statements = null;
        String add = "";
        if (node instanceof ModuleDeclaration) {
            statements = ((ModuleDeclaration)node).getStatements();
        } else if (node instanceof TypeDeclaration) {
            statements = ((TypeDeclaration)node).getStatements();
            String nme = ((TypeDeclaration)node).getName();
            add = nme.startsWith("::") ? String.valueOf(nme.substring(2)) + "::" : String.valueOf(nme) + "::";
        }
        if (statements != null) {
            int i = 0;
            while (i < statements.size()) {
                String[] variable;
                ASTNode nde = (ASTNode)statements.get(i);
                if (nde instanceof TclStatement && (variable = TclParseUtils.returnVariable((TclStatement)nde)) != null) {
                    int u = 0;
                    while (u < variable.length) {
                        String prev = this.preProcessVariable(variable[u]).substring(1);
                        String var = String.valueOf(prefix) + add;
                        var = var.endsWith("::") && prev.startsWith("::") ? String.valueOf(var) + prev.substring(2) : String.valueOf(var) + prev;
                        if (!choices.contains(var)) {
                            choices.add(var);
                        }
                        ++u;
                    }
                }
                this.findASTVariables(nde, String.valueOf(prefix) + add, token, canCompleteEmptyToken, choices);
                ++i;
            }
        }
    }

    private void checkVariables(char[] token, boolean canCompleteEmptyToken, int beforePosition, List statements, boolean provideDollar, List gChoices) {
        ArrayList choices = new ArrayList();
        this.checkVariableStatements(beforePosition, choices, statements);
        char[][] cc = new char[choices.size()][];
        int i = 0;
        while (i < choices.size()) {
            cc[i] = ((String)choices.get(i)).toCharArray();
            gChoices.add(choices.get(i));
            ++i;
        }
        this.findLocalVariables(token, cc, canCompleteEmptyToken, provideDollar);
    }

    private void checkVariableStatements(int beforePosition, List choices, List statements) {
        if (statements != null) {
            int i = 0;
            while (i < statements.size()) {
                Expression commandId;
                TclStatement s;
                String[] variable;
                ASTNode node = (ASTNode)statements.get(i);
                if (node instanceof TclStatement && node.sourceEnd() < beforePosition && (variable = TclParseUtils.returnVariable(s = (TclStatement)node)) != null) {
                    int u = 0;
                    while (u < variable.length) {
                        this.checkAddVariable(choices, variable[u]);
                        ++u;
                    }
                }
                if (node instanceof TclStatement && node.sourceStart() < beforePosition && (commandId = (s = (TclStatement)node).getAt(0)) != null && commandId instanceof SimpleReference) {
                    String name = ((SimpleReference)commandId).getName();
                    if (name.equals("if")) {
                        this.processIf(s, beforePosition, choices);
                    } else if (name.equals("while")) {
                        this.processWhile(s, beforePosition, choices);
                    } else if (name.equals("for")) {
                        this.processFor(s, beforePosition, choices);
                    }
                }
                ++i;
            }
        }
    }

    private void processBlock(Expression bl, int beforePosition, List choices) {
        TclBlockExpression block = (TclBlockExpression)bl;
        List code = null;
        code = block.parseBlock(block.sourceStart() + 1);
        this.checkVariableStatements(beforePosition, choices, code);
    }

    private void processFor(TclStatement statement, int beforePosition, List choices) {
        Expression bl;
        int bi;
        Expression bl2;
        List exprs = statement.getExpressions();
        int len = exprs.size();
        if (1 < len && (bl2 = (Expression)exprs.get(1)) instanceof TclBlockExpression) {
            this.processBlock(bl2, beforePosition, choices);
        }
        if ((bi = 4) < len && (bl = (Expression)exprs.get(bi)) instanceof TclBlockExpression) {
            this.processBlock(bl, beforePosition, choices);
        }
    }

    private void processWhile(TclStatement statement, int beforePosition, List choices) {
        Expression bl;
        int bi = 2;
        List exprs = statement.getExpressions();
        int len = exprs.size();
        if (bi < len && (bl = (Expression)exprs.get(bi)) instanceof TclBlockExpression) {
            this.processBlock(bl, beforePosition, choices);
        }
    }

    private void processIf(TclStatement statement, int beforePosition, final List choices) {
        List exprs = statement.getExpressions();
        TclParseUtils.processIf(exprs, null, beforePosition, new TclParseUtils.IProcessStatementAction(){

            public void doAction(String name, Expression bl, int beforePosition) {
                TclCompletionEngine.this.processBlock(bl, beforePosition, choices);
            }
        });
    }

    private void checkAddVariable(List choices, String n) {
        String str = this.preProcessVariable(n);
        if (!choices.contains(str)) {
            choices.add(str);
        }
    }

    private String preProcessVariable(String n) {
        if (n.startsWith("$")) {
            return n;
        }
        String str = n.indexOf(32) != -1 ? "${" + n + '}' : "$" + n;
        return str;
    }

    public IAssistParser getParser() {
        return this.parser;
    }

    protected int getEndOfEmptyToken() {
        return this.actualCompletionPosition;
    }

    protected String processMethodName(IMethod method, String tok) {
        return TclParseUtils.processMethodName(method, tok);
    }

    protected String processFieldName(IField method, String tok) {
        return TclParseUtils.processFieldName(method, tok);
    }

    protected String processTypeName(IType method, String tok) {
        return TclParseUtils.processTypeName(method, tok);
    }
}

