/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.blocks;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ui.text.blocks.Keyword;
import org.eclipse.dltk.ui.text.blocks.KeywordRole;
import org.eclipse.dltk.ui.text.blocks.MultiMap;

public class Block {
    private final Keyword beginning;
    private final Keyword ending;
    private final Keyword[] middles;

    public Block(Keyword beginning, Keyword ending) {
        this(beginning, ending, new Keyword[0]);
    }

    public Block(Keyword beginning, Keyword ending, Keyword[] middles) {
        Assert.isLegal((beginning.getRole() == KeywordRole.BEGINNING ? 1 : 0) != 0);
        Assert.isLegal((ending.getRole() == KeywordRole.ENDING ? 1 : 0) != 0);
        this.beginning = beginning;
        this.ending = ending;
        this.middles = middles;
    }

    public String getBeginningRegularExpression() {
        return this.beginning.getPattern();
    }

    public Collection getMiddleRegularExpressions() {
        ArrayList<String> parts = new ArrayList<String>(this.middles.length);
        int i = 0;
        while (i < this.middles.length) {
            Keyword item = this.middles[i];
            parts.add(item.getPattern());
            ++i;
        }
        return parts;
    }

    public String getEndingRegularExpression() {
        return this.ending.getPattern();
    }

    public Keyword getBeginning() {
        return this.beginning;
    }

    public Keyword getEnding() {
        return this.ending;
    }

    public Keyword[] getMiddleKeywords() {
        return this.middles;
    }

    public String toString() {
        return this.beginning.toString();
    }

    public void install(MultiMap allNames) {
        allNames.put(this.beginning, this);
        allNames.put(this.ending, this);
        int i = 0;
        while (i < this.middles.length) {
            allNames.put(this.middles[i], this);
            ++i;
        }
    }
}

