/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.ast.references.VariableKind;

public interface IElementKind {
    public static final int FIRST_NON_VARIABLE_ID = 101;
    public static final int LAST_CORE_ID = 151;
    public static final int LAST_ID = 201;
    public static final IElementKind MODEL = new Method();
    public static final IElementKind METHOD = new Method();
    public static final IElementKind CLASS = new Class();
    public static final IElementKind MIXIN = new Mixin();
    public static final IElementKind CLASS_FRAGMENT = new ClassFragment();
    public static final IElementKind MIXIN_FRAGMENT = new MixinFragment();
    public static final IElementKind LOCAL_VARIABLE = Variable.byVariableKind(VariableKind.LOCAL);
    public static final IElementKind INSTANCE_VARIABLE = Variable.byVariableKind(VariableKind.INSTANCE);
    public static final IElementKind CLASS_VARIABLE = Variable.byVariableKind(VariableKind.CLASS);
    public static final IElementKind GLOBAL_VARIABLE = Variable.byVariableKind(VariableKind.GLOBAL);
    public static final IElementKind MIXIN_VARIABLE = Variable.byVariableKind(VariableKind.MIXIN);
    public static final IElementKind ARGUMENT_VARIABLE = Variable.byVariableKind(VariableKind.ARGUMENT);

    public int getId();

    public static class Class
    extends ClassLike {
        public static final int ID = 104;

        public int getId() {
            return 104;
        }
    }

    public static class ClassFragment
    extends Fragment {
        public static final int ID = 106;

        public int getId() {
            return 106;
        }
    }

    public static abstract class ClassLike
    implements IElementKind {
    }

    public static abstract class Fragment
    implements IElementKind {
    }

    public static class Method
    implements IElementKind {
        public static final int ID = 103;

        public int getId() {
            return 103;
        }
    }

    public static class Mixin
    extends ClassLike {
        public static final int ID = 105;

        public int getId() {
            return 105;
        }
    }

    public static class MixinFragment
    extends Fragment {
        public static final int ID = 107;

        public int getId() {
            return 107;
        }
    }

    public static class Model
    implements IElementKind {
        public static final int ID = 101;

        public int getId() {
            return 101;
        }
    }

    public static class Unit
    implements IElementKind {
        public static final int ID = 102;

        public int getId() {
            return 102;
        }
    }

    public static class Variable
    implements IElementKind {
        private final VariableKind kind;
        protected static final Map variableKindsToElementKinds = new HashMap();

        static {
            variableKindsToElementKinds.put(VariableKind.LOCAL, new Variable(VariableKind.LOCAL));
            variableKindsToElementKinds.put(VariableKind.INSTANCE, new Variable(VariableKind.INSTANCE));
            variableKindsToElementKinds.put(VariableKind.CLASS, new Variable(VariableKind.CLASS));
            variableKindsToElementKinds.put(VariableKind.GLOBAL, new Variable(VariableKind.GLOBAL));
            variableKindsToElementKinds.put(VariableKind.MIXIN, new Variable(VariableKind.MIXIN));
            variableKindsToElementKinds.put(VariableKind.ARGUMENT, new Variable(VariableKind.ARGUMENT));
        }

        public Variable(VariableKind kind) {
            this.kind = kind;
        }

        public VariableKind getKind() {
            return this.kind;
        }

        public int getId() {
            return this.kind.getId();
        }

        public static Variable byVariableKind(VariableKind kind) {
            return (Variable)variableKindsToElementKinds.get(kind);
        }
    }
}

