/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.internal.core.util.Messages;

public class RubyLanguageToolkit
implements IDLTKLanguageToolkit {
    protected static RubyLanguageToolkit sToolkit = new RubyLanguageToolkit();

    public IStatus validateSourceModule(String name) {
        if (name == null) {
            return new Status(4, "org.eclipse.dltk.ruby.core", -1, Messages.convention_unit_nullName, null);
        }
        if (!this.isRubyLikeFileName(name)) {
            return new Status(4, "org.eclipse.dltk.ruby.core", -1, MessageFormat.format(Messages.convention_unit_notScriptName, this.getRubyExtension(), "Ruby"), null);
        }
        return IModelStatus.VERIFIED_OK;
    }

    public String getRubyExtension() {
        return "rb";
    }

    protected boolean isRubyLikeFileName(String name) {
        return name.endsWith("." + this.getRubyExtension());
    }

    public boolean languageSupportZIPBuildpath() {
        return false;
    }

    public boolean validateSourcePackage(IPath path) {
        return true;
    }

    public String getNatureId() {
        return "org.eclipse.dltk.ruby.core.nature";
    }

    public IStatus validateSourceModule(IResource resource) {
        if (resource == null || resource.getLocation() == null) {
            return new Status(4, "org.eclipse.dltk.ruby.core", 1, "Resource passed to validateSourceModule() is null", null);
        }
        if ("rakefile".equalsIgnoreCase(resource.getLocation().lastSegment())) {
            return IModelStatus.VERIFIED_OK;
        }
        return this.validateSourceModule(resource.getName());
    }

    public IStatus validateSourceModule(IPath resource) {
        if (resource.toString().startsWith("#special#builtin#")) {
            return IModelStatus.VERIFIED_OK;
        }
        return this.validateSourceModule(resource.lastSegment());
    }

    public IStatus validateSourceModule(IModelElement parent, String str) {
        return this.validateSourceModule(str);
    }

    public IStatus validateSourceModuleName(String str) {
        return this.validateSourceModule(str);
    }

    public String getDelimeterReplacerString() {
        return ".";
    }

    public static IDLTKLanguageToolkit getDefault() {
        return sToolkit;
    }

    public String[] getLanguageFileExtensions() {
        return new String[]{"rb"};
    }

    public String getLanguageName() {
        return "Ruby";
    }
}

