/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.actions.FoldingActionGroup;
import org.eclipse.dltk.internal.ui.editor.BracketInserter;
import org.eclipse.dltk.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.ScriptOutlinePage;
import org.eclipse.dltk.internal.ui.editor.ToggleCommentAction;
import org.eclipse.dltk.ruby.core.RubyLanguageToolkit;
import org.eclipse.dltk.ruby.internal.ui.RubyUI;
import org.eclipse.dltk.ruby.internal.ui.editor.IRubyEditorListener;
import org.eclipse.dltk.ruby.internal.ui.editor.RubyBracketInserter;
import org.eclipse.dltk.ruby.internal.ui.editor.RubyDocumentSetupParticipant;
import org.eclipse.dltk.ruby.internal.ui.editor.RubyOutlinePage;
import org.eclipse.dltk.ruby.internal.ui.text.RubyPairMatcher;
import org.eclipse.dltk.ruby.internal.ui.text.folding.RubyFoldingStructureProvider;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;

public class RubyEditor
extends ScriptEditor {
    public static final String EDITOR_ID = "org.eclipse.dltk.ruby.ui.editor.RubyEditor";
    public static final String EDITOR_CONTEXT = "#RubyEditorContext";
    public static final String RULER_CONTEXT = "#RubyRulerContext";
    private BracketInserter fBracketInserter = new RubyBracketInserter(this);
    private RubyPairMatcher bracketMatcher = new RubyPairMatcher("{}[]()".toCharArray());
    private IFoldingStructureProvider fFoldingProvider = null;
    private static ListenerList doSetInputListeners = new ListenerList();

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId(EDITOR_CONTEXT);
        this.setRulerContextMenuId(RULER_CONTEXT);
    }

    protected IPreferenceStore getScriptPreferenceStore() {
        return RubyUI.getDefault().getPreferenceStore();
    }

    public ScriptTextTools getTextTools() {
        return RubyUI.getDefault().getTextTools();
    }

    protected ScriptOutlinePage doCreateOutlinePage() {
        return new RubyOutlinePage(this, RubyUI.getDefault().getPreferenceStore());
    }

    protected void connectPartitioningToElement(IEditorInput input, IDocument document) {
        IDocumentExtension3 extension;
        if (document instanceof IDocumentExtension3 && (extension = (IDocumentExtension3)document).getDocumentPartitioner("__ruby_partitioning") == null) {
            RubyDocumentSetupParticipant participant = new RubyDocumentSetupParticipant();
            participant.setup(document);
        }
    }

    protected IFoldingStructureProvider getFoldingStructureProvider() {
        if (this.fFoldingProvider == null) {
            this.fFoldingProvider = new RubyFoldingStructureProvider();
        }
        return this.fFoldingProvider;
    }

    protected FoldingActionGroup createFoldingActionGroup() {
        return new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getViewer(), RubyUI.getDefault().getPreferenceStore());
    }

    public String getEditorId() {
        return EDITOR_ID;
    }

    public IDLTKLanguageToolkit getLanguageToolkit() {
        return RubyLanguageToolkit.getDefault();
    }

    public String getCallHierarchyID() {
        return "org.eclipse.dltk.callhierarchy.view";
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.dltk.ui.rubyEditorScope"});
    }

    protected void createActions() {
        super.createActions();
        TextOperationAction action = new TextOperationAction(DLTKEditorMessages.getBundleForConstructedKeys(), "Comment.", (ITextEditor)this, 11);
        action.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.comment");
        this.setAction("Comment", (IAction)action);
        this.markAsStateDependentAction("Comment", true);
        action = new TextOperationAction(DLTKEditorMessages.getBundleForConstructedKeys(), "Uncomment.", (ITextEditor)this, 12);
        action.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.uncomment");
        this.setAction("Uncomment", (IAction)action);
        this.markAsStateDependentAction("Uncomment", true);
        action = new ToggleCommentAction(DLTKEditorMessages.getBundleForConstructedKeys(), "ToggleComment.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.toggle.comment");
        this.setAction("ToggleComment", (IAction)action);
        this.markAsStateDependentAction("ToggleComment", true);
        ISourceViewer sourceViewer = this.getSourceViewer();
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        ((ToggleCommentAction)action).configure(sourceViewer, configuration);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        boolean closeBrackets = true;
        boolean closeStrings = true;
        boolean closeAngularBrackets = false;
        this.fBracketInserter.setCloseBracketsEnabled(closeBrackets);
        this.fBracketInserter.setCloseStringsEnabled(closeStrings);
        this.fBracketInserter.setCloseAngularBracketsEnabled(closeAngularBrackets);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
    }

    public static void addListener(IRubyEditorListener listener) {
        doSetInputListeners.add((Object)listener);
    }

    public static void removeListener(IRubyEditorListener listener) {
        doSetInputListeners.remove((Object)listener);
    }

    protected void notifyDoSetInput(IModelElement element) {
        Object[] listeners2 = doSetInputListeners.getListeners();
        int i = 0;
        while (i < listeners2.length) {
            IRubyEditorListener listener = (IRubyEditorListener)listeners2[i];
            if (listener != null) {
                listener.notifyDoSetInput(element);
            }
            ++i;
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        IModelElement element = this.getInputModelElement();
        if (element != null) {
            this.notifyDoSetInput(element);
        }
    }

    public void dispose() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).removeVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        super.dispose();
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.bracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("editor.matching_brackets", "editor.matching_brackets_color");
        super.configureSourceViewerDecorationSupport(support);
    }
}

