/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.breakpoints;

public class DbgpBreakpointConfig {
    private static final String TEMPORARY_TRUE = "1";
    private static final String TEMPORARY_FALSE = "0";
    private static final String STATE_ENABLED = "enabled";
    private static final String STATE_DISABLED = "disabled";
    private static final String HIT_CONDITION_GREATER = ">=";
    private static final String HIT_CONDITION_EQUAL = "==";
    private static final String HIT_CONDITION_MULTIPLE = "%";
    private boolean enabled;
    private boolean temporary;
    private int hitValue;
    private int hitCondition;
    private String expression;

    public DbgpBreakpointConfig() {
        this(true);
    }

    public DbgpBreakpointConfig(boolean enabled) {
        this(enabled, -1, -1, null);
    }

    public DbgpBreakpointConfig(boolean enabled, int hitValue, int hitCondition, String expression) {
        this(enabled, hitValue, hitCondition, false, expression);
    }

    public DbgpBreakpointConfig(boolean enabled, int hitValue, int hitCondition, boolean temporary, String expression) {
        this.enabled = enabled;
        this.hitValue = hitValue;
        this.hitCondition = hitCondition;
        this.temporary = temporary;
        this.expression = expression;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean value) {
        this.temporary = value;
    }

    public int getHitValue() {
        return this.hitValue;
    }

    public void setHitValue(int hitValue) {
        this.hitValue = hitValue;
    }

    public int getHitCondition() {
        return this.hitCondition;
    }

    public void setHitCondition(int hitCondition) {
        this.hitCondition = hitCondition;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getTemporaryString() {
        return this.temporary ? TEMPORARY_TRUE : TEMPORARY_FALSE;
    }

    public String getStateString() {
        return this.enabled ? STATE_ENABLED : STATE_DISABLED;
    }

    public String getHitConditionString() {
        if (this.hitCondition == 1) {
            return HIT_CONDITION_EQUAL;
        }
        if (this.hitCondition == 0) {
            return HIT_CONDITION_GREATER;
        }
        if (this.hitCondition == 2) {
            return HIT_CONDITION_MULTIPLE;
        }
        return null;
    }
}

