/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.core.externalchecker;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.validators.internal.core.externalchecker.CustomWildcard;
import org.eclipse.dltk.validators.internal.core.externalchecker.ExternalCheckerProblem;
import org.eclipse.dltk.validators.internal.core.externalchecker.Rule;
import org.eclipse.dltk.validators.internal.core.externalchecker.WildcardException;
import org.eclipse.dltk.validators.internal.core.externalchecker.WildcardToken;

public class WildcardMatcher {
    private List tokenList = new ArrayList();
    private List wcards;

    public WildcardMatcher(List wcards) {
        this.wcards = wcards;
    }

    public ExternalCheckerProblem match(Rule pattern, String input) throws WildcardException {
        this.tokenList = this.parseWildcard(pattern.getDescription());
        String bigpattern = WildcardMatcher.makeBigPattern(pattern.getDescription(), this.wcards);
        Pattern pat = Pattern.compile(bigpattern);
        Matcher matcher = pat.matcher(input);
        if (matcher.matches()) {
            String fileName = null;
            int lineNumber = -1;
            String message = "";
            Pattern lPattern = Pattern.compile(WildcardMatcher.getPattern('n', this.wcards));
            Pattern mPattern = Pattern.compile(WildcardMatcher.getPattern('m', this.wcards));
            Pattern fPattern = Pattern.compile(WildcardMatcher.getPattern('f', this.wcards));
            int i = 1;
            while (i <= matcher.groupCount()) {
                if (matcher.group(i) != null) {
                    String group = matcher.group(i);
                    Matcher lMatch = lPattern.matcher(group);
                    if (lMatch.find()) {
                        lineNumber = new Integer(lMatch.group());
                    } else {
                        Matcher fMatch = fPattern.matcher(group);
                        if (fMatch.find() && fileName == null) {
                            fileName = fMatch.group();
                        } else {
                            Matcher mMatch = mPattern.matcher(group);
                            if (mMatch.find()) {
                                message = mMatch.group();
                            }
                        }
                    }
                }
                ++i;
            }
            if (message == null) {
                message = input;
            }
            ExternalCheckerProblem problem = new ExternalCheckerProblem(pattern.getType(), message, lineNumber, fileName);
            return problem;
        }
        return null;
    }

    public ArrayList parseWildcard(String wildcard) {
        ArrayList<WildcardToken> list = new ArrayList<WildcardToken>();
        StringBuffer sb = new StringBuffer();
        boolean sbstatus = false;
        int j = 0;
        while (j < wildcard.length()) {
            if (wildcard.charAt(j) == '%') {
                if (sbstatus) {
                    list.add(new WildcardToken("string", sb.toString()));
                    sbstatus = false;
                    sb.delete(0, sb.length());
                }
                list.add(new WildcardToken("wcard", this.recognizeWildcard(wildcard.charAt(j + 1))));
                ++j;
            } else {
                sbstatus = true;
                sb.append(wildcard.charAt(j));
            }
            ++j;
        }
        if (sbstatus) {
            list.add(new WildcardToken("string", sb.toString()));
            sbstatus = false;
            sb.delete(0, sb.length());
        }
        return list;
    }

    public String recognizeWildcard(char symbol) {
        int i = 0;
        while (i < this.wcards.size()) {
            CustomWildcard card = (CustomWildcard)this.wcards.get(i);
            if (card.getLetter().indexOf(symbol) != -1) {
                return card.getLetter();
            }
            ++i;
        }
        return null;
    }

    private static String makeBigPattern(String input, List wcards) {
        boolean status = false;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c != '%') {
                if (!status) {
                    status = true;
                }
                if (Character.isWhitespace(c)) {
                    sb.append("[\\s]+");
                } else {
                    sb.append(c);
                }
            } else {
                String pattern = WildcardMatcher.getPattern(input.charAt(i + 1), wcards);
                if (pattern == null) {
                    pattern = "";
                }
                sb.append("(");
                sb.append(pattern);
                sb.append(")");
                ++i;
                status = false;
            }
            ++i;
        }
        if (status) {
            sb.append(")");
        }
        sb.append(".*");
        return sb.toString();
    }

    private static String getPattern(char c, List wcards) {
        String s = null;
        int i = 0;
        while (i < wcards.size()) {
            CustomWildcard cwcard = (CustomWildcard)wcards.get(i);
            if (cwcard.getLetter().indexOf(c) != -1) {
                s = cwcard.getSpattern();
            }
            ++i;
        }
        return s;
    }

    private int getIndexOfLineNumber() {
        int i = 0;
        while (i < this.tokenList.size()) {
            WildcardToken tok = (WildcardToken)this.tokenList.get(i);
            String value = (String)tok.getValue();
            if (value.equals("n")) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

