/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class OpenActionUtil {
    private OpenActionUtil() {
    }

    public static void open(Object element) throws ModelException, PartInitException {
        OpenActionUtil.open(element, true);
    }

    public static void open(Object element, boolean activate) throws ModelException, PartInitException {
        IEditorPart part = EditorUtility.openInEditor(element, activate);
        if (element instanceof IModelElement) {
            EditorUtility.revealInEditor(part, (IModelElement)element);
        }
    }

    public static List filterResolveResults(IModelElement[] codeResolveResults) {
        int nResults = codeResolveResults.length;
        ArrayList<IModelElement> refs = new ArrayList<IModelElement>(nResults);
        int i = 0;
        while (i < nResults) {
            if (codeResolveResults[i] instanceof ISourceReference) {
                refs.add(codeResolveResults[i]);
            }
            ++i;
        }
        return refs;
    }

    public static IModelElement selectModelElement(IModelElement[] elements, Shell shell, String title, String message) {
        Object[] selection;
        int nResults = elements.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return elements[0];
        }
        int flags = ModelElementLabelProvider.SHOW_DEFAULT | 0x1000;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new ModelElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements((Object[])elements);
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            nResults = selection.length;
            int i = 0;
            while (i < nResults) {
                Object current = selection[i];
                if (current instanceof IModelElement) {
                    return (IModelElement)current;
                }
                ++i;
            }
        }
        return null;
    }
}

