/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.actions;

import org.eclipse.debug.ui.DebugPopup;
import org.eclipse.dltk.internal.debug.ui.actions.ScriptDisplayAction;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class PopupScriptDisplayAction
extends ScriptDisplayAction {
    private void showPopup(StyledText textWidget, String message) {
        DisplayPopup displayPopup = new DisplayPopup(message, this.getShell(), PopupScriptDisplayAction.getPopupAnchor(textWidget));
        displayPopup.open();
    }

    protected void displayStringResult(String currentSnippet, final String currentResultString) {
        IWorkbenchPart part = this.getPart();
        final StyledText textWidget = PopupScriptDisplayAction.getStyledText(part);
        if (textWidget != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    PopupScriptDisplayAction.this.showPopup(textWidget, currentResultString);
                }
            });
            this.evaluationCleanup();
        }
    }

    private static class DisplayPopup
    extends DebugPopup {
        private String message;

        public DisplayPopup(String message, Shell shell, Point anchor) {
            super(shell, anchor, null);
            this.message = message;
        }

        protected String getActionText() {
            return "Move to Display View";
        }

        protected Control createDialogArea(Composite parent) {
            GridData gd = new GridData(1808);
            StyledText text = new StyledText(parent, 842);
            text.setLayoutData((Object)gd);
            text.setForeground(parent.getDisplay().getSystemColor(28));
            text.setBackground(parent.getDisplay().getSystemColor(29));
            text.setText(this.message);
            return text;
        }
    }
}

