/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.typehierarchy;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.internal.ui.actions.OpenActionUtil;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class OpenTypeHierarchyUtil {
    private OpenTypeHierarchyUtil() {
    }

    public static TypeHierarchyViewPart open(IModelElement element, IWorkbenchWindow window) {
        IModelElement[] candidates = OpenTypeHierarchyUtil.getCandidates(element);
        if (candidates != null) {
            return OpenTypeHierarchyUtil.open(candidates, window);
        }
        return null;
    }

    public static TypeHierarchyViewPart open(IModelElement[] candidates, IWorkbenchWindow window) {
        Assert.isTrue((candidates != null && candidates.length != 0 ? 1 : 0) != 0);
        IModelElement input = null;
        if (candidates.length > 1) {
            String title = DLTKUIMessages.OpenTypeHierarchyUtil_selectionDialog_title;
            String message = DLTKUIMessages.OpenTypeHierarchyUtil_selectionDialog_message;
            input = OpenActionUtil.selectModelElement(candidates, window.getShell(), title, message);
        } else {
            input = candidates[0];
        }
        if (input == null) {
            return null;
        }
        return OpenTypeHierarchyUtil.openInViewPart(window, input);
    }

    private static TypeHierarchyViewPart openInViewPart(IWorkbenchWindow window, IModelElement input) {
        IWorkbenchPage page = window.getActivePage();
        try {
            TypeHierarchyViewPart result = (TypeHierarchyViewPart)page.findView("org.eclipse.dltk.ui.TypeHierarchy");
            if (result != null) {
                result.clearNeededRefresh();
            }
            result = (TypeHierarchyViewPart)page.showView("org.eclipse.dltk.ui.TypeHierarchy");
            result.setInputElement(input);
            return result;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, window.getShell(), DLTKUIMessages.OpenTypeHierarchyUtil_error_open_view, e.getMessage());
            return null;
        }
    }

    private static void openEditor(Object input, boolean activate) throws PartInitException, ModelException {
        IEditorPart part = EditorUtility.openInEditor(input, activate);
        if (input instanceof IModelElement) {
            EditorUtility.revealInEditor(part, (IModelElement)input);
        }
    }

    public static IModelElement[] getCandidates(Object input) {
        if (!(input instanceof IModelElement)) {
            return null;
        }
        try {
            IModelElement elem = (IModelElement)input;
            switch (elem.getElementType()) {
                case 2: 
                case 7: 
                case 8: 
                case 9: {
                    return new IModelElement[]{elem};
                }
                case 5: {
                    IType[] types;
                    ISourceModule cu = (ISourceModule)elem.getAncestor(5);
                    if (cu != null && (types = cu.getTypes()).length > 0) {
                        return types;
                    }
                    break;
                }
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
        return null;
    }
}

